/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.data.adapters.risetovise;

import com.vmware.cis.data.api.Query;
import com.vmware.cis.data.api.ResourceItem;
import com.vmware.cis.data.api.ResultSet;
import com.vmware.vise.data.adapters.risetovise.RiseToViseKeyAdapter;
import com.vmware.vise.data.adapters.risetovise.RiseToViseProperty;
import com.vmware.vise.data.query.ObjectReferenceService;
import com.vmware.vise.data.query.PropertyValue;
import com.vmware.vise.data.query.ResultItem;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.commons.lang.ArrayUtils;

final class RiseToViseResult {
    private static final ResultSet EMPTY_RESULT = new ResultSet(null, null, Integer.valueOf(0));
    private final ObjectReferenceService _referenceService;
    private final RiseToViseKeyAdapter _modelKeyAdapter;
    private final RiseToViseProperty _propertyConverter;

    public RiseToViseResult(ObjectReferenceService objectReferenceService, RiseToViseKeyAdapter riseToViseKeyAdapter, RiseToViseProperty riseToViseProperty) {
        assert (objectReferenceService != null);
        assert (riseToViseKeyAdapter != null);
        assert (riseToViseProperty != null);
        this._referenceService = objectReferenceService;
        this._modelKeyAdapter = riseToViseKeyAdapter;
        this._propertyConverter = riseToViseProperty;
    }

    public ResultSet fromViseResult(com.vmware.vise.data.query.ResultSet resultSet, Query query) {
        Integer n;
        assert (query != null);
        if (resultSet == null) {
            return EMPTY_RESULT;
        }
        if (resultSet.error != null) {
            throw RiseToViseResult.toRuntimeException(resultSet.error);
        }
        Integer n2 = n = query.getWithTotalCount() ? resultSet.totalMatchedObjectCount : null;
        if (ArrayUtils.isEmpty((Object[])resultSet.items)) {
            return new ResultSet(null, null, n);
        }
        ArrayList<ResourceItem> arrayList = new ArrayList<ResourceItem>(resultSet.items.length);
        String[] stringArray = this.toViseProperties(query.getProperties());
        for (ResultItem resultItem : resultSet.items) {
            ResourceItem resourceItem = this.fromResultItem(resultItem, stringArray);
            arrayList.add(resourceItem);
        }
        return new ResultSet(query.getProperties(), arrayList, n);
    }

    private ResourceItem fromResultItem(ResultItem resultItem, String[] stringArray) {
        assert (resultItem != null);
        assert (stringArray != null);
        ArrayList<Object> arrayList = new ArrayList<Object>(stringArray.length);
        for (String string : stringArray) {
            Object object = this.getPropertyValue(resultItem, string);
            arrayList.add(object);
        }
        return new ResourceItem(arrayList);
    }

    private Object getPropertyValue(ResultItem resultItem, String string) {
        assert (resultItem != null);
        assert (string != null);
        if (resultItem.properties == null) {
            return null;
        }
        if ("@modelKey".equals(string)) {
            return this._modelKeyAdapter.toModelKey(resultItem.resourceObject);
        }
        if ("@type".equals(string)) {
            return this._referenceService.getResourceObjectType(resultItem.resourceObject);
        }
        for (PropertyValue propertyValue : resultItem.properties) {
            if (!string.equals(propertyValue.propertyName)) continue;
            return propertyValue.value;
        }
        return null;
    }

    private String[] toViseProperties(Collection<String> collection) {
        String[] stringArray = new String[collection.size()];
        int n = 0;
        for (String string : collection) {
            stringArray[n++] = this.toViseProperty(string);
        }
        return stringArray;
    }

    private String toViseProperty(String string) {
        return this._propertyConverter.toViseProperty(string);
    }

    private static RuntimeException toRuntimeException(Exception exception) {
        if (exception instanceof RuntimeException) {
            return (RuntimeException)exception;
        }
        return new RuntimeException(exception);
    }
}

