/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.data.adapters.risetovise;

import com.google.common.collect.ImmutableSet;
import com.vmware.cis.data.api.Filter;
import com.vmware.cis.data.api.LogicalOperator;
import com.vmware.cis.data.api.PropertyPredicate;
import com.vmware.cis.data.api.Query;
import com.vmware.cis.data.internal.provider.util.filter.OperatorLikeEvaluator;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.data.Constraint;
import com.vmware.vise.data.adapters.risetovise.RiseToViseKeyAdapter;
import com.vmware.vise.data.adapters.risetovise.RiseToViseProperty;
import com.vmware.vise.data.query.Comparator;
import com.vmware.vise.data.query.CompositeConstraint;
import com.vmware.vise.data.query.Conjoiner;
import com.vmware.vise.data.query.ObjectIdentityConstraint;
import com.vmware.vise.data.query.ObjectReferenceService;
import com.vmware.vise.data.query.PropertyConstraint;
import com.vmware.vise.data.query.RelationalConstraint;
import com.vmware.vise.data.uri.VapiUriSchemeUtil;
import java.net.URI;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;

final class RiseToViseWhereClause {
    private static final Set<String> DS2_MODELS_CLASH_WITH_DS1_AGGREGATED_TYPES = ImmutableSet.of((Object)"ResourcePool", (Object)"ComputeResource", (Object)"DistributedVirtualSwitch");
    private final ObjectReferenceService _referenceService;
    private final RiseToViseKeyAdapter _modelKeyAdapter;
    private final RiseToViseProperty _propertyConverter;

    public RiseToViseWhereClause(ObjectReferenceService objectReferenceService, RiseToViseKeyAdapter riseToViseKeyAdapter, RiseToViseProperty riseToViseProperty) {
        assert (objectReferenceService != null);
        assert (riseToViseKeyAdapter != null);
        assert (riseToViseProperty != null);
        this._referenceService = objectReferenceService;
        this._modelKeyAdapter = riseToViseKeyAdapter;
        this._propertyConverter = riseToViseProperty;
    }

    public Constraint toConstraint(Query query, String string) {
        assert (query != null);
        assert (string != null);
        Constraint constraint = this.toConstraint(query.getFilter(), string);
        if (RiseToViseWhereClause.shouldAddAtTypePropertyConstraint(query)) {
            return RiseToViseWhereClause.withAtTypePropertyConstraint(constraint, string);
        }
        return constraint;
    }

    private Constraint toConstraint(Filter filter, String string) {
        assert (string != null);
        if (filter == null) {
            Constraint constraint = new Constraint();
            constraint.targetType = string;
            return constraint;
        }
        assert (!filter.getCriteria().isEmpty());
        List list = filter.getCriteria();
        if (list.size() == 1) {
            return this.toConstraint(string, (PropertyPredicate)list.get(0));
        }
        CompositeConstraint compositeConstraint = new CompositeConstraint();
        compositeConstraint.targetType = string;
        compositeConstraint.conjoiner = RiseToViseWhereClause.toConjoiner(filter.getOperator());
        compositeConstraint.nestedConstraints = new Constraint[list.size()];
        int n = 0;
        for (PropertyPredicate propertyPredicate : list) {
            Constraint constraint = this.toConstraint(string, propertyPredicate);
            compositeConstraint.nestedConstraints[n++] = constraint;
        }
        return compositeConstraint;
    }

    private Constraint toConstraint(String string, PropertyPredicate propertyPredicate) {
        return this.toConstraint(string, propertyPredicate.getProperty(), propertyPredicate.getOperator(), propertyPredicate.getComparableValue(), propertyPredicate.isIgnoreCase());
    }

    private Constraint toConstraint(String string, String string2, PropertyPredicate.ComparisonOperator comparisonOperator, Object object, boolean bl) {
        assert (string != null);
        assert (string2 != null);
        assert (comparisonOperator != null);
        assert (object != null);
        if ("@modelKey".equals(string2)) {
            return this.toConstraintForModelKey(string, comparisonOperator, object);
        }
        if (this.isForeignKeyValue(object)) {
            return this.toConstraintForForeignKey(string, string2, comparisonOperator, object);
        }
        if (PropertyPredicate.ComparisonOperator.LIKE.equals((Object)comparisonOperator)) {
            return this.toConstraintForOperatorLike(string, string2, object, bl);
        }
        if (PropertyPredicate.ComparisonOperator.UNSET.equals((Object)comparisonOperator)) {
            return this.toConstraintForOperatorUnset(string, string2, object);
        }
        return this.toPropertyConstraints(string, string2, comparisonOperator, object);
    }

    private Constraint toConstraintForOperatorLike(String string, String string2, Object object, boolean bl) {
        String string3 = (String)object;
        OperatorLikeEvaluator.StringMatchingInfo stringMatchingInfo = OperatorLikeEvaluator.analyzeTemplate((String)string3);
        PropertyConstraint propertyConstraint = new PropertyConstraint();
        propertyConstraint.targetType = string;
        propertyConstraint.propertyName = this.toViseProperty(string2);
        propertyConstraint.comparator = RiseToViseWhereClause.toComparator(stringMatchingInfo.getMode());
        propertyConstraint.comparableValue = stringMatchingInfo.getSearchText();
        return propertyConstraint;
    }

    private Constraint toConstraintForOperatorUnset(String string, String string2, Object object) {
        Boolean bl = (Boolean)object;
        PropertyConstraint propertyConstraint = new PropertyConstraint();
        propertyConstraint.targetType = string;
        propertyConstraint.propertyName = this.toViseProperty(string2);
        propertyConstraint.comparator = bl != false ? Comparator.EQUALS : Comparator.NOT_EQUALS;
        propertyConstraint.comparableValue = "NULL";
        return propertyConstraint;
    }

    private Constraint toConstraintForModelKey(String string, PropertyPredicate.ComparisonOperator comparisonOperator, Object object) {
        if (!PropertyPredicate.ComparisonOperator.EQUAL.equals((Object)comparisonOperator) && !PropertyPredicate.ComparisonOperator.IN.equals((Object)comparisonOperator)) {
            throw new IllegalArgumentException("Invalid comparison operator for model key: " + comparisonOperator);
        }
        return this.toObjectIdentityConstraintsForModelKey(string, object);
    }

    private Constraint toObjectIdentityConstraintsForModelKey(String string, Object object) {
        if (!(object instanceof Collection)) {
            return this.toObjectIdentityConstraintForModelKey(string, object);
        }
        Collection collection = (Collection)object;
        if (collection.size() == 1) {
            return this.toObjectIdentityConstraintForModelKey(string, collection.iterator().next());
        }
        CompositeConstraint compositeConstraint = new CompositeConstraint();
        compositeConstraint.targetType = string;
        compositeConstraint.conjoiner = Conjoiner.OR;
        compositeConstraint.nestedConstraints = new Constraint[collection.size()];
        int n = 0;
        for (Object e : collection) {
            compositeConstraint.nestedConstraints[n++] = this.toObjectIdentityConstraintForModelKey(string, e);
        }
        return compositeConstraint;
    }

    private Constraint toObjectIdentityConstraintForModelKey(String string, Object object) {
        ObjectIdentityConstraint objectIdentityConstraint = new ObjectIdentityConstraint();
        objectIdentityConstraint.target = this._modelKeyAdapter.toReference(object, string);
        return objectIdentityConstraint;
    }

    private Constraint toConstraintForForeignKey(String string, String string2, PropertyPredicate.ComparisonOperator comparisonOperator, Object object) {
        if (!PropertyPredicate.ComparisonOperator.EQUAL.equals((Object)comparisonOperator) && !PropertyPredicate.ComparisonOperator.IN.equals((Object)comparisonOperator)) {
            throw new IllegalArgumentException("Invalid comparison operator for foreign key: " + comparisonOperator);
        }
        RelationalConstraint relationalConstraint = new RelationalConstraint();
        relationalConstraint.targetType = string;
        relationalConstraint.relation = this.toViseProperty(string2);
        relationalConstraint.constraintOnRelatedObject = this.toObjectIdentityConstraints(object);
        return relationalConstraint;
    }

    private boolean isForeignKeyValue(Object object) {
        if (object instanceof Collection) {
            Collection collection = (Collection)object;
            assert (!collection.isEmpty());
            Object e = collection.iterator().next();
            return this.isForeignKeyValue(e);
        }
        if (object instanceof ManagedObjectReference) {
            return true;
        }
        if (object instanceof URI) {
            URI uRI = (URI)object;
            if (VapiUriSchemeUtil.isVapiUri((URI)uRI)) {
                return true;
            }
            String string = this._referenceService.getResourceObjectType((Object)uRI);
            return string != null;
        }
        if (object instanceof String) {
            return false;
        }
        if (object instanceof Number) {
            return false;
        }
        if (object instanceof Boolean) {
            return false;
        }
        String string = this._referenceService.getResourceObjectType(object);
        return string != null;
    }

    private Constraint toPropertyConstraints(String string, String string2, PropertyPredicate.ComparisonOperator comparisonOperator, Object object) {
        if (!PropertyPredicate.ComparisonOperator.IN.equals((Object)comparisonOperator)) {
            return this.toPropertyConstraint(string, string2, comparisonOperator, object);
        }
        Collection collection = (Collection)object;
        if (collection.size() == 1) {
            return this.toPropertyConstraint(string, string2, PropertyPredicate.ComparisonOperator.EQUAL, collection.iterator().next());
        }
        CompositeConstraint compositeConstraint = new CompositeConstraint();
        compositeConstraint.targetType = string;
        compositeConstraint.conjoiner = Conjoiner.OR;
        compositeConstraint.nestedConstraints = new Constraint[collection.size()];
        int n = 0;
        for (Object e : collection) {
            compositeConstraint.nestedConstraints[n++] = this.toPropertyConstraint(string, string2, PropertyPredicate.ComparisonOperator.EQUAL, e);
        }
        return compositeConstraint;
    }

    private Constraint toObjectIdentityConstraints(Object object) {
        if (!(object instanceof Collection)) {
            return this.toObjectIdentityConstaint(object);
        }
        Collection collection = (Collection)object;
        if (collection.size() == 1) {
            return this.toObjectIdentityConstaint(collection.iterator().next());
        }
        CompositeConstraint compositeConstraint = new CompositeConstraint();
        compositeConstraint.conjoiner = Conjoiner.OR;
        compositeConstraint.nestedConstraints = new Constraint[collection.size()];
        int n = 0;
        for (Object e : collection) {
            compositeConstraint.nestedConstraints[n++] = this.toObjectIdentityConstaint(e);
        }
        return compositeConstraint;
    }

    private Constraint toObjectIdentityConstaint(Object object) {
        ObjectIdentityConstraint objectIdentityConstraint = new ObjectIdentityConstraint();
        objectIdentityConstraint.target = object;
        return objectIdentityConstraint;
    }

    private Constraint toPropertyConstraint(String string, String string2, PropertyPredicate.ComparisonOperator comparisonOperator, Object object) {
        PropertyConstraint propertyConstraint = new PropertyConstraint();
        propertyConstraint.targetType = string;
        propertyConstraint.propertyName = this.toViseProperty(string2);
        propertyConstraint.comparator = RiseToViseWhereClause.toComparator(comparisonOperator);
        propertyConstraint.comparableValue = object;
        return propertyConstraint;
    }

    private static Comparator toComparator(PropertyPredicate.ComparisonOperator comparisonOperator) {
        switch (comparisonOperator) {
            case EQUAL: {
                return Comparator.EQUALS;
            }
            case GREATER: {
                return Comparator.GREATER;
            }
            case GREATER_OR_EQUAL: {
                return Comparator.GREATER_OR_EQUALS;
            }
            case LESS: {
                return Comparator.SMALLER;
            }
            case LESS_OR_EQUAL: {
                return Comparator.SMALLER_OR_EQUALS;
            }
            case NOT_EQUAL: {
                return Comparator.NOT_EQUALS;
            }
        }
        throw new IllegalStateException("Unsupported comparison operator: " + comparisonOperator);
    }

    private static Comparator toComparator(OperatorLikeEvaluator.StringMatchingMode stringMatchingMode) {
        switch (stringMatchingMode) {
            case Contains: {
                return Comparator.CONTAINS;
            }
            case EndsWith: {
                return Comparator.ENDS_WITH;
            }
            case Exact: {
                return Comparator.EQUALS;
            }
            case StartsWith: {
                return Comparator.STARTS_WITH;
            }
        }
        throw new IllegalStateException("Unsupported string matching mode: " + stringMatchingMode);
    }

    private static Conjoiner toConjoiner(LogicalOperator logicalOperator) {
        switch (logicalOperator) {
            case AND: {
                return Conjoiner.AND;
            }
            case OR: {
                return Conjoiner.OR;
            }
        }
        throw new IllegalStateException("Uknown logical operator: " + logicalOperator);
    }

    private String toViseProperty(String string) {
        return this._propertyConverter.toViseProperty(string);
    }

    private static boolean shouldAddAtTypePropertyConstraint(Query query) {
        assert (query != null);
        for (String string : query.getResourceModels()) {
            if (!DS2_MODELS_CLASH_WITH_DS1_AGGREGATED_TYPES.contains(string)) continue;
            return true;
        }
        return false;
    }

    private static Constraint withAtTypePropertyConstraint(Constraint constraint, String string) {
        CompositeConstraint compositeConstraint;
        assert (constraint != null);
        assert (string != null);
        PropertyConstraint propertyConstraint = new PropertyConstraint();
        propertyConstraint.targetType = string;
        propertyConstraint.comparator = Comparator.EQUALS;
        propertyConstraint.propertyName = "@type";
        propertyConstraint.comparableValue = string;
        if (constraint.getClass() == Constraint.class) {
            return propertyConstraint;
        }
        if (constraint instanceof CompositeConstraint) {
            compositeConstraint = (CompositeConstraint)constraint;
            if (Conjoiner.AND.equals((Object)compositeConstraint.conjoiner)) {
                compositeConstraint.nestedConstraints = RiseToViseWhereClause.append(compositeConstraint.nestedConstraints, (Constraint)propertyConstraint);
                return compositeConstraint;
            }
        }
        compositeConstraint = new CompositeConstraint();
        compositeConstraint.targetType = string;
        compositeConstraint.conjoiner = Conjoiner.AND;
        compositeConstraint.nestedConstraints = new Constraint[]{constraint, propertyConstraint};
        return compositeConstraint;
    }

    private static Constraint[] append(Constraint[] constraintArray, Constraint constraint) {
        assert (constraintArray != null);
        assert (constraint != null);
        Constraint[] constraintArray2 = Arrays.copyOf(constraintArray, constraintArray.length + 1);
        constraintArray2[constraintArray2.length - 1] = constraint;
        return constraintArray2;
    }
}

