/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.vim.data.adapters.common;

import com.vmware.vise.util.concurrent.ThreadPoolManager;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;

public final class ThreadPoolFactory {
    private static final ThreadPoolExecutor.CallerRunsPolicy CALLER_RUNS_POLICY = new ThreadPoolExecutor.CallerRunsPolicy();
    private static final int CORE_POOL_SIZE = 0;
    private static final int MAXIMUM_POOL_SIZE = 8192;
    private static final long KEEP_ALIVE_TIME_SECONDS = 60L;

    public static ExecutorService newCachedThreadPool(String string) {
        Validate.notEmpty((String)string);
        DefaultThreadFactory defaultThreadFactory = new DefaultThreadFactory(string);
        ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(0, 8192, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), defaultThreadFactory, CALLER_RUNS_POLICY);
        ThreadPoolManager.getInstance().register((ExecutorService)threadPoolExecutor);
        return threadPoolExecutor;
    }

    private static final class DefaultThreadFactory
    implements ThreadFactory {
        private final AtomicInteger createdThreadCount = new AtomicInteger();
        private final String _threadPoolName;

        DefaultThreadFactory(String string) {
            assert (!StringUtils.isEmpty((String)string));
            this._threadPoolName = string;
        }

        @Override
        public Thread newThread(Runnable runnable) {
            String string = this._threadPoolName + "-" + this.createdThreadCount.incrementAndGet();
            Thread thread = new Thread(runnable, string);
            return thread;
        }
    }
}

