/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.vim.data.adapters.search.impl;

import com.vmware.vise.core.model.CompositeException;
import com.vmware.vise.data.query.FacetInfo;
import com.vmware.vise.search.Match;
import com.vmware.vise.search.ResultSet;
import com.vmware.vise.util.ValidationUtil;
import com.vmware.vise.vim.data.adapters.search.QueryResult;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

final class MergedResultSet
implements ResultSet {
    private final List<QueryResult> _results;
    private List<Match> _matches;
    private Integer _matchCount;
    private Set<String> _queriedServices;
    private Set<String> _includedServices;
    private List<ResultSet> _resultSets;
    private List<FacetInfo> _facets;

    MergedResultSet(List<QueryResult> list) {
        ValidationUtil.paramsNotNull((Object[])new Object[]{list});
        this._results = list;
    }

    public List<Match> getMatches() {
        if (this._matches != null) {
            return this._matches;
        }
        this._matches = new ArrayList<Match>();
        for (ResultSet resultSet : this.getMatchedResults()) {
            List list = resultSet.getMatches();
            if (list == null) continue;
            this._matches.addAll(list);
        }
        return this._matches;
    }

    public int getMatchCount() {
        if (this._matchCount != null) {
            return this._matchCount;
        }
        int n = 0;
        for (QueryResult queryResult : this._results) {
            if (queryResult.resultSet == null) continue;
            int n2 = queryResult.resultSet.getMatchCount();
            n += n2;
        }
        this._matchCount = n;
        return n;
    }

    public Exception getError() {
        ArrayList<Exception> arrayList = new ArrayList<Exception>();
        for (ResultSet resultSet : this.getMatchedResults()) {
            if (resultSet.getError() == null) continue;
            arrayList.add(resultSet.getError());
        }
        if (arrayList.size() > 0) {
            return new CompositeException(arrayList);
        }
        return null;
    }

    public Set<String> getQueriedServices() {
        if (this._queriedServices != null) {
            return this._queriedServices;
        }
        this._queriedServices = new HashSet<String>();
        for (ResultSet resultSet : this.getMatchedResults()) {
            Set set = resultSet.getQueriedServices();
            if (set == null) continue;
            this._queriedServices.addAll(set);
        }
        return this._queriedServices;
    }

    public Set<String> getIncludedServices() {
        if (this._includedServices != null) {
            return this._includedServices;
        }
        this._includedServices = new HashSet<String>();
        for (ResultSet resultSet : this.getMatchedResults()) {
            Set set = resultSet.getIncludedServices();
            if (set == null) continue;
            this._includedServices.addAll(set);
        }
        return this._includedServices;
    }

    public boolean getSorted() {
        if (this._results.size() > 1) {
            return false;
        }
        for (ResultSet resultSet : this.getMatchedResults()) {
            if (resultSet.getSorted()) continue;
            return false;
        }
        return true;
    }

    public boolean getPaged() {
        boolean bl = this._results.size() <= 1;
        return bl;
    }

    public List<FacetInfo> getFacetInfos() {
        if (this._facets != null) {
            return this._facets;
        }
        this._facets = new ArrayList<FacetInfo>();
        for (QueryResult queryResult : this._results) {
            List list = queryResult.resultSet.getFacetInfos();
            if (list == null) continue;
            this._facets.addAll(list);
        }
        return this._facets;
    }

    private List<ResultSet> getMatchedResults() {
        if (this._resultSets != null) {
            return this._resultSets;
        }
        this._resultSets = new ArrayList<ResultSet>();
        for (QueryResult queryResult : this._results) {
            ResultSet resultSet = queryResult.resultSet;
            if (resultSet == null) continue;
            this._resultSets.add(resultSet);
        }
        return this._resultSets;
    }
}

