/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.vim.data.adapters.search.impl;

import com.vmware.vise.core.model.IdentifiableGenerationNumber;
import com.vmware.vise.data.query.DynamicProviderResultSet;
import com.vmware.vise.data.query.FacetInfo;
import com.vmware.vise.data.query.PropertyValue;
import com.vmware.vise.data.query.ResultItem;
import com.vmware.vise.data.query.ResultSet;
import com.vmware.vise.search.Match;
import com.vmware.vise.vim.commons.MixedUtil;
import com.vmware.vise.vim.commons.VcServiceUtil;
import com.vmware.vise.vim.commons.vcservice.ServiceEndpointEx;
import com.vmware.vise.vim.data.adapters.search.PeerQueryServiceConnectionError;
import com.vmware.vise.vim.data.adapters.search.QueryResult;
import com.vmware.vise.vim.data.adapters.search.impl.Utils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class QueryResultTransformer {
    private static final Log _logger = LogFactory.getLog(QueryResultTransformer.class);

    public DynamicProviderResultSet toResultSet(QueryResult queryResult) {
        if (queryResult == null) {
            throw new IllegalArgumentException("queryResults cannot be null");
        }
        DynamicProviderResultSet dynamicProviderResultSet = this.toResultSet(queryResult.resultSet);
        this.applyDisconnectedServices((ResultSet)dynamicProviderResultSet, queryResult);
        dynamicProviderResultSet.queryName = queryResult.request.getQueryName();
        return dynamicProviderResultSet;
    }

    private void applyDisconnectedServices(ResultSet resultSet, QueryResult queryResult) {
        Set set = queryResult.resultSet.getIncludedServices();
        if (set == null || set.size() == 0) {
            if (resultSet.error != null) {
                _logger.error((Object)("No Inventory Service responded to query " + queryResult.request.getQueryName()));
                return;
            }
            if (set == null) {
                set = Collections.emptySet();
            }
        }
        ArrayList<String> arrayList = new ArrayList<String>(queryResult.resultSet.getQueriedServices());
        arrayList.removeAll(set);
        if (arrayList.isEmpty()) {
            return;
        }
        Set<ServiceEndpointEx> set2 = Utils.getInventoryServiceEndpoints(arrayList, false);
        _logger.warn((Object)("Not all Inventory Services responded to query " + queryResult.request.getQueryName() + ". Responded: " + set + ". Didn't respond: " + arrayList + "  (The URLs of the services that didn't respond are: " + this.getEndpointsUrls(set2) + ")"));
        ArrayList<PeerQueryServiceConnectionError> arrayList2 = new ArrayList<PeerQueryServiceConnectionError>();
        for (ServiceEndpointEx serviceEndpointEx : set2) {
            PeerQueryServiceConnectionError peerQueryServiceConnectionError = this.createPeerQueryServiceConnectionError(serviceEndpointEx);
            arrayList2.add(peerQueryServiceConnectionError);
        }
        resultSet.error = MixedUtil.addToCompositeException((Exception)resultSet.error, arrayList2);
    }

    private List<String> getEndpointsUrls(Collection<ServiceEndpointEx> collection) {
        if (collection == null || collection.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<String> arrayList = new ArrayList<String>(collection.size());
        for (ServiceEndpointEx serviceEndpointEx : collection) {
            String string = serviceEndpointEx.getUrl();
            arrayList.add(string);
        }
        return arrayList;
    }

    private PeerQueryServiceConnectionError createPeerQueryServiceConnectionError(ServiceEndpointEx serviceEndpointEx) {
        String string = serviceEndpointEx.getVcGuid();
        String string2 = serviceEndpointEx.instanceUuid;
        String string3 = serviceEndpointEx.url;
        return new PeerQueryServiceConnectionError(string, VcServiceUtil.getServiceName((String)string), string2, string3);
    }

    private DynamicProviderResultSet toResultSet(com.vmware.vise.search.ResultSet resultSet) {
        DynamicProviderResultSet dynamicProviderResultSet = new DynamicProviderResultSet();
        dynamicProviderResultSet.error = resultSet.getError();
        List list = resultSet.getMatches();
        dynamicProviderResultSet.totalMatchedObjectCount = resultSet.getMatchCount();
        dynamicProviderResultSet.sorted = resultSet.getSorted();
        dynamicProviderResultSet.paged = resultSet.getPaged();
        ArrayList<ResultItem> arrayList = new ArrayList<ResultItem>(list.size());
        for (Match match : list) {
            ResultItem resultItem = new ResultItem();
            resultItem.resourceObject = match.getObjectReference();
            List list2 = match.getGenerations();
            resultItem.currentGenerations = list2.toArray(new IdentifiableGenerationNumber[list2.size()]);
            this.processMatchedProperties(resultItem, match.getProperties());
            arrayList.add(resultItem);
        }
        dynamicProviderResultSet.items = arrayList.toArray(new ResultItem[0]);
        dynamicProviderResultSet.facets = resultSet.getFacetInfos().toArray(new FacetInfo[0]);
        return dynamicProviderResultSet;
    }

    private void processMatchedProperties(ResultItem resultItem, List<com.vmware.vise.search.PropertyValue> list) {
        ArrayList<PropertyValue> arrayList = new ArrayList<PropertyValue>();
        for (com.vmware.vise.search.PropertyValue propertyValue : list) {
            PropertyValue propertyValue2 = new PropertyValue();
            propertyValue2.resourceObject = propertyValue.getProvider();
            propertyValue2.propertyName = propertyValue.getXqueryName();
            propertyValue2.value = propertyValue.getValue();
            arrayList.add(propertyValue2);
        }
        resultItem.properties = arrayList.toArray(new PropertyValue[0]);
    }
}

