/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.vim.data.adapters.search.impl;

import com.vmware.cis.data.internal.adapters.federation.VersionAnalyzer;
import com.vmware.vim.binding.vim.ServiceDirectory;
import com.vmware.vim.binding.vmodl.ManagedObject;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.data.adapters.core.DataServiceMode;
import com.vmware.vise.search.transport.QueryService;
import com.vmware.vise.search.transport.QueryServiceFactory;
import com.vmware.vise.search.transport.QueryServiceIndex;
import com.vmware.vise.security.UserSessionListener;
import com.vmware.vise.util.feature.FeatureStateService;
import com.vmware.vise.util.session.SessionUtil;
import com.vmware.vise.vim.commons.VcSessionListener;
import com.vmware.vise.vim.commons.VimSessionUtil;
import com.vmware.vise.vim.commons.extensions.LinkedVcGroupRegistry;
import com.vmware.vise.vim.commons.extensions.LinkedVcGroupRegistryListener;
import com.vmware.vise.vim.commons.vcservice.LinkedVcGroup;
import com.vmware.vise.vim.commons.vcservice.ServiceEndpointEx;
import com.vmware.vise.vim.commons.vcservice.VcService;
import com.vmware.vise.vim.commons.vcservice.VcServiceDirectory;
import com.vmware.vise.vim.commons.vmomi.vc.VcAwareSharedHttpConfigPool;
import com.vmware.vise.vim.security.sso.SsoService;
import java.security.PrivateKey;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionEvent;
import org.apache.commons.collections.Factory;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.collections.map.MultiValueMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class QueryServiceIndexImpl
implements QueryServiceIndex,
LinkedVcGroupRegistryListener,
UserSessionListener,
VcServiceDirectory {
    private static final Log _logger = LogFactory.getLog(QueryServiceIndexImpl.class);
    private static final String EXTENSION_VC_SERVICE_MAP = "extensionVcServiceMap";
    private static final String QUERY_SERVICE_INDEX_SYNC = "queryServiceIndexSync";
    static final String QUERY_SERVICE_BY_VC_GROUP_MAP = "queryServiceByVcGroupMap";
    static final String QUERY_SERVICE_VC_FILTER = "queryServiceVcFilter";
    static final VcFilter ACCEPT_ALL_VC_FILTER = new AcceptAllVcFilter();
    static final VcFilter RISE_VC_FILTER = new PreRiseVcFilter();
    private final QueryServiceFactory _queryServiceFactory;
    private final VcAwareSharedHttpConfigPool _sharedHttpConfigPool;
    private final SsoService _ssoService;
    private final FeatureStateService _featureStateService;

    public QueryServiceIndexImpl(QueryServiceFactory queryServiceFactory, VcAwareSharedHttpConfigPool vcAwareSharedHttpConfigPool, SsoService ssoService, FeatureStateService featureStateService) {
        this._queryServiceFactory = queryServiceFactory;
        this._sharedHttpConfigPool = vcAwareSharedHttpConfigPool;
        this._ssoService = ssoService;
        this._featureStateService = featureStateService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<QueryService> getDefaultQueryServices() {
        LinkedList<QueryService> linkedList = new LinkedList<QueryService>();
        LinkedVcGroupRegistry linkedVcGroupRegistry = VimSessionUtil.getLinkedVcGroupRegistry();
        Object object = SessionUtil.getSyncObject((String)QUERY_SERVICE_INDEX_SYNC, null);
        synchronized (object) {
            for (LinkedVcGroup linkedVcGroup : linkedVcGroupRegistry.getUtils().getStartupLinkedVcGroups()) {
                Map<LinkedVcGroup, QueryService> map = this.getQueryMap();
                QueryService queryService = map.get(linkedVcGroup);
                if (queryService == null) continue;
                linkedList.add(queryService);
            }
        }
        return linkedList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<QueryService> getQueryServices(String string) {
        boolean bl;
        Object object;
        LinkedList<QueryService> linkedList = new LinkedList<QueryService>();
        LinkedVcGroupRegistry linkedVcGroupRegistry = VimSessionUtil.getLinkedVcGroupRegistry();
        HashSet<Object> hashSet = new HashSet<Object>();
        Object object2 = SessionUtil.getSyncObject((String)QUERY_SERVICE_INDEX_SYNC, null);
        Iterator iterator = null;
        Object object3 = object2;
        synchronized (object3) {
            object = this.getExtensionMap().getCollection((Object)string);
            boolean bl2 = bl = object != null && object.size() > 0;
            if (bl) {
                iterator = object.iterator();
            }
        }
        if (bl) {
            while (iterator.hasNext()) {
                object3 = (String)iterator.next();
                object = linkedVcGroupRegistry.getLinkedGroupByServiceUuid((String)object3);
                if (object == null) continue;
                hashSet.add(object);
            }
        } else {
            object3 = linkedVcGroupRegistry.getLinkedGroupByServiceUuid(string);
            if (object3 != null) {
                hashSet.add(object3);
            }
        }
        object3 = object2;
        synchronized (object3) {
            for (LinkedVcGroup linkedVcGroup : hashSet) {
                QueryService queryService = this.getQueryMap().get(linkedVcGroup);
                if (queryService == null) continue;
                linkedList.add(queryService);
            }
        }
        return linkedList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> findVcGuidsByServiceGuid(String string) {
        boolean bl;
        Object object;
        Iterator iterator = null;
        VcService vcService = SessionUtil.getSyncObject((String)QUERY_SERVICE_INDEX_SYNC, null);
        synchronized (vcService) {
            object = this.getExtensionMap().getCollection((Object)string);
            boolean bl2 = bl = object != null && object.size() > 0;
            if (bl) {
                iterator = object.iterator();
            }
        }
        if (bl) {
            vcService = new VcService();
            while (iterator.hasNext()) {
                object = (String)iterator.next();
                vcService.add((String)object);
            }
            return vcService;
        }
        vcService = VimSessionUtil.getService((String)string);
        if (vcService == null) {
            return Collections.emptySet();
        }
        object = vcService.getServiceGuid();
        return Collections.singleton(object);
    }

    public void onGroupEvent(LinkedVcGroupRegistryListener.Event event) {
        switch (event.operation) {
            case add: {
                this.registerLinkedVcGroup(event.group, event.session);
                break;
            }
            case remove: {
                this.unregisterLinkedVcGroup(event.group, event.session);
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerExtension(String string, String string2) {
        Object object = SessionUtil.getSyncObject((String)QUERY_SERVICE_INDEX_SYNC, null);
        synchronized (object) {
            VcService vcService = VimSessionUtil.getService((String)string2);
            if (this.getVcFilter().accept(vcService)) {
                this.getExtensionMap().put((Object)string, (Object)string2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sessionEnded(HttpSessionEvent httpSessionEvent) throws Exception {
        HttpSession httpSession = httpSessionEvent.getSession();
        Object object = SessionUtil.getSyncObject((String)QUERY_SERVICE_INDEX_SYNC, (HttpSession)httpSession);
        synchronized (object) {
            LinkedVcGroup[] linkedVcGroupArray;
            String string = SessionUtil.getSessionInfo((HttpSession)httpSession);
            _logger.info((Object)("Processing sessionEnded event for " + string));
            LinkedVcGroupRegistry linkedVcGroupRegistry = VimSessionUtil.getLinkedVcGroupRegistry((HttpSession)httpSession);
            linkedVcGroupRegistry.removeLinkedVcGroupRegistryListener((LinkedVcGroupRegistryListener)this);
            for (LinkedVcGroup linkedVcGroup : linkedVcGroupArray = linkedVcGroupRegistry.getLinkedVcGroups()) {
                String string2 = linkedVcGroup.getClass().getSimpleName();
                String string3 = linkedVcGroup.getStartUpVcService().getServiceUrl();
                try {
                    _logger.info((Object)("Unregistering " + string2 + " " + string3));
                    this.unregisterLinkedVcGroup(linkedVcGroup, httpSession);
                }
                catch (Exception exception) {
                    _logger.error((Object)("Failed to unregister " + string2 + " " + string3), (Throwable)exception);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sessionStarted(HttpSessionEvent httpSessionEvent, Locale locale) throws Exception {
        Object object;
        LinkedVcGroupRegistry linkedVcGroupRegistry = VimSessionUtil.getLinkedVcGroupRegistry((HttpSession)httpSessionEvent.getSession());
        Object object2 = object = SessionUtil.getSyncObject((String)QUERY_SERVICE_INDEX_SYNC, (HttpSession)httpSessionEvent.getSession());
        synchronized (object2) {
            LinkedVcGroup[] linkedVcGroupArray;
            String string = null;
            if (_logger.isDebugEnabled()) {
                string = SessionUtil.getSessionInfo((HttpSession)httpSessionEvent.getSession());
                _logger.debug((Object)("Search adapter session init start: " + string));
            }
            SessionUtil.setData((String)QUERY_SERVICE_BY_VC_GROUP_MAP, new HashMap(), (HttpSession)httpSessionEvent.getSession());
            HashMap hashMap = new HashMap();
            MultiValueMap multiValueMap = MultiValueMap.decorate(hashMap, (Factory)new Factory(){

                public Object create() {
                    return new CopyOnWriteArrayList();
                }
            });
            SessionUtil.setData((String)EXTENSION_VC_SERVICE_MAP, (Object)multiValueMap, (HttpSession)httpSessionEvent.getSession());
            SessionUtil.setData((String)QUERY_SERVICE_VC_FILTER, (Object)this.chooseVcFilter(), (HttpSession)httpSessionEvent.getSession());
            linkedVcGroupRegistry.addLinkedVcGroupRegistryListener((LinkedVcGroupRegistryListener)this);
            for (LinkedVcGroup linkedVcGroup : linkedVcGroupArray = linkedVcGroupRegistry.getLinkedVcGroups()) {
                try {
                    this.registerLinkedVcGroup(linkedVcGroup, httpSessionEvent.getSession());
                }
                catch (Exception exception) {
                    VcService vcService = linkedVcGroup.getStartUpVcService();
                    String string2 = vcService != null ? vcService.getServiceUrl() : "???";
                    _logger.error((Object)("Failed to register linked VC group " + string2 + " into the Search adapter. Its Inventory Services will not" + " participate in queries."), (Throwable)exception);
                }
            }
            if (_logger.isDebugEnabled()) {
                if (string == null) {
                    string = SessionUtil.getSessionInfo((HttpSession)httpSessionEvent.getSession());
                }
                _logger.debug((Object)("Search adapter session init complete: " + string));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterExtension(String string) {
        Object object = SessionUtil.getSyncObject((String)QUERY_SERVICE_INDEX_SYNC, null);
        synchronized (object) {
            this.getExtensionMap().remove((Object)string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterExtension(String string, String string2) {
        Object object = SessionUtil.getSyncObject((String)QUERY_SERVICE_INDEX_SYNC, null);
        synchronized (object) {
            this.getExtensionMap().remove((Object)string, (Object)string2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerLinkedVcGroup(LinkedVcGroup linkedVcGroup, HttpSession httpSession) {
        Object object = SessionUtil.getSyncObject((String)QUERY_SERVICE_INDEX_SYNC, (HttpSession)httpSession);
        synchronized (object) {
            this.registerLinkedVcGroupForQuerying(linkedVcGroup, httpSession);
        }
    }

    private void registerLinkedVcGroupForQuerying(LinkedVcGroup linkedVcGroup, HttpSession httpSession) {
        Map<LinkedVcGroup, QueryService> map = this.getQueryMap(httpSession);
        if (map.containsKey(linkedVcGroup)) {
            return;
        }
        LinkedVcGroup linkedVcGroup2 = this.getVcFilter(httpSession).filter(linkedVcGroup);
        Collection collection = linkedVcGroup2.getVcServices();
        if (collection == null || collection.isEmpty()) {
            return;
        }
        QueryService queryService = this.createQueryService(linkedVcGroup2);
        map.put(linkedVcGroup, queryService);
    }

    private QueryService createQueryService(LinkedVcGroup linkedVcGroup) {
        PrivateKey privateKey = this._ssoService != null ? this._ssoService.getHokPrivateKey() : null;
        QueryService queryService = this._queryServiceFactory.newQueryService(linkedVcGroup, this._sharedHttpConfigPool, privateKey);
        return queryService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unregisterLinkedVcGroup(LinkedVcGroup linkedVcGroup, HttpSession httpSession) {
        QueryService queryService = null;
        Object object = SessionUtil.getSyncObject((String)QUERY_SERVICE_INDEX_SYNC, (HttpSession)httpSession);
        synchronized (object) {
            queryService = this.getQueryMap(httpSession).remove(linkedVcGroup);
            if (queryService != null) {
                MultiValueMap multiValueMap = this.getExtensionMap(httpSession);
                MultiValueMap multiValueMap2 = (MultiValueMap)MapUtils.multiValueMap((Map)MapUtils.invertMap((Map)multiValueMap));
                for (VcService vcService : linkedVcGroup.getVcServices()) {
                    Collection collection = multiValueMap2.getCollection((Object)vcService.getServiceGuid());
                    if (collection == null) continue;
                    for (String string : collection) {
                        multiValueMap.remove((Object)string, (Object)vcService.getServiceGuid());
                    }
                }
            }
        }
        if (queryService != null) {
            queryService.dispose();
        }
    }

    private MultiValueMap getExtensionMap() {
        return this.getExtensionMap(null);
    }

    private Map<LinkedVcGroup, QueryService> getQueryMap() {
        return this.getQueryMap(null);
    }

    private MultiValueMap getExtensionMap(HttpSession httpSession) {
        return (MultiValueMap)SessionUtil.getData((String)EXTENSION_VC_SERVICE_MAP, (HttpSession)httpSession);
    }

    private Map<LinkedVcGroup, QueryService> getQueryMap(HttpSession httpSession) {
        return (Map)SessionUtil.getData((String)QUERY_SERVICE_BY_VC_GROUP_MAP, (HttpSession)httpSession);
    }

    private VcFilter chooseVcFilter() {
        DataServiceMode dataServiceMode = DataServiceMode.getCurrentMode(this._featureStateService);
        if (DataServiceMode.RISE.equals((Object)dataServiceMode)) {
            return RISE_VC_FILTER;
        }
        return ACCEPT_ALL_VC_FILTER;
    }

    private VcFilter getVcFilter() {
        return this.getVcFilter(null);
    }

    private VcFilter getVcFilter(HttpSession httpSession) {
        VcFilter vcFilter = (VcFilter)SessionUtil.getData((String)QUERY_SERVICE_VC_FILTER, (HttpSession)httpSession);
        if (vcFilter != null) {
            return vcFilter;
        }
        return ACCEPT_ALL_VC_FILTER;
    }

    private static boolean hasQueryService(VcService vcService) {
        if (vcService == null) {
            return false;
        }
        return VersionAnalyzer.isVersionBeforeRise((String)vcService.getServiceVersion());
    }

    private static Collection<VcService> vcServicesWithQueryService(Collection<VcService> collection) {
        assert (collection != null);
        ArrayList<VcService> arrayList = new ArrayList<VcService>(collection.size());
        for (VcService vcService : collection) {
            if (!QueryServiceIndexImpl.hasQueryService(vcService)) continue;
            arrayList.add(vcService);
        }
        return arrayList;
    }

    private static final class PreRiseLinkedVcGroup
    implements LinkedVcGroup {
        private final LinkedVcGroup _vcGroup;
        private final Collection<VcService> _vcServicesWithQueryService;
        private final VcService _startupVcService;

        PreRiseLinkedVcGroup(LinkedVcGroup linkedVcGroup) {
            assert (linkedVcGroup != null);
            this._vcGroup = linkedVcGroup;
            this._vcServicesWithQueryService = Collections.unmodifiableCollection(QueryServiceIndexImpl.vcServicesWithQueryService(linkedVcGroup.getVcServices()));
            VcService vcService = this._vcGroup.getStartUpVcService();
            this._startupVcService = vcService == null ? vcService : (QueryServiceIndexImpl.hasQueryService(vcService) ? vcService : (!this._vcServicesWithQueryService.isEmpty() ? this._vcServicesWithQueryService.iterator().next() : null));
        }

        public void login() throws Exception {
            throw new IllegalStateException("Not implemented");
        }

        public boolean supportsLoginByToken() {
            throw new IllegalStateException("Not implemented");
        }

        public void logout() {
            throw new IllegalStateException("Not implemented");
        }

        public Collection<VcService> getVcServices() {
            return this._vcServicesWithQueryService;
        }

        public VcService getVcService(String string) {
            throw new IllegalStateException("Not implemented");
        }

        public ManagedObject getManagedObject(ManagedObjectReference managedObjectReference) throws Exception {
            throw new IllegalStateException("Not implemented");
        }

        public VcService getStartUpVcService() {
            return this._startupVcService;
        }

        public ServiceEndpointEx[] getServiceEndPoints() {
            throw new IllegalStateException("Not implemented");
        }

        public ServiceEndpointEx getServiceEndpoint(String string, ServiceDirectory.ServiceProtocol serviceProtocol) {
            throw new IllegalStateException("Not implemented");
        }

        public void addVcSessionListener(VcSessionListener vcSessionListener) {
            throw new IllegalStateException("Not implemented");
        }

        public boolean removeVcSessionListener(VcSessionListener vcSessionListener) {
            throw new IllegalStateException("Not implemented");
        }
    }

    static final class PreRiseVcFilter
    implements VcFilter {
        PreRiseVcFilter() {
        }

        @Override
        public boolean accept(VcService vcService) {
            return QueryServiceIndexImpl.hasQueryService(vcService);
        }

        @Override
        public LinkedVcGroup filter(LinkedVcGroup linkedVcGroup) {
            return new PreRiseLinkedVcGroup(linkedVcGroup);
        }
    }

    static final class AcceptAllVcFilter
    implements VcFilter {
        AcceptAllVcFilter() {
        }

        @Override
        public boolean accept(VcService vcService) {
            return true;
        }

        @Override
        public LinkedVcGroup filter(LinkedVcGroup linkedVcGroup) {
            return linkedVcGroup;
        }
    }

    static interface VcFilter {
        public boolean accept(VcService var1);

        public LinkedVcGroup filter(LinkedVcGroup var1);
    }
}

