/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.ph.ceip.authentication.keystore;

import com.vmware.ph.ceip.authentication.InitializationException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FilebasedKeyStoreProvider {
    private static final Logger logger = LoggerFactory.getLogger(FilebasedKeyStoreProvider.class);
    private final FileCreator fileCreator = new FileCreator();
    private final FileInputStreamCreator fileInputStreamCreator = new FileInputStreamCreator();

    public KeyStore loadKeyStore(String storeName, String keyStoreFilePath, char[] keyStorePassword) {
        logger.debug("Loading file-based keyStore from {} ignoring the storeName={}", (Object)keyStoreFilePath, (Object)storeName);
        File keyStoreFile = this.getSolutionKeyStoreLocation(keyStoreFilePath);
        KeyStore keyStore = this.loadFileBasedKeyStore(keyStoreFile, keyStorePassword);
        return keyStore;
    }

    private File getSolutionKeyStoreLocation(String keyStoreFilePath) {
        File keyStore = this.fileCreator.create(keyStoreFilePath);
        if (!keyStore.isFile()) {
            throw new InitializationException(String.format("Key store file cannot be found; searched location: '%s'.", keyStore.getAbsolutePath()));
        }
        return keyStore;
    }

    private KeyStore loadFileBasedKeyStore(File keyStoreFile, char[] keyStorePassword) {
        KeyStore keyStore;
        FileInputStream keyStoreSrc = null;
        logger.debug("loading file-based keystore from file : " + keyStoreFile.getAbsolutePath());
        try {
            keyStoreSrc = this.fileInputStreamCreator.create(keyStoreFile);
            keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
            keyStore.load(keyStoreSrc, keyStorePassword);
            logger.debug("File-based keystore loaded successfully.");
        }
        catch (IOException | GeneralSecurityException e) {
            try {
                String msg = "Failed to load the keystore " + keyStoreFile.getAbsolutePath();
                logger.debug(msg, (Throwable)e);
                throw new InitializationException(msg, e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(keyStoreSrc);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)keyStoreSrc);
        return keyStore;
    }

    static class FileInputStreamCreator {
        FileInputStreamCreator() {
        }

        public FileInputStream create(File f) throws FileNotFoundException {
            return new FileInputStream(f);
        }
    }

    static class FileCreator {
        FileCreator() {
        }

        public File create(String filePath) {
            return new File(filePath);
        }
    }
}

