/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.ph.ceip.impl;

import com.vmware.ph.ceip.DBConnectionException;
import com.vmware.ph.ceip.VcdbConsentManager;
import com.vmware.ph.ceip.impl.ClosableStubWrapper;
import com.vmware.ph.ceip.impl.ConsentConfigurationServiceLocator;
import com.vmware.ph.ceip.impl.DisallowAllThumbprintVerifier;
import com.vmware.ph.ceip.impl.VcdbConsentManagerImpl;
import com.vmware.ph.exceptions.Bug;
import com.vmware.vim.binding.phonehome.data.ConsentConfigurationData;
import com.vmware.vim.binding.phonehome.service.ConsentConfigurationService;
import com.vmware.vim.binding.phonehome.version.version1;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vim.sso.client.ConfirmationType;
import com.vmware.vim.sso.client.SamlToken;
import com.vmware.vim.vmomi.client.Client;
import com.vmware.vim.vmomi.client.ClientConfiguration;
import com.vmware.vim.vmomi.client.http.HttpClientConfiguration;
import com.vmware.vim.vmomi.client.http.HttpConfiguration;
import com.vmware.vim.vmomi.client.http.ThumbprintVerifier;
import com.vmware.vim.vmomi.core.Future;
import com.vmware.vim.vmomi.core.RequestContext;
import com.vmware.vim.vmomi.core.Stub;
import com.vmware.vim.vmomi.core.impl.RequestContextImpl;
import com.vmware.vim.vmomi.core.security.SignInfo;
import com.vmware.vim.vmomi.core.security.impl.SignInfoImpl;
import com.vmware.vim.vmomi.core.types.VmodlContext;
import com.vmware.vise.util.net.ssl.SSLConfigurationProvider;
import com.vmware.vise.util.session.SessionUtil;
import com.vmware.vise.vim.commons.extensions.LinkedVcGroupRegistry;
import com.vmware.vise.vim.commons.security.NotAuthenticatedError;
import com.vmware.vise.vim.commons.ssl.KeystoreService;
import com.vmware.vise.vim.commons.sso.AuthSessionUtil;
import com.vmware.vise.vim.commons.vcservice.VcService;
import com.vmware.vise.vim.commons.vmomi.OpIdAwareClientFactory;
import com.vmware.vise.vim.commons.vmomi.VmomiClientHelper;
import com.vmware.vise.vim.security.sso.SsoService;
import com.vmware.vsphere.client.ceip.util.Utils;
import com.vmware.vsphere.client.ceip.util.VlsiUtil;
import java.net.URI;
import java.security.PrivateKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CcsAndVcdbManagerImpl
implements ConsentConfigurationService,
VcdbConsentManager {
    private static final ThumbprintVerifier disallowAllowVerifier = new DisallowAllThumbprintVerifier();
    private static final Logger logger = LoggerFactory.getLogger(CcsAndVcdbManagerImpl.class);
    private static final String CONSENT_CONFIG_SERVICE_MO_ID = "ccService";
    private final ConsentConfigurationServiceLocator _ccsLocator;
    private final VmodlContext _vmodlContext;
    private final KeystoreService _keystoreService;
    private final SsoService _ssoService;
    private final SSLConfigurationProvider _sslConfigProvider;
    private final VcdbConsentManagerFactory _vcmFactory;
    private final RequestContexFactory _rcFactory;
    private final SignInfoFactory _siFactory;

    public CcsAndVcdbManagerImpl(ConsentConfigurationServiceLocator ccsLocator, VmodlContext vmodlContext, KeystoreService keystoreService, SsoService ssoService, SSLConfigurationProvider sslConfigProvider) {
        this(ccsLocator, vmodlContext, keystoreService, ssoService, sslConfigProvider, new VcdbConsentManagerFactory(), new RequestContexFactory(), new SignInfoFactory());
    }

    CcsAndVcdbManagerImpl(ConsentConfigurationServiceLocator ccsLocator, VmodlContext vmodlContext, KeystoreService keystoreService, SsoService ssoService, SSLConfigurationProvider sslConfigProvider, VcdbConsentManagerFactory vcmFactory, RequestContexFactory rcFactory, SignInfoFactory siFactory) {
        this._ccsLocator = ccsLocator;
        this._vmodlContext = vmodlContext;
        this._keystoreService = keystoreService;
        this._ssoService = ssoService;
        this._sslConfigProvider = sslConfigProvider;
        this._vcmFactory = vcmFactory;
        this._rcFactory = rcFactory;
        this._siFactory = siFactory;
    }

    @Override
    public ConsentConfigurationData readConsent() throws DBConnectionException {
        logger.info("readConsent() called by thread = " + Thread.currentThread().getName());
        return this.internalReadConsent();
    }

    @Override
    public void writeConsent(ConsentConfigurationData consent) throws DBConnectionException {
        logger.info("writeConsent() called by thread = " + Thread.currentThread().getName());
        this.internalWriteConsent(consent);
    }

    public ManagedObjectReference _getRef() {
        try (ClosableStubWrapper<ConsentConfigurationService> ccsWrapper = this.getCCSStub();){
            ManagedObjectReference managedObjectReference = ccsWrapper.getStub()._getRef();
            return managedObjectReference;
        }
    }

    public ConsentConfigurationData get() {
        try (ClosableStubWrapper<ConsentConfigurationService> ccsWrapper = this.getCCSStub();){
            ConsentConfigurationData consentConfigurationData = ccsWrapper.getStub().get();
            return consentConfigurationData;
        }
    }

    public void get(Future<ConsentConfigurationData> future) {
        throw new Bug("This method should not be called.");
    }

    public void set(ConsentConfigurationData value) {
        try (ClosableStubWrapper<ConsentConfigurationService> ccsWrapper = this.getAuthCCSStub();){
            ccsWrapper.getStub().set(value);
        }
    }

    public void set(ConsentConfigurationData value, Future<Void> future) {
        throw new Bug("This method should not be called.");
    }

    public void validatePrivilegeForSet() {
        throw new Bug("This method should not be called.");
    }

    public void validatePrivilegeForSet(Future<Void> future) {
        new Bug("This method should not be called.");
    }

    private ClosableStubWrapper<ConsentConfigurationService> getCCSStub() {
        logger.debug("getCCSStub started");
        HttpClientConfiguration httpClientConfig = this.createHttpClientConfiguration();
        URI ccsUrl = this._ccsLocator.getConsentConfigServiceUrl();
        logger.debug("Will create CCS stub against URL: {}", (Object)ccsUrl);
        Client client = OpIdAwareClientFactory.createClient((URI)ccsUrl, version1.class, (VmodlContext)this._vmodlContext, (ClientConfiguration)httpClientConfig);
        String wsdlName = this._vmodlContext.getVmodlTypeMap().getVmodlType(ConsentConfigurationService.class).getWsdlName();
        ManagedObjectReference moRef = new ManagedObjectReference(wsdlName, CONSENT_CONFIG_SERVICE_MO_ID);
        ConsentConfigurationService ccSvc = (ConsentConfigurationService)VmomiClientHelper.createStub((Client)client, ConsentConfigurationService.class, (ManagedObjectReference)moRef, (ClassLoader)CcsAndVcdbManagerImpl.class.getClassLoader());
        return new ClosableStubWrapper<ConsentConfigurationService>(client, ccSvc);
    }

    private ClosableStubWrapper<ConsentConfigurationService> getAuthCCSStub() {
        logger.debug("getAuthCCSStub() called by thread = " + Thread.currentThread().getName());
        SamlToken token = AuthSessionUtil.getSsoToken();
        logger.trace("getAuthCCSStub() called with the following confirmation certificate: {}", (Object)token.getConfirmationCertificate());
        logger.trace("getAuthCCSStub() SsoToken.isSoltion(): '{}'", (Object)token.isSolution());
        ClosableStubWrapper<ConsentConfigurationService> ccsWrapper = this.getCCSStub();
        ConsentConfigurationService ccs = ccsWrapper.getStub();
        RequestContextImpl rc = this._rcFactory.getRequestContextImpl();
        PrivateKey key = this.getPrivateKey(token);
        rc.setSignInfo(this._siFactory.getSignInfo(key, token));
        ((Stub)ccs)._setRequestContext((RequestContext)rc);
        return ccsWrapper;
    }

    private PrivateKey getPrivateKey(SamlToken token) {
        logger.debug("Getting the privateKey from SampleToken");
        PrivateKey key = AuthSessionUtil.getSsoTokenPrivateKey();
        if (ConfirmationType.HOLDER_OF_KEY == token.getConfirmationType() && key == null) {
            logger.debug("token.getConfirmationType() is HOLDER_OF_KEY and at the same time the key is null. Will treat this call as it comes from a NGC logged in user and taking the private key from the ssoService...");
            key = this._ssoService.getHokPrivateKey();
        }
        logger.debug("Successfully getting the privateKey from SampleToken");
        return key;
    }

    private HttpClientConfiguration createHttpClientConfiguration() {
        logger.debug("creating http client configuration");
        HttpClientConfiguration httpClientConfig = HttpClientConfiguration.Factory.newInstance();
        HttpConfiguration httpConfig = httpClientConfig.getHttpConfiguration();
        httpConfig.setTrustStore(this._keystoreService.getKeyStore());
        httpConfig.setThumbprintVerifier(disallowAllowVerifier);
        if (this._sslConfigProvider.getEnabledProtocols() != null) {
            httpConfig.setEnabledProtocols(this._sslConfigProvider.getEnabledProtocols());
        }
        VlsiUtil.setHttpResponseTimeout(httpClientConfig);
        return httpClientConfig;
    }

    private ConsentConfigurationData internalReadConsent() throws DBConnectionException {
        VcdbConsentManager vcdb = this._vcmFactory.getVcdbConsentManager(this.findTargetVcService());
        try {
            return vcdb.readConsent();
        }
        catch (DBConnectionException e) {
            if (e.getCause() instanceof NotAuthenticatedError) {
                NotAuthenticatedError nae = (NotAuthenticatedError)e.getCause();
                throw nae;
            }
            throw e;
        }
    }

    private void internalWriteConsent(ConsentConfigurationData entity) throws DBConnectionException {
        VcdbConsentManager vcdb = this._vcmFactory.getVcdbConsentManager(this.findTargetVcService());
        try {
            vcdb.writeConsent(entity);
        }
        catch (DBConnectionException e) {
            if (e.getCause() instanceof NotAuthenticatedError) {
                NotAuthenticatedError nae = (NotAuthenticatedError)e.getCause();
                throw nae;
            }
            throw e;
        }
    }

    private VcService findTargetVcService() {
        logger.info("Getting LinkedVcGroupRegistry from SessionUtil.");
        LinkedVcGroupRegistry registry = (LinkedVcGroupRegistry)SessionUtil.getData((String)"LINKED_VC_GROUP_REGISTRY");
        return Utils.getVcService(registry);
    }

    static class SignInfoFactory {
        SignInfoFactory() {
        }

        public SignInfo getSignInfo(PrivateKey key, SamlToken token) {
            return new SignInfoImpl(key, token);
        }
    }

    static class RequestContexFactory {
        RequestContexFactory() {
        }

        public RequestContextImpl getRequestContextImpl() {
            return new RequestContextImpl();
        }
    }

    static class VcdbConsentManagerFactory {
        VcdbConsentManagerFactory() {
        }

        public VcdbConsentManager getVcdbConsentManager(VcService vcService) {
            return new VcdbConsentManagerImpl(vcService);
        }
    }
}

