/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.ph.ceip.impl;

import com.vmware.ph.ceip.CeipApi;
import com.vmware.ph.ceip.CeipApiException;
import com.vmware.ph.ceip.DBConnectionException;
import com.vmware.ph.ceip.VcdbConsentManager;
import com.vmware.vim.binding.phonehome.data.ConsentConfiguration;
import com.vmware.vim.binding.phonehome.data.ConsentConfigurationData;
import com.vmware.vim.binding.phonehome.service.ConsentConfigurationService;
import java.util.Arrays;
import java.util.HashSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CeipApiImpl
implements CeipApi {
    private static Logger log = LoggerFactory.getLogger(CeipApiImpl.class);
    private final VcdbConsentManager vcdb;
    private final ConsentConfigurationService ccs;
    static final int CEIP_CONSENT_ID_OLD = 1;
    static final int CEIP_CONSENT_ID = 2;
    private static final String DEFAULT_OWNER = "";
    private static final ConsentConfiguration[] DATA_DEFAULT = null;
    private static final long versionDefault = 0L;
    private ConsentConfiguration[] data = DATA_DEFAULT;
    private long version = 0L;
    private ConsentConfiguration[] dataLotus = DATA_DEFAULT;
    private long versionLotus = 0L;
    private boolean isDataReadFromDb = false;
    private volatile boolean shouldSend = false;

    public CeipApiImpl(VcdbConsentManager vcdb, ConsentConfigurationService ccs) {
        this.vcdb = vcdb;
        this.ccs = ccs;
    }

    @Override
    public Boolean isConsentAccepted() {
        this.readFromDBIfNotInitialized();
        return this.ceipConsentAccepted(this.data);
    }

    @Override
    public synchronized void setConsentAccepted(boolean consentAccepted) {
        log.debug("Setting consent to: {}", (Object)consentAccepted);
        this.readFromDBIfNotInitialized();
        ConsentConfiguration[] cc = this.changeCeipConsentAccepted(this.data, consentAccepted);
        this.writeDb(cc, this.version + 1L);
        ++this.version;
        this.data = cc;
        this.shouldSend = true;
        this.sendIfNeeded();
    }

    @Override
    public synchronized void sync() {
        log.debug("Start syncing the consent...");
        this.readFromDBIfNotInitialized();
        this.sendIfNeeded();
        ConsentConfiguration[] dataRemote = DATA_DEFAULT;
        long versionRemote = 0L;
        try {
            ConsentConfigurationData consentConfigData = this.ccs.get();
            log.debug("Loaded consentConfigData from CCS -> {}", (Object)consentConfigData);
            if (consentConfigData != null) {
                dataRemote = consentConfigData.getConsentConfigurations();
                versionRemote = Long.parseLong(consentConfigData.getVersion());
            }
        }
        catch (RuntimeException re) {
            throw new CeipApiException("Error while reading consent, there is connection issue to the Consent Configuration service in the PSC node. As a result consent state is not up to date. Please check the state of the Consent Configuration service.", re);
        }
        if (versionRemote != this.versionLotus || !this.equals(dataRemote, this.dataLotus)) {
            log.debug("There are change since in the consent configurations: \r\n versionRemote -> {}, versionLotus -> {} \r\n dataRemote -> {}, dataLotus -> {}", new Object[]{versionRemote, this.versionLotus, dataRemote, this.dataLotus});
            ++this.version;
            this.versionLotus = versionRemote;
            this.dataLotus = dataRemote;
            if (this.version <= versionRemote) {
                if (versionRemote > this.version) {
                    this.version = versionRemote + 1L;
                }
                this.data = dataRemote;
                this.writeDb(this.data, this.version);
            } else {
                this.shouldSend = true;
                this.send();
            }
            this.shouldSend = false;
        }
    }

    long getVersion() {
        return this.version;
    }

    void setData(Boolean consentAccepted) {
        this.data = this.changeCeipConsentAccepted(this.data, consentAccepted);
    }

    private void writeDb(ConsentConfiguration[] consentAccepted, long version) {
        ConsentConfigurationData ccData = new ConsentConfigurationData(consentAccepted, Long.toString(version));
        log.debug("Writing ConsentConfigurationData to the DB (Consent Store): ConsentConfigurationData -> {}", (Object)ccData);
        try {
            this.vcdb.writeConsent(ccData);
            log.debug("Successfully wrote the ConsentConfigurationData to the DB (Consent Store)");
        }
        catch (DBConnectionException e) {
            throw new CeipApiException("Error while writing consent via the OptionManager. As a result consent state cannot be saved. Please check the vc logs for details.", e);
        }
    }

    private synchronized void send() {
        ConsentConfigurationData ccData = new ConsentConfigurationData(this.data, Long.toString(this.version + 1L));
        log.debug("Sending ConsentConfigurationData to the CCS: ConsentConfigurationData -> {}", (Object)ccData);
        try {
            this.ccs.set(ccData);
            log.debug("Successfully sent ConsentConfigurationData to the CCS.");
        }
        catch (RuntimeException re) {
            throw new CeipApiException("Error while writing consent, there is connection issue to the Consent Configuration service in the PSC node. As a result consent state cannot be saved. Please check the state of the Consent Configuration service.", re);
        }
        ++this.version;
        this.dataLotus = this.data;
        this.versionLotus = this.version;
    }

    private synchronized void readFromDBIfNotInitialized() {
        if (!this.isDataReadFromDb) {
            ConsentConfigurationData consentState;
            log.debug("Initial reading ConsentConfigurationData from DB (Consent Store)");
            try {
                consentState = this.vcdb.readConsent();
                log.debug("Successfully read ConsentConfigurationData from DB (Consent Store): ConsentConfigurationData -> {}", (Object)consentState);
            }
            catch (DBConnectionException e) {
                throw new CeipApiException("Error while reading consent via the OptionManager. As a result consent state cannot be saved. Please check the vc logs for details.");
            }
            if (consentState != null) {
                this.data = consentState.getConsentConfigurations();
                this.version = Long.parseLong(consentState.getVersion());
            }
            this.isDataReadFromDb = true;
        }
    }

    private synchronized void sendIfNeeded() {
        log.debug("Send if needed: shouldSend -> {}", (Object)this.shouldSend);
        if (this.shouldSend) {
            try {
                this.send();
                this.shouldSend = false;
            }
            catch (RuntimeException e) {
                log.warn("Will retry", (Throwable)e);
            }
        }
    }

    private boolean equals(ConsentConfiguration[] arr1, ConsentConfiguration[] arr2) {
        if (arr1 == arr2) {
            return true;
        }
        if (arr1 == null || arr2 == null) {
            return false;
        }
        HashSet<String> s = new HashSet<String>();
        for (ConsentConfiguration a : arr1) {
            s.add(this.consentConfigToString(a));
        }
        for (ConsentConfiguration a : arr2) {
            s.remove(this.consentConfigToString(a));
        }
        return s.size() == 0;
    }

    private String consentConfigToString(ConsentConfiguration cc) {
        StringBuilder sb = new StringBuilder();
        sb.append("consentAccepted=");
        sb.append(cc.isConsentAccepted());
        sb.append("consentId=");
        sb.append(cc.getConsentId());
        String ccOwner = DEFAULT_OWNER;
        if (cc.getOwner() != null) {
            ccOwner = cc.getOwner();
        }
        sb.append("owner=");
        sb.append(ccOwner);
        return sb.toString();
    }

    private Boolean ceipConsentAccepted(ConsentConfiguration[] cc) {
        for (int i = 0; cc != null && i < cc.length; ++i) {
            if (cc[i].getConsentId() != 2) continue;
            return cc[i].isConsentAccepted();
        }
        return null;
    }

    private ConsentConfiguration[] changeCeipConsentAccepted(ConsentConfiguration[] cc, Boolean consentAccepted) {
        if (cc == null) {
            return new ConsentConfiguration[]{new ConsentConfiguration(consentAccepted.booleanValue(), 1, DEFAULT_OWNER), new ConsentConfiguration(consentAccepted.booleanValue(), 2, DEFAULT_OWNER)};
        }
        cc = this.changeCeipConsentAccepted(1, cc, consentAccepted);
        cc = this.changeCeipConsentAccepted(2, cc, consentAccepted);
        return cc;
    }

    private ConsentConfiguration[] changeCeipConsentAccepted(int ceipConsentId, ConsentConfiguration[] cc, Boolean consentAccepted) {
        boolean isCeipConsentAvailable = false;
        cc = this.deepCopy(cc);
        for (int i = 0; i < cc.length; ++i) {
            if (cc[i].getConsentId() != ceipConsentId) continue;
            cc[i].setConsentAccepted(consentAccepted.booleanValue());
            isCeipConsentAvailable = true;
        }
        if (!isCeipConsentAvailable) {
            cc = Arrays.copyOf(cc, cc.length + 1);
            cc[cc.length - 1] = new ConsentConfiguration(consentAccepted.booleanValue(), ceipConsentId, DEFAULT_OWNER);
        }
        return cc;
    }

    private ConsentConfiguration[] deepCopy(ConsentConfiguration[] cc) {
        ConsentConfiguration[] result = new ConsentConfiguration[cc.length];
        for (int i = 0; i < cc.length; ++i) {
            result[i] = new ConsentConfiguration(cc[i].isConsentAccepted(), cc[i].getConsentId(), cc[i].getOwner());
        }
        return result;
    }
}

