/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.ph.ceip.impl;

import com.vmware.ph.ceip.CeipApi;
import com.vmware.ph.config.ceip.CeipConfigProvider;
import com.vmware.vise.util.client.configuration.ConfigurationService;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CeipConfigProviderImpl
implements CeipConfigProvider {
    private static final Logger logger = LoggerFactory.getLogger(CeipConfigProviderImpl.class);
    private static final String DEV_OVERRIDE_ENABLEMENT_FLAG = "dev.usageDataCollector.forceCollectorEnabled";
    private final ConfigurationService _configurationService;
    private final CeipApi _ceipApi;

    public CeipConfigProviderImpl(CeipApi ceipApi, ConfigurationService configurationService) {
        this._ceipApi = ceipApi;
        this._configurationService = configurationService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isCeipEnabled() {
        ClassLoader originalClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(CeipConfigProviderImpl.class.getClassLoader());
            Boolean value = this._ceipApi.isConsentAccepted();
            logger.debug("ceipEnabled read from db: {}", (Object)value);
            boolean ceipEnabled = value != null ? value : false;
            boolean devModeIsEnabled = this.getConfigFlag(DEV_OVERRIDE_ENABLEMENT_FLAG);
            logger.debug("dev property: {}", (Object)devModeIsEnabled);
            boolean bl = ceipEnabled || devModeIsEnabled;
            return bl;
        }
        finally {
            Thread.currentThread().setContextClassLoader(originalClassLoader);
        }
    }

    private boolean getConfigFlag(String flagName) {
        Object[] truths = new String[]{"yes", "on", "true"};
        String flagValue = this._configurationService.getProperty(flagName);
        return ArrayUtils.contains((Object[])truths, (Object)StringUtils.lowerCase((String)flagValue));
    }
}

