/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.ph.ceip.impl;

import com.vmware.ph.ceip.impl.ClosableStubWrapper;
import com.vmware.ph.ceip.impl.DisallowAllThumbprintVerifier;
import com.vmware.ph.exceptions.Bug;
import com.vmware.vim.binding.lookup.ServiceRegistration;
import com.vmware.vim.binding.lookup.version.version2;
import com.vmware.vim.vmomi.client.Client;
import com.vmware.vim.vmomi.client.ClientConfiguration;
import com.vmware.vim.vmomi.client.ext.ServerEndpointProvider;
import com.vmware.vim.vmomi.client.http.HttpClientConfiguration;
import com.vmware.vim.vmomi.client.http.HttpConfiguration;
import com.vmware.vim.vmomi.client.http.ThumbprintVerifier;
import com.vmware.vim.vmomi.core.types.VmodlContext;
import com.vmware.vise.util.net.ssl.SSLConfigurationProvider;
import com.vmware.vise.vim.commons.ssl.KeystoreService;
import com.vmware.vise.vim.commons.vmomi.OpIdAwareClientFactory;
import com.vmware.vise.vim.commons.vmomi.VmomiClientHelper;
import com.vmware.vise.vim.connections.SiteAffinityServerEndpointProvider;
import com.vmware.vise.vim.lookup.LookupService;
import com.vmware.vsphere.client.ceip.util.VlsiUtil;
import java.net.URI;
import java.net.URISyntaxException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConsentConfigurationServiceLocator {
    private static final Logger logger = LoggerFactory.getLogger(ConsentConfigurationServiceLocator.class);
    static final String CCS_SDK_PATH = "/ls/ph/sdk";
    static final String LICENSING_SDK_PATH = "/ls/sdk";
    static final String PH_SERVICE_ENDPOINT_TYPE = "com.vmware.ph.globalconfig.consentservice";
    static final String LICENSEING_SERVICE_ENDPOINT_TYPE = "com.vmware.cis.cs.license.sdk";
    static final DisallowAllThumbprintVerifier disallowAllVerifier = new DisallowAllThumbprintVerifier();
    private final LookupService _lookupService;
    private final VmodlContext _vmodlContext;
    private final KeystoreService _keystoreService;
    private final SSLConfigurationProvider _sslConfigProvider;
    private final AffinityEndpointProviderFactory _affinityEpProviderFactory;
    private URI _phServiceUrl;
    private String _lookupServiceUrl;

    public ConsentConfigurationServiceLocator(LookupService lookupService, KeystoreService keystoreService, VmodlContext vmodlContext, SSLConfigurationProvider sslConfigProvider) {
        this(lookupService, keystoreService, vmodlContext, new AffinityEndpointProviderFactory(), sslConfigProvider);
    }

    ConsentConfigurationServiceLocator(LookupService lookupService, KeystoreService keystoreService, VmodlContext vmodlContext, AffinityEndpointProviderFactory affinityEpProviderFactory, SSLConfigurationProvider sslConfigProvider) {
        this._lookupService = lookupService;
        this._keystoreService = keystoreService;
        this._sslConfigProvider = sslConfigProvider;
        this._vmodlContext = vmodlContext;
        this._affinityEpProviderFactory = affinityEpProviderFactory;
    }

    public synchronized URI getConsentConfigServiceUrl() {
        this.refreshPhServiceUri();
        logger.debug("phUrl is: {}", (Object)this._phServiceUrl);
        return this._phServiceUrl;
    }

    private void refreshPhServiceUri() {
        if (!this.isRefreshNeeded()) {
            return;
        }
        this._lookupServiceUrl = this._lookupService.getServiceUrl();
        URI licensingServiceUrl = null;
        try (ClosableStubWrapper<ServiceRegistration> srWrapper = this.initializeLookupServiceVlsiClient(this._lookupServiceUrl);){
            ServiceRegistration serviceRegistration = srWrapper.getStub();
            URI newPhServiceUri = this.getEndpointUriByEndpointType(serviceRegistration, PH_SERVICE_ENDPOINT_TYPE);
            if (newPhServiceUri != null) {
                this._phServiceUrl = newPhServiceUri;
                logger.debug("Found endpoint of type {} with URL {}.", (Object)PH_SERVICE_ENDPOINT_TYPE, (Object)this._phServiceUrl);
                return;
            }
            logger.debug("LookupService does not contain endpoints of type {}. Will look for endpoints of type {} and construct the URL as relative to the found one.", (Object)PH_SERVICE_ENDPOINT_TYPE, (Object)LICENSEING_SERVICE_ENDPOINT_TYPE);
            licensingServiceUrl = this.getEndpointUriByEndpointType(serviceRegistration, LICENSEING_SERVICE_ENDPOINT_TYPE);
        }
        if (licensingServiceUrl == null) {
            throw new IllegalStateException("Cannot initialize ConsentConfigService because LookupService does not contain registration neither of endpoint type com.vmware.ph.globalconfig.consentservicenor of endpoint type com.vmware.cis.cs.license.sdk.");
        }
        if (LICENSING_SDK_PATH.equals(licensingServiceUrl.getPath())) {
            try {
                this._phServiceUrl = new URI(licensingServiceUrl.getScheme(), licensingServiceUrl.getUserInfo(), licensingServiceUrl.getHost(), licensingServiceUrl.getPort(), CCS_SDK_PATH, licensingServiceUrl.getQuery(), licensingServiceUrl.getFragment());
                return;
            }
            catch (URISyntaxException e) {
                throw new Bug("Cannot construct URI.", (Throwable)e);
            }
        }
        throw new IllegalStateException("Found URI of the Licensing service: " + licensingServiceUrl + "Its path " + licensingServiceUrl.getPath() + " is not equal to the expected " + LICENSING_SDK_PATH + ". " + "Changing CEIP status through UI will not work properly because of this fact.");
    }

    private boolean isRefreshNeeded() {
        if (this._phServiceUrl != null && this._lookupServiceUrl != null && this._lookupServiceUrl.equals(this._lookupService.getServiceUrl())) {
            URI affinityPhServiceUri;
            String lsUrl = this._lookupService.getServiceUrl();
            URI lookupServiceUrl = this.toUri(lsUrl);
            if (lookupServiceUrl.equals(affinityPhServiceUri = this._affinityEpProviderFactory.create(lookupServiceUrl).getServerEndpoint())) {
                logger.trace("Skipping PhServiceUri refresh - no need to refresh it. phUrl is: {}", (Object)this._phServiceUrl);
                return false;
            }
            logger.debug("PhServiceUri will be refreshed since there is difference between the one in the lookup service (LS URL = '{}') and the comming from the affinity provider (affinity URL = '{}'). This is probably due to broken primary PSC HA node all requests are now routed to a working PSC HA node", (Object)lookupServiceUrl, (Object)affinityPhServiceUri);
            return true;
        }
        return true;
    }

    private URI getEndpointUriByEndpointType(ServiceRegistration serviceRegistration, String endpointTypeId) {
        logger.debug("Searching LookupService for service with endpointType: {}", (Object)endpointTypeId);
        ServiceRegistration.EndpointType endpointType = new ServiceRegistration.EndpointType(null, endpointTypeId);
        ServiceRegistration.Filter filterCriteria = new ServiceRegistration.Filter(serviceRegistration.getSiteId(), null, null, endpointType);
        Object[] serviceList = serviceRegistration.list(filterCriteria);
        logger.trace("serviceList: {}", serviceList);
        if (serviceList != null && serviceList.length > 0) {
            for (Object service : serviceList) {
                for (ServiceRegistration.Endpoint endpoint : service.getServiceEndpoints()) {
                    if (!endpointTypeId.equals(endpoint.getEndpointType().getType())) continue;
                    return endpoint.getUrl();
                }
            }
            logger.debug("No service from the array returned by list() contains endpoint of type {}.", (Object)endpointTypeId);
        } else {
            logger.debug("LookupService list() for endpoint of types {} resulted in empty array.", (Object)endpointTypeId);
        }
        return null;
    }

    private ClosableStubWrapper<ServiceRegistration> initializeLookupServiceVlsiClient(String lookupServiceUrl) {
        SiteAffinityServerEndpointProvider lookupServiceUrlProvider = this._affinityEpProviderFactory.create(this.toUri(lookupServiceUrl));
        HttpClientConfiguration httpClientConfig = this.createHttpClientConfiguration((ServerEndpointProvider)lookupServiceUrlProvider);
        Client client = OpIdAwareClientFactory.createClient(null, version2.class, (VmodlContext)this._vmodlContext, (ClientConfiguration)httpClientConfig);
        ServiceRegistration svcReg = (ServiceRegistration)VmomiClientHelper.createStub((Client)client, ServiceRegistration.class, (String)"ServiceRegistration", (ClassLoader)ConsentConfigurationServiceLocator.class.getClassLoader());
        return new ClosableStubWrapper<ServiceRegistration>(client, svcReg);
    }

    private HttpClientConfiguration createHttpClientConfiguration(ServerEndpointProvider provider) {
        HttpClientConfiguration httpClientConfig = HttpClientConfiguration.Factory.newInstance();
        HttpConfiguration httpConfig = httpClientConfig.getHttpConfiguration();
        httpConfig.setTrustStore(this._keystoreService.getKeyStore());
        httpConfig.setThumbprintVerifier((ThumbprintVerifier)disallowAllVerifier);
        if (this._sslConfigProvider.getEnabledProtocols() != null) {
            httpConfig.setEnabledProtocols(this._sslConfigProvider.getEnabledProtocols());
        }
        VlsiUtil.setHttpResponseTimeout(httpClientConfig);
        httpClientConfig.setServerEndpointProvider(provider);
        return httpClientConfig;
    }

    private URI toUri(String lookupServiceUrl) {
        URI uri;
        try {
            uri = new URI(lookupServiceUrl);
        }
        catch (URISyntaxException e) {
            throw new Bug("Not possible URISyntaxException happend while trying to initialize lookup service client.", (Throwable)e);
        }
        return uri;
    }

    static class AffinityEndpointProviderFactory {
        AffinityEndpointProviderFactory() {
        }

        public SiteAffinityServerEndpointProvider create(URI serverUri) {
            return new SiteAffinityServerEndpointProvider(serverUri);
        }
    }
}

