/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.ph.ceip.impl;

import com.vmware.ph.ceip.CeipApi;
import com.vmware.ph.ceip.CeipApiException;
import com.vmware.ph.ceip.authentication.DsSessionSimulator;
import com.vmware.ph.ceip.authentication.SessionSimulationException;
import com.vmware.ph.ceip.authentication.solutionuser.SolutionUserAuthenticationConfig;
import java.util.Timer;
import java.util.TimerTask;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Synchronizer {
    private static final Logger log = LoggerFactory.getLogger(Synchronizer.class);
    private final DsSessionSimulator sessionSimulator;
    private final SolutionUserAuthenticationConfig authConfig;
    private final CeipApi ceipApi;
    private final int startPeriod;
    private final int timeoutPeriod;
    private final Timer timer;

    public Synchronizer(int startPeriod, CeipApi ceipApi, DsSessionSimulator sessionSimulator, SolutionUserAuthenticationConfig authConfig) {
        this(startPeriod, startPeriod, ceipApi, sessionSimulator, authConfig, new TimerFactory());
    }

    Synchronizer(int startPeriod, int timeoutPeriod, CeipApi ceipApi, DsSessionSimulator sessionSimulator, SolutionUserAuthenticationConfig authConfig, TimerFactory timerFactory) {
        this.startPeriod = startPeriod;
        this.timeoutPeriod = timeoutPeriod;
        this.ceipApi = ceipApi;
        this.timer = timerFactory.createTimer();
        this.sessionSimulator = sessionSimulator;
        this.authConfig = authConfig;
    }

    public void scheduleNewSyncTask() {
        this.timer.scheduleAtFixedRate(new TimerTask(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                HttpServletRequest request = null;
                try {
                    request = Synchronizer.this.sessionSimulator.simulate(Synchronizer.this.authConfig, "synchronizer_solution_user_actor_simulation");
                    int seconds = Synchronizer.this.startPeriod / 1000;
                    Synchronizer.this.sync();
                    log.info("Global consent status synchronizer will start again after " + seconds + " s.");
                }
                catch (SessionSimulationException sse) {
                    log.error("Global consent status synchronizer has stopped unexpectedly. There was an error while simulating UI Platform session that is unaware of http context. As a result the local consent state will not be synchronized with other consent states. This may be a temporary issue in the UI Platform, and all may work on the next execution. If the issue persists, please file an SR to PhoneHome team with the error details: " + sse.getMessage(), (Throwable)sse);
                }
                catch (RuntimeException e) {
                    log.error("Global consent status synchronizer has stopped unexpectedly. As a result the local consent state will not be synchronized with other consent states. To recover please verify/fix the exact reason in the cause exception and restart the service", (Throwable)e);
                }
                finally {
                    log.debug("Destroying session.");
                    Synchronizer.this.sessionSimulator.close(request);
                }
            }
        }, this.startPeriod, (long)this.timeoutPeriod);
        log.info("CEIP synchronization scheduleAtFixedRate, delay = " + this.startPeriod + " / period = " + this.timeoutPeriod);
    }

    public void cancel() {
        this.timer.cancel();
    }

    private void sync() {
        log.info("Synchronization with the other PSC nodes started...");
        try {
            this.ceipApi.sync();
            log.info("Synchronization with the other PSC nodes finished successfuly");
        }
        catch (CeipApiException e) {
            log.warn("Error while synchronizing the CopnsentConfiguration between different PSC nodes. The detailed reason is contained in the inner exception log. As a result of this problem the current consent configuration is out of sync with the other PSC nodes.", (Throwable)e);
        }
    }

    static class TimerFactory {
        TimerFactory() {
        }

        public Timer createTimer() {
            return new Timer("CEIPSynchronizerTimer", true);
        }
    }
}

