/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.ph.ceip.impl;

import com.vmware.ph.ceip.ConsentConfigurationServiceFactory;
import com.vmware.ph.ceip.impl.ClosableStubWrapper;
import com.vmware.ph.ceip.impl.ConsentConfigurationServiceLocator;
import com.vmware.vim.binding.phonehome.service.ConsentConfigurationService;
import com.vmware.vim.binding.phonehome.version.version1;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vim.sso.client.SamlToken;
import com.vmware.vim.vmomi.client.Client;
import com.vmware.vim.vmomi.client.ClientConfiguration;
import com.vmware.vim.vmomi.client.http.HttpClientConfiguration;
import com.vmware.vim.vmomi.client.http.HttpConfiguration;
import com.vmware.vim.vmomi.core.RequestContext;
import com.vmware.vim.vmomi.core.impl.RequestContextImpl;
import com.vmware.vim.vmomi.core.security.SignInfo;
import com.vmware.vim.vmomi.core.security.impl.SignInfoImpl;
import com.vmware.vim.vmomi.core.types.VmodlContext;
import com.vmware.vise.util.net.ssl.SSLConfigurationProvider;
import com.vmware.vise.vim.commons.ssl.KeystoreService;
import com.vmware.vise.vim.commons.sso.AuthSessionUtil;
import com.vmware.vise.vim.commons.vmomi.OpIdAwareClientFactory;
import com.vmware.vise.vim.commons.vmomi.VmomiClientHelper;
import com.vmware.vise.vim.security.sso.SsoService;
import com.vmware.vsphere.client.ceip.util.VlsiUtil;
import java.net.URI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserSessionVlsiStubsFactory
implements ConsentConfigurationServiceFactory {
    private static final Logger logger = LoggerFactory.getLogger(UserSessionVlsiStubsFactory.class);
    private final ConsentConfigurationServiceLocator _ccsLocator;
    private final VmodlContext _vmodlContext;
    private final KeystoreService _keystoreService;
    private final SsoService _ssoService;
    private final SSLConfigurationProvider _sslConfigProvider;

    public UserSessionVlsiStubsFactory(ConsentConfigurationServiceLocator ccsLocator, KeystoreService keystoreService, SsoService ssoService, VmodlContext vmodlContext, SSLConfigurationProvider sslConfigProvider) {
        this._ccsLocator = ccsLocator;
        this._keystoreService = keystoreService;
        this._ssoService = ssoService;
        this._vmodlContext = vmodlContext;
        this._sslConfigProvider = sslConfigProvider;
    }

    @Override
    public ClosableStubWrapper<ConsentConfigurationService> getAuthenticatedStub() {
        logger.debug("getAuthenticatedStub started");
        return this.initializeCcsVlsiClient();
    }

    private ClosableStubWrapper<ConsentConfigurationService> initializeCcsVlsiClient() {
        logger.debug("initializeCcsVlsiClient started");
        HttpClientConfiguration httpClientConfig = this.createUserHttpClientConfiguration();
        URI ccsUrl = this._ccsLocator.getConsentConfigServiceUrl();
        logger.debug("Will create CCS stub against URL: {}", (Object)ccsUrl);
        Client client = OpIdAwareClientFactory.createClient((URI)ccsUrl, version1.class, (VmodlContext)this._vmodlContext, (ClientConfiguration)httpClientConfig);
        String wsdlName = this._vmodlContext.getVmodlTypeMap().getVmodlType(ConsentConfigurationService.class).getWsdlName();
        ManagedObjectReference moRef = new ManagedObjectReference(wsdlName, "ccService");
        ConsentConfigurationService svc = (ConsentConfigurationService)VmomiClientHelper.createStub((Client)client, ConsentConfigurationService.class, (ManagedObjectReference)moRef, (ClassLoader)UserSessionVlsiStubsFactory.class.getClassLoader());
        return new ClosableStubWrapper<ConsentConfigurationService>(client, svc);
    }

    private HttpClientConfiguration createUserHttpClientConfiguration() {
        logger.debug("creating http client configuration");
        HttpClientConfiguration httpClientConfig = HttpClientConfiguration.Factory.newInstance();
        HttpConfiguration httpConfig = httpClientConfig.getHttpConfiguration();
        httpConfig.setTrustStore(this._keystoreService.getKeyStore());
        httpConfig.setThumbprintVerifier(disallowAllowVerifier);
        if (this._sslConfigProvider.getEnabledProtocols() != null) {
            httpConfig.setEnabledProtocols(this._sslConfigProvider.getEnabledProtocols());
        }
        VlsiUtil.setHttpResponseTimeout(httpClientConfig);
        SamlToken token = AuthSessionUtil.getSsoToken();
        RequestContextImpl requestContext = new RequestContextImpl();
        requestContext.setSignInfo((SignInfo)new SignInfoImpl(this._ssoService.getHokPrivateKey(), token));
        httpClientConfig.setRequestContext((RequestContext)requestContext);
        return httpClientConfig;
    }
}

