/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.ph.ceip.impl;

import com.vmware.ph.ceip.DBConnectionException;
import com.vmware.ph.ceip.VcdbConsentManager;
import com.vmware.ph.common.json.JsonSerializer;
import com.vmware.ph.exceptions.Bug;
import com.vmware.vim.binding.phonehome.data.ConsentConfigurationData;
import com.vmware.vim.binding.vim.fault.InvalidName;
import com.vmware.vim.binding.vim.option.OptionManager;
import com.vmware.vim.binding.vim.option.OptionValue;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vim.binding.vmodl.RuntimeFault;
import com.vmware.vim.vmomi.client.exception.RemoteException;
import com.vmware.vise.vim.commons.vcservice.VcService;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VcdbConsentManagerImpl
implements VcdbConsentManager {
    private static final String CONSENT_VC_SETTING_KEY = "VirtualCenter.DataCollector.ConsentData";
    private static final Logger logger = LoggerFactory.getLogger(VcdbConsentManagerImpl.class);
    private final VcService _vcService;

    public VcdbConsentManagerImpl(VcService vcService) {
        this._vcService = vcService;
    }

    @Override
    public ConsentConfigurationData readConsent() throws DBConnectionException {
        Object value = this.readOptionValue(CONSENT_VC_SETTING_KEY);
        if (value == null) {
            logger.debug("ConsentData read from OptionManager is null.");
            return null;
        }
        String stringValue = (String)value;
        logger.debug("ConsentData read from OptionManager is: {}", (Object)stringValue);
        try {
            ConsentConfigurationData result = (ConsentConfigurationData)JsonSerializer.readObject((String)stringValue, ConsentConfigurationData.class);
            logger.debug("readConsent completed successfully: {}", (Object)result);
            return result;
        }
        catch (IOException e) {
            logger.warn("Cannot deserialize " + ConsentConfigurationData.class.getName() + " from the following value: " + stringValue + ". Will default to null.");
            return null;
        }
    }

    @Override
    public void writeConsent(ConsentConfigurationData consent) throws DBConnectionException {
        logger.debug("writeConsent: start, consent: {}", (Object)consent);
        String stringValue = null;
        if (consent != null) {
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            try {
                JsonSerializer.writeObject((Object)consent, (OutputStream)outputStream);
                stringValue = ((Object)outputStream).toString();
            }
            catch (IOException e) {
                throw new Bug("Failed to serialize " + ConsentConfigurationData.class.getName() + " to Json.", (Throwable)e);
            }
            finally {
                IOUtils.closeQuietly((OutputStream)outputStream);
            }
        }
        this.writeOptionValue(CONSENT_VC_SETTING_KEY, stringValue);
        logger.debug("writeConsent: completed successfully");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    OptionManager initializeOptionManager() {
        ClassLoader originalLoader = Thread.currentThread().getContextClassLoader();
        ClassLoader thisClassLoader = this.getClass().getClassLoader();
        Thread.currentThread().setContextClassLoader(thisClassLoader);
        try {
            OptionManager optionManager;
            ManagedObjectReference vcSettingsId = this._vcService.getServiceInstanceContent().getSetting();
            OptionManager optionManager2 = optionManager = (OptionManager)this._vcService.getManagedObject(vcSettingsId);
            return optionManager2;
        }
        finally {
            Thread.currentThread().setContextClassLoader(originalLoader);
        }
    }

    private Object readOptionValue(String key) throws DBConnectionException {
        OptionValue[] result;
        logger.debug("Retrieving value for option with key: " + key);
        OptionManager optionManager = this.initializeOptionManager();
        if (optionManager == null) {
            throw new DBConnectionException("Cannot initialize OptionManager");
        }
        try {
            result = optionManager.queryView(key);
        }
        catch (InvalidName e) {
            throw new DBConnectionException("Cannot find option with name " + key + " .", e);
        }
        catch (RuntimeFault e) {
            throw new DBConnectionException("Failed to read option with name " + key + " .", e);
        }
        catch (RemoteException e) {
            throw new DBConnectionException("Failed to read option with name " + key + " .", e);
        }
        logger.debug("Got {} result(s).", (Object)result.length);
        Object firstResult = result.length > 0 ? result[0].getValue() : null;
        logger.debug("Retrieved {} = {}", (Object)key, firstResult);
        return firstResult;
    }

    private void writeOptionValue(String key, Object value) throws DBConnectionException {
        OptionManager optionManager = this.initializeOptionManager();
        if (optionManager == null) {
            throw new DBConnectionException("Unable to initialze OptionManager");
        }
        logger.debug("Updating option {} with value {}", (Object)key, value);
        try {
            OptionValue optionValue = new OptionValue(key, value);
            optionManager.updateValues(new OptionValue[]{optionValue});
        }
        catch (InvalidName e) {
            throw new DBConnectionException(String.format("vCenter service does not support configuration key `%s' (incompatible vCenter version)", key), e);
        }
        catch (RuntimeFault e) {
            throw new DBConnectionException("Failed to write option " + key + " with value " + value + ".", e);
        }
        catch (RemoteException e) {
            throw new DBConnectionException("Failed to write option " + key + " with value " + value + ".", e);
        }
        logger.debug("Updating option {} with value {} completed successfully.", (Object)key, value);
    }
}

