/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.ceip.impl;

import com.vmware.ph.CollectionConfiguration;
import com.vmware.ph.ceip.CeipApi;
import com.vmware.ph.ceip.ConsentConfigurationServiceFactory;
import com.vmware.ph.ceip.impl.ClosableStubWrapper;
import com.vmware.vim.binding.phonehome.service.ConsentConfigurationService;
import com.vmware.vim.binding.vmodl.fault.SecurityError;
import com.vmware.vise.vim.commons.vcservice.VcService;
import com.vmware.vsphere.client.ceip.CeipService;
import com.vmware.vsphere.client.ceip.CmcVcConfiguration;
import com.vmware.vsphere.client.ceip.util.VcUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CeipServiceImpl
implements CeipService {
    private static final long FORCE_REFRESH_TIMEOUT_NANOS = TimeUnit.MINUTES.toNanos(1L);
    private static final String VC_MIN_VERSION = "6.0.0";
    private static final Logger logger = LoggerFactory.getLogger(CeipServiceImpl.class);
    private final VcUtil _vcUtil;
    private final CeipApi _ceipApi;
    private final ConsentConfigurationServiceFactory _ccsFactory;
    private long _lastSynchronizedTime = 0L;
    private final Object _lastSynchronizedTimeLock = new Object();

    public CeipServiceImpl(VcUtil vcUtil, CeipApi ceipApi, ConsentConfigurationServiceFactory ccsFactory) {
        this._vcUtil = vcUtil;
        this._ceipApi = ceipApi;
        this._ccsFactory = ccsFactory;
    }

    @Override
    public boolean isUserCeipAuthorized() {
        logger.debug("getCeipAuthorizationStatus: started");
        ClassLoader originalClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
            try {
                boolean bl = this.isCurrentUserAuthorizedToChangeCeip();
                return bl;
            }
            catch (RuntimeException e) {
                logger.error("Error occurred in isUserCeipAuthorized.", (Throwable)e);
                throw e;
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(originalClassLoader);
        }
    }

    @Override
    public boolean isCollectionEnabled() {
        logger.debug("isCollectionEnabled: started");
        ClassLoader originalClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
            try {
                this.syncCeipApi();
                Boolean status = this._ceipApi.isConsentAccepted();
                boolean bl = status == null ? false : status;
                return bl;
            }
            catch (RuntimeException e) {
                logger.error("Error occurred in isCollectionEnabled.", (Throwable)e);
                throw e;
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(originalClassLoader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setCollectionEnabled(boolean enabled) {
        logger.debug("setCollectionEnabled was executed.");
        ClassLoader originalClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
            try {
                this._ceipApi.setConsentAccepted(enabled);
            }
            catch (RuntimeException e) {
                logger.error("Error occurred in setCollectionEnabled.", (Throwable)e);
                throw e;
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(originalClassLoader);
        }
    }

    @Override
    public boolean showNotification() {
        logger.debug("showNotification: started");
        ClassLoader originalClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            block9: {
                Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
                try {
                    if (!this.isCeipConfigured() && this.isCurrentUserAuthorizedToChangeCeip()) break block9;
                    logger.debug("showNotification completed: false");
                    boolean bl = false;
                    return bl;
                }
                catch (RuntimeException e) {
                    logger.error("Error occurred in showNotification.", (Throwable)e);
                    throw e;
                }
            }
            List<CmcVcConfiguration> configurations = this.getVcCollectionConfigurations();
            for (CmcVcConfiguration config : configurations) {
                if (!config.wasCollectionEnabled()) continue;
                logger.debug("showNotification completed: true");
                boolean bl = true;
                return bl;
            }
            logger.debug("showNotification completed: false (defalt case)");
            boolean bl = false;
            return bl;
        }
        finally {
            Thread.currentThread().setContextClassLoader(originalClassLoader);
        }
    }

    private boolean isCeipConfigured() {
        return this._ceipApi.isConsentAccepted() != null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean isCurrentUserAuthorizedToChangeCeip() {
        try (ClosableStubWrapper<ConsentConfigurationService> ccsWrapper = this._ccsFactory.getAuthenticatedStub();){
            ConsentConfigurationService ccs = ccsWrapper.getStub();
            ccs.validatePrivilegeForSet();
            logger.debug("validatePrivilege method completed without exception which means current user has enough permissions to change CEIP.");
            boolean bl = true;
            return bl;
        }
        catch (SecurityError e) {
            logger.info("validatePrivilege method threw SecurityError which means current user does not have permissions to change CEIP. Exception message is: " + e.getMessage());
            return false;
        }
    }

    private List<CmcVcConfiguration> getVcCollectionConfigurations() {
        try {
            List<VcService> vcServices = this._vcUtil.getSessionVcServices();
            vcServices = this._vcUtil.filterVcServicesByVersion(vcServices, VC_MIN_VERSION);
            ArrayList<CmcVcConfiguration> resultVcsNotificationData = new ArrayList<CmcVcConfiguration>();
            for (VcService vcService : vcServices) {
                resultVcsNotificationData.add(new CmcVcConfiguration(vcService.getServiceGuid(), CollectionConfiguration.wasCollectionEnabled(vcService)));
            }
            return resultVcsNotificationData;
        }
        catch (Exception e) {
            logger.warn("Error occurred when retrieving UDC data. Assuming no notification is needed.", (Throwable)e);
            return Collections.emptyList();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void syncCeipApi() {
        Object object = this._lastSynchronizedTimeLock;
        synchronized (object) {
            long currentTime = System.nanoTime();
            if (currentTime - this._lastSynchronizedTime <= FORCE_REFRESH_TIMEOUT_NANOS) {
                logger.debug("No need to force CEIP synchronization.");
                return;
            }
            try {
                logger.debug("Start the ceipAPI sync operation");
                this._ceipApi.sync();
                this._lastSynchronizedTime = System.nanoTime();
                logger.debug("The ceipAPI sync operation completed successfully.");
            }
            catch (Exception e) {
                logger.warn("There is an error while performing CEIP synchronization before showing CEIP UI. As a result, the current CEIP status, showed in the NGC UI, may not be up to date with CEIP  status updates executed recently in other management nodes in a MxN deployment scenario. No action is needed - the periodic synchronization feature will synchronize CEIP status in time. For more details see the underlying error message: " + e.getMessage() + " If this error persists, please file an SR to the PhoneHome team regarding the CEIP feature.", (Throwable)e);
            }
        }
    }
}

