/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.ceip.util;

import com.vmware.ph.ProductVersion;
import com.vmware.vise.vim.commons.VimSessionUtil;
import com.vmware.vise.vim.commons.extensions.LinkedVcGroupRegistry;
import com.vmware.vise.vim.commons.vcservice.LinkedVcGroup;
import com.vmware.vise.vim.commons.vcservice.VcService;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

public class VcUtil {
    public static final String KEY_VC_NAME = "vc_name";
    public static final String KEY_VC_ROOT_FOLDER_MOREF = "vc_root_folder_moref";

    public List<VcService> getSessionVcServices() {
        ArrayList<VcService> resultVcServices = new ArrayList<VcService>();
        LinkedVcGroupRegistry vcRegistry = VimSessionUtil.getLinkedVcGroupRegistry();
        if (vcRegistry == null) {
            return resultVcServices;
        }
        LinkedVcGroup[] linkedVcGroups = vcRegistry.getLinkedVcGroups();
        if (linkedVcGroups == null) {
            return resultVcServices;
        }
        for (LinkedVcGroup linkedVcGroup : linkedVcGroups) {
            resultVcServices.addAll(linkedVcGroup.getVcServices());
        }
        return resultVcServices;
    }

    public List<VcService> filterVcServicesByVersion(List<VcService> vcServices, String minVersion) {
        ProductVersion minProductVersion = new ProductVersion(minVersion);
        LinkedList<VcService> result = new LinkedList<VcService>();
        for (VcService vc : vcServices) {
            ProductVersion vcVersion = new ProductVersion(vc.getServiceInstanceContent().about.version);
            if (vcVersion.compareTo(minProductVersion) < 0) continue;
            result.add(vc);
        }
        return result;
    }
}

