/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.flex.messaging;

import flex.messaging.FlexContext;
import flex.messaging.MessageBroker;
import flex.messaging.messages.AsyncMessage;
import flex.messaging.messages.Message;
import flex.messaging.util.UUIDUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.flex.messaging.AsyncMessageCreator;
import org.springframework.util.Assert;

public class MessageTemplate
implements InitializingBean,
BeanFactoryAware {
    private static final Log log = LogFactory.getLog(MessageTemplate.class);
    private String defaultDestination;
    private MessageBroker messageBroker;
    private BeanFactory beanFactory;
    private final String clientId = UUIDUtils.createUUID();
    private final AsyncMessageCreator defaultMessageCreator = new DefaultAsyncMessageCreator();

    public void afterPropertiesSet() throws Exception {
        if (this.messageBroker == null) {
            if (this.beanFactory.containsBean("_messageBroker")) {
                this.messageBroker = (MessageBroker)this.beanFactory.getBean("_messageBroker", MessageBroker.class);
            } else if (this.beanFactory instanceof ListableBeanFactory) {
                ListableBeanFactory lbf = (ListableBeanFactory)this.beanFactory;
                String[] brokerNames = lbf.getBeanNamesForType(MessageBroker.class);
                if (brokerNames.length == 1) {
                    this.messageBroker = (MessageBroker)lbf.getBean(brokerNames[0]);
                } else if (brokerNames.length > 1) {
                    log.warn((Object)"A MessageBroker was not explicitly set and one could not be auto-detected in the MessageTemplate's bean factory as multiple MessageBrokers were found.  Will fall back to attempting to obtain the MessageBroker from the FlexContext for each operation.");
                } else {
                    log.warn((Object)"A MessageBroker was not explicitly set and one could not be found in the MessageTemplate's bean factory.  Will will fall back to attempting to obtain the MessageBroker from the FlexContext for each operation.");
                }
            }
        }
    }

    public AsyncMessage createMessage() {
        return this.defaultMessageCreator.createMessage();
    }

    public AsyncMessage createMessageForDestination(String destination) {
        AsyncMessage message = this.defaultMessageCreator.createMessage();
        message.setDestination(destination);
        return message;
    }

    public String getDefaultDestination() {
        return this.defaultDestination;
    }

    public MessageBroker getMessageBroker() {
        if (this.messageBroker != null) {
            return this.messageBroker;
        }
        Assert.notNull((Object)FlexContext.getMessageBroker(), (String)"A MessageBroker was not set on the MessageTemplate and no thread-local MessageBroker could be found in the FlexContext.");
        return FlexContext.getMessageBroker();
    }

    public void send(AsyncMessageCreator creator) {
        this.getMessageBroker().routeMessageToService((Message)creator.createMessage(), null);
    }

    public void send(Object body) {
        Assert.hasText((String)this.defaultDestination, (String)"Cannot send message - no default destination has been set for this MessageTemplate.");
        this.send(this.defaultDestination, body);
    }

    public void send(String destination, Object body) {
        AsyncMessage message = this.defaultMessageCreator.createMessage();
        message.setDestination(destination);
        message.setBody(body);
        this.getMessageBroker().routeMessageToService((Message)message, null);
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = beanFactory;
    }

    public void setDefaultDestination(String defaultDestination) {
        this.defaultDestination = defaultDestination;
    }

    public void setMessageBroker(MessageBroker messageBroker) {
        this.messageBroker = messageBroker;
    }

    private final class DefaultAsyncMessageCreator
    implements AsyncMessageCreator {
        private DefaultAsyncMessageCreator() {
        }

        public AsyncMessage createMessage() {
            AsyncMessage message = new AsyncMessage();
            message.setClientId((Object)MessageTemplate.this.clientId);
            message.setMessageId(UUIDUtils.createUUID());
            message.setTimestamp(System.currentTimeMillis());
            return message;
        }
    }
}

