/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.appliance.techpreview.networking;

import com.vmware.appliance.techpreview.networking.Ipv6Definitions;
import com.vmware.vapi.bindings.ApiEnumeration;
import com.vmware.vapi.bindings.StaticStructure;
import com.vmware.vapi.bindings.Structure;
import com.vmware.vapi.bindings.type.StructType;
import com.vmware.vapi.bindings.type.Type;
import com.vmware.vapi.client.exception.BindingsException;
import com.vmware.vapi.data.DataValue;
import com.vmware.vapi.data.StructValue;
import com.vmware.vapi.internal.bindings.BindingsUtil;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.Validate;

public interface Ipv6Types {

    public static final class IPv6Config
    implements Serializable,
    StaticStructure {
        private static final long serialVersionUID = 1L;
        private String interfaceName;
        private boolean dhcp;
        private boolean autoconf;
        private List<IPv6Address> addresses;
        private String defaultGateway;
        protected final StructValue __dynamicStructureFields;

        public IPv6Config() {
            this(IPv6Config.createEmptyStructValue());
        }

        protected IPv6Config(StructValue structValue) {
            Validate.notNull((Object)structValue);
            this.__dynamicStructureFields = structValue;
        }

        public String getInterfaceName() {
            return this.interfaceName;
        }

        public void setInterfaceName(String string) {
            this.interfaceName = string;
        }

        public boolean getDhcp() {
            return this.dhcp;
        }

        public void setDhcp(boolean bl) {
            this.dhcp = bl;
        }

        public boolean getAutoconf() {
            return this.autoconf;
        }

        public void setAutoconf(boolean bl) {
            this.autoconf = bl;
        }

        public List<IPv6Address> getAddresses() {
            return this.addresses;
        }

        public void setAddresses(List<IPv6Address> list) {
            this.addresses = list;
        }

        public String getDefaultGateway() {
            return this.defaultGateway;
        }

        public void setDefaultGateway(String string) {
            this.defaultGateway = string;
        }

        public StructType _getType() {
            return Ipv6Definitions.IPv6Config;
        }

        public StructValue _getDataValue() {
            StructValue structValue = this.__dynamicStructureFields.copy();
            this._updateDataValue(structValue);
            return structValue;
        }

        protected void _updateDataValue(StructValue structValue) {
            structValue.setField("interface_name", BindingsUtil.toDataValue((Object)this.interfaceName, (Type)this._getType().getField("interface_name")));
            structValue.setField("dhcp", BindingsUtil.toDataValue((Object)this.dhcp, (Type)this._getType().getField("dhcp")));
            structValue.setField("autoconf", BindingsUtil.toDataValue((Object)this.autoconf, (Type)this._getType().getField("autoconf")));
            structValue.setField("addresses", BindingsUtil.toDataValue(this.addresses, (Type)this._getType().getField("addresses")));
            structValue.setField("default_gateway", BindingsUtil.toDataValue((Object)this.defaultGateway, (Type)this._getType().getField("default_gateway")));
        }

        public void _validate() {
            this._getType().validate(this._getDataValue());
        }

        public boolean equals(Object object) {
            return BindingsUtil.areEqual((StaticStructure)this, (Object)object);
        }

        public int hashCode() {
            return BindingsUtil.computeHashCode((StaticStructure)this);
        }

        public String toString() {
            return BindingsUtil.convertToString((StaticStructure)this, (StructValue)this.__dynamicStructureFields);
        }

        public boolean _hasTypeNameOf(Class<? extends Structure> clazz) {
            return BindingsUtil.hasTypeNameOf((StructValue)this.__dynamicStructureFields, clazz);
        }

        public <T extends Structure> T _convertTo(Class<T> clazz) {
            return (T)BindingsUtil.convertTo((Structure)this, clazz);
        }

        public void _setDynamicField(String string, DataValue dataValue) {
            if (this._getType().getFieldNames().contains(string)) {
                throw new BindingsException("The structure contains static field with name " + string);
            }
            this.__dynamicStructureFields.setField(string, dataValue);
        }

        public DataValue _getDynamicField(String string) {
            if (!this.__dynamicStructureFields.getFieldNames().contains(string)) {
                throw new BindingsException("The structure doesn't contain dynamic field with name " + string);
            }
            return this.__dynamicStructureFields.getField(string);
        }

        public Set<String> _getDynamicFieldNames() {
            return this.__dynamicStructureFields.getFieldNames();
        }

        public static StructType _getClassType() {
            return Ipv6Definitions.IPv6Config;
        }

        public String _getCanonicalName() {
            return this.__dynamicStructureFields.getName();
        }

        public static String _getCanonicalTypeName() {
            return IPv6Config._getClassType().getName();
        }

        public static IPv6Config _newInstance(StructValue structValue) {
            return new IPv6Config(structValue);
        }

        private static StructValue createEmptyStructValue() {
            return new StructValue(Ipv6Definitions.IPv6Config.getName());
        }

        public static final class Builder {
            private String interfaceName;
            private boolean dhcp;
            private boolean autoconf;
            private List<IPv6Address> addresses;
            private String defaultGateway;

            public Builder(String string, boolean bl, boolean bl2, List<IPv6Address> list, String string2) {
                this.interfaceName = string;
                this.dhcp = bl;
                this.autoconf = bl2;
                this.addresses = list;
                this.defaultGateway = string2;
            }

            public IPv6Config build() {
                IPv6Config iPv6Config = new IPv6Config();
                iPv6Config.setInterfaceName(this.interfaceName);
                iPv6Config.setDhcp(this.dhcp);
                iPv6Config.setAutoconf(this.autoconf);
                iPv6Config.setAddresses(this.addresses);
                iPv6Config.setDefaultGateway(this.defaultGateway);
                return iPv6Config;
            }
        }
    }

    public static final class IPv6Address
    implements Serializable,
    StaticStructure {
        private static final long serialVersionUID = 1L;
        private String address;
        private long prefix;
        protected final StructValue __dynamicStructureFields;

        public IPv6Address() {
            this(IPv6Address.createEmptyStructValue());
        }

        protected IPv6Address(StructValue structValue) {
            Validate.notNull((Object)structValue);
            this.__dynamicStructureFields = structValue;
        }

        public String getAddress() {
            return this.address;
        }

        public void setAddress(String string) {
            this.address = string;
        }

        public long getPrefix() {
            return this.prefix;
        }

        public void setPrefix(long l) {
            this.prefix = l;
        }

        public StructType _getType() {
            return Ipv6Definitions.IPv6Address;
        }

        public StructValue _getDataValue() {
            StructValue structValue = this.__dynamicStructureFields.copy();
            this._updateDataValue(structValue);
            return structValue;
        }

        protected void _updateDataValue(StructValue structValue) {
            structValue.setField("address", BindingsUtil.toDataValue((Object)this.address, (Type)this._getType().getField("address")));
            structValue.setField("prefix", BindingsUtil.toDataValue((Object)this.prefix, (Type)this._getType().getField("prefix")));
        }

        public void _validate() {
            this._getType().validate(this._getDataValue());
        }

        public boolean equals(Object object) {
            return BindingsUtil.areEqual((StaticStructure)this, (Object)object);
        }

        public int hashCode() {
            return BindingsUtil.computeHashCode((StaticStructure)this);
        }

        public String toString() {
            return BindingsUtil.convertToString((StaticStructure)this, (StructValue)this.__dynamicStructureFields);
        }

        public boolean _hasTypeNameOf(Class<? extends Structure> clazz) {
            return BindingsUtil.hasTypeNameOf((StructValue)this.__dynamicStructureFields, clazz);
        }

        public <T extends Structure> T _convertTo(Class<T> clazz) {
            return (T)BindingsUtil.convertTo((Structure)this, clazz);
        }

        public void _setDynamicField(String string, DataValue dataValue) {
            if (this._getType().getFieldNames().contains(string)) {
                throw new BindingsException("The structure contains static field with name " + string);
            }
            this.__dynamicStructureFields.setField(string, dataValue);
        }

        public DataValue _getDynamicField(String string) {
            if (!this.__dynamicStructureFields.getFieldNames().contains(string)) {
                throw new BindingsException("The structure doesn't contain dynamic field with name " + string);
            }
            return this.__dynamicStructureFields.getField(string);
        }

        public Set<String> _getDynamicFieldNames() {
            return this.__dynamicStructureFields.getFieldNames();
        }

        public static StructType _getClassType() {
            return Ipv6Definitions.IPv6Address;
        }

        public String _getCanonicalName() {
            return this.__dynamicStructureFields.getName();
        }

        public static String _getCanonicalTypeName() {
            return IPv6Address._getClassType().getName();
        }

        public static IPv6Address _newInstance(StructValue structValue) {
            return new IPv6Address(structValue);
        }

        private static StructValue createEmptyStructValue() {
            return new StructValue(Ipv6Definitions.IPv6Address.getName());
        }

        public static final class Builder {
            private String address;
            private long prefix;

            public Builder(String string, long l) {
                this.address = string;
                this.prefix = l;
            }

            public IPv6Address build() {
                IPv6Address iPv6Address = new IPv6Address();
                iPv6Address.setAddress(this.address);
                iPv6Address.setPrefix(this.prefix);
                return iPv6Address;
            }
        }
    }

    public static final class IPv6ConfigReadOnly
    implements Serializable,
    StaticStructure {
        private static final long serialVersionUID = 1L;
        private String interfaceName;
        private boolean dhcp;
        private boolean autoconf;
        private List<IPv6AddressReadOnly> addresses;
        private String defaultGateway;
        private boolean updateable;
        protected final StructValue __dynamicStructureFields;

        public IPv6ConfigReadOnly() {
            this(IPv6ConfigReadOnly.createEmptyStructValue());
        }

        protected IPv6ConfigReadOnly(StructValue structValue) {
            Validate.notNull((Object)structValue);
            this.__dynamicStructureFields = structValue;
        }

        public String getInterfaceName() {
            return this.interfaceName;
        }

        public void setInterfaceName(String string) {
            this.interfaceName = string;
        }

        public boolean getDhcp() {
            return this.dhcp;
        }

        public void setDhcp(boolean bl) {
            this.dhcp = bl;
        }

        public boolean getAutoconf() {
            return this.autoconf;
        }

        public void setAutoconf(boolean bl) {
            this.autoconf = bl;
        }

        public List<IPv6AddressReadOnly> getAddresses() {
            return this.addresses;
        }

        public void setAddresses(List<IPv6AddressReadOnly> list) {
            this.addresses = list;
        }

        public String getDefaultGateway() {
            return this.defaultGateway;
        }

        public void setDefaultGateway(String string) {
            this.defaultGateway = string;
        }

        public boolean getUpdateable() {
            return this.updateable;
        }

        public void setUpdateable(boolean bl) {
            this.updateable = bl;
        }

        public StructType _getType() {
            return Ipv6Definitions.IPv6ConfigReadOnly;
        }

        public StructValue _getDataValue() {
            StructValue structValue = this.__dynamicStructureFields.copy();
            this._updateDataValue(structValue);
            return structValue;
        }

        protected void _updateDataValue(StructValue structValue) {
            structValue.setField("interface_name", BindingsUtil.toDataValue((Object)this.interfaceName, (Type)this._getType().getField("interface_name")));
            structValue.setField("dhcp", BindingsUtil.toDataValue((Object)this.dhcp, (Type)this._getType().getField("dhcp")));
            structValue.setField("autoconf", BindingsUtil.toDataValue((Object)this.autoconf, (Type)this._getType().getField("autoconf")));
            structValue.setField("addresses", BindingsUtil.toDataValue(this.addresses, (Type)this._getType().getField("addresses")));
            structValue.setField("default_gateway", BindingsUtil.toDataValue((Object)this.defaultGateway, (Type)this._getType().getField("default_gateway")));
            structValue.setField("updateable", BindingsUtil.toDataValue((Object)this.updateable, (Type)this._getType().getField("updateable")));
        }

        public void _validate() {
            this._getType().validate(this._getDataValue());
        }

        public boolean equals(Object object) {
            return BindingsUtil.areEqual((StaticStructure)this, (Object)object);
        }

        public int hashCode() {
            return BindingsUtil.computeHashCode((StaticStructure)this);
        }

        public String toString() {
            return BindingsUtil.convertToString((StaticStructure)this, (StructValue)this.__dynamicStructureFields);
        }

        public boolean _hasTypeNameOf(Class<? extends Structure> clazz) {
            return BindingsUtil.hasTypeNameOf((StructValue)this.__dynamicStructureFields, clazz);
        }

        public <T extends Structure> T _convertTo(Class<T> clazz) {
            return (T)BindingsUtil.convertTo((Structure)this, clazz);
        }

        public void _setDynamicField(String string, DataValue dataValue) {
            if (this._getType().getFieldNames().contains(string)) {
                throw new BindingsException("The structure contains static field with name " + string);
            }
            this.__dynamicStructureFields.setField(string, dataValue);
        }

        public DataValue _getDynamicField(String string) {
            if (!this.__dynamicStructureFields.getFieldNames().contains(string)) {
                throw new BindingsException("The structure doesn't contain dynamic field with name " + string);
            }
            return this.__dynamicStructureFields.getField(string);
        }

        public Set<String> _getDynamicFieldNames() {
            return this.__dynamicStructureFields.getFieldNames();
        }

        public static StructType _getClassType() {
            return Ipv6Definitions.IPv6ConfigReadOnly;
        }

        public String _getCanonicalName() {
            return this.__dynamicStructureFields.getName();
        }

        public static String _getCanonicalTypeName() {
            return IPv6ConfigReadOnly._getClassType().getName();
        }

        public static IPv6ConfigReadOnly _newInstance(StructValue structValue) {
            return new IPv6ConfigReadOnly(structValue);
        }

        private static StructValue createEmptyStructValue() {
            return new StructValue(Ipv6Definitions.IPv6ConfigReadOnly.getName());
        }

        public static final class Builder {
            private String interfaceName;
            private boolean dhcp;
            private boolean autoconf;
            private List<IPv6AddressReadOnly> addresses;
            private String defaultGateway;
            private boolean updateable;

            public Builder(String string, boolean bl, boolean bl2, List<IPv6AddressReadOnly> list, String string2, boolean bl3) {
                this.interfaceName = string;
                this.dhcp = bl;
                this.autoconf = bl2;
                this.addresses = list;
                this.defaultGateway = string2;
                this.updateable = bl3;
            }

            public IPv6ConfigReadOnly build() {
                IPv6ConfigReadOnly iPv6ConfigReadOnly = new IPv6ConfigReadOnly();
                iPv6ConfigReadOnly.setInterfaceName(this.interfaceName);
                iPv6ConfigReadOnly.setDhcp(this.dhcp);
                iPv6ConfigReadOnly.setAutoconf(this.autoconf);
                iPv6ConfigReadOnly.setAddresses(this.addresses);
                iPv6ConfigReadOnly.setDefaultGateway(this.defaultGateway);
                iPv6ConfigReadOnly.setUpdateable(this.updateable);
                return iPv6ConfigReadOnly;
            }
        }
    }

    public static final class IPv6AddressReadOnly
    implements Serializable,
    StaticStructure {
        private static final long serialVersionUID = 1L;
        private String address;
        private long prefix;
        private IPv6AddressOrigin origin;
        private IPv6AddressStatus status;
        protected final StructValue __dynamicStructureFields;

        public IPv6AddressReadOnly() {
            this(IPv6AddressReadOnly.createEmptyStructValue());
        }

        protected IPv6AddressReadOnly(StructValue structValue) {
            Validate.notNull((Object)structValue);
            this.__dynamicStructureFields = structValue;
        }

        public String getAddress() {
            return this.address;
        }

        public void setAddress(String string) {
            this.address = string;
        }

        public long getPrefix() {
            return this.prefix;
        }

        public void setPrefix(long l) {
            this.prefix = l;
        }

        public IPv6AddressOrigin getOrigin() {
            return this.origin;
        }

        public void setOrigin(IPv6AddressOrigin iPv6AddressOrigin) {
            this.origin = iPv6AddressOrigin;
        }

        public IPv6AddressStatus getStatus() {
            return this.status;
        }

        public void setStatus(IPv6AddressStatus iPv6AddressStatus) {
            this.status = iPv6AddressStatus;
        }

        public StructType _getType() {
            return Ipv6Definitions.IPv6AddressReadOnly;
        }

        public StructValue _getDataValue() {
            StructValue structValue = this.__dynamicStructureFields.copy();
            this._updateDataValue(structValue);
            return structValue;
        }

        protected void _updateDataValue(StructValue structValue) {
            structValue.setField("address", BindingsUtil.toDataValue((Object)this.address, (Type)this._getType().getField("address")));
            structValue.setField("prefix", BindingsUtil.toDataValue((Object)this.prefix, (Type)this._getType().getField("prefix")));
            structValue.setField("origin", BindingsUtil.toDataValue((Object)((Object)this.origin), (Type)this._getType().getField("origin")));
            structValue.setField("status", BindingsUtil.toDataValue((Object)((Object)this.status), (Type)this._getType().getField("status")));
        }

        public void _validate() {
            this._getType().validate(this._getDataValue());
        }

        public boolean equals(Object object) {
            return BindingsUtil.areEqual((StaticStructure)this, (Object)object);
        }

        public int hashCode() {
            return BindingsUtil.computeHashCode((StaticStructure)this);
        }

        public String toString() {
            return BindingsUtil.convertToString((StaticStructure)this, (StructValue)this.__dynamicStructureFields);
        }

        public boolean _hasTypeNameOf(Class<? extends Structure> clazz) {
            return BindingsUtil.hasTypeNameOf((StructValue)this.__dynamicStructureFields, clazz);
        }

        public <T extends Structure> T _convertTo(Class<T> clazz) {
            return (T)BindingsUtil.convertTo((Structure)this, clazz);
        }

        public void _setDynamicField(String string, DataValue dataValue) {
            if (this._getType().getFieldNames().contains(string)) {
                throw new BindingsException("The structure contains static field with name " + string);
            }
            this.__dynamicStructureFields.setField(string, dataValue);
        }

        public DataValue _getDynamicField(String string) {
            if (!this.__dynamicStructureFields.getFieldNames().contains(string)) {
                throw new BindingsException("The structure doesn't contain dynamic field with name " + string);
            }
            return this.__dynamicStructureFields.getField(string);
        }

        public Set<String> _getDynamicFieldNames() {
            return this.__dynamicStructureFields.getFieldNames();
        }

        public static StructType _getClassType() {
            return Ipv6Definitions.IPv6AddressReadOnly;
        }

        public String _getCanonicalName() {
            return this.__dynamicStructureFields.getName();
        }

        public static String _getCanonicalTypeName() {
            return IPv6AddressReadOnly._getClassType().getName();
        }

        public static IPv6AddressReadOnly _newInstance(StructValue structValue) {
            return new IPv6AddressReadOnly(structValue);
        }

        private static StructValue createEmptyStructValue() {
            return new StructValue(Ipv6Definitions.IPv6AddressReadOnly.getName());
        }

        public static final class Builder {
            private String address;
            private long prefix;
            private IPv6AddressOrigin origin;
            private IPv6AddressStatus status;

            public Builder(String string, long l, IPv6AddressOrigin iPv6AddressOrigin, IPv6AddressStatus iPv6AddressStatus) {
                this.address = string;
                this.prefix = l;
                this.origin = iPv6AddressOrigin;
                this.status = iPv6AddressStatus;
            }

            public IPv6AddressReadOnly build() {
                IPv6AddressReadOnly iPv6AddressReadOnly = new IPv6AddressReadOnly();
                iPv6AddressReadOnly.setAddress(this.address);
                iPv6AddressReadOnly.setPrefix(this.prefix);
                iPv6AddressReadOnly.setOrigin(this.origin);
                iPv6AddressReadOnly.setStatus(this.status);
                return iPv6AddressReadOnly;
            }
        }
    }

    public static final class IPv6AddressStatus
    extends ApiEnumeration<IPv6AddressStatus> {
        public static final IPv6AddressStatus tentative = new IPv6AddressStatus("tentative");
        public static final IPv6AddressStatus unknown = new IPv6AddressStatus("unknown");
        public static final IPv6AddressStatus inaccessible = new IPv6AddressStatus("inaccessible");
        public static final IPv6AddressStatus invalid = new IPv6AddressStatus("invalid");
        public static final IPv6AddressStatus duplicate = new IPv6AddressStatus("duplicate");
        public static final IPv6AddressStatus preferred = new IPv6AddressStatus("preferred");
        public static final IPv6AddressStatus deprecated = new IPv6AddressStatus("deprecated");
        public static final IPv6AddressStatus optimistic = new IPv6AddressStatus("optimistic");
        private static final long serialVersionUID = 1L;
        private static final IPv6AddressStatus[] $VALUES = new IPv6AddressStatus[]{tentative, unknown, inaccessible, invalid, duplicate, preferred, deprecated, optimistic};
        private static final Map<String, IPv6AddressStatus> $NAME_TO_VALUE_MAP = ApiEnumeration.buildNameMap((ApiEnumeration[])$VALUES);

        private IPv6AddressStatus() {
            super(Values._UNKNOWN.name());
        }

        private IPv6AddressStatus(String string) {
            super(string);
        }

        public static IPv6AddressStatus[] values() {
            return (IPv6AddressStatus[])$VALUES.clone();
        }

        public static IPv6AddressStatus valueOf(String string) {
            if (string == null) {
                throw new NullPointerException();
            }
            IPv6AddressStatus iPv6AddressStatus = $NAME_TO_VALUE_MAP.get(string);
            if (iPv6AddressStatus != null) {
                return iPv6AddressStatus;
            }
            return new IPv6AddressStatus(string);
        }

        public boolean isUnknown() {
            return this.getEnumValue() == Values._UNKNOWN;
        }

        public Values getEnumValue() {
            try {
                return Values.valueOf(this.name());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return Values._UNKNOWN;
            }
        }

        private Object readResolve() {
            return IPv6AddressStatus.valueOf(this.name());
        }

        public static enum Values {
            tentative,
            unknown,
            inaccessible,
            invalid,
            duplicate,
            preferred,
            deprecated,
            optimistic,
            _UNKNOWN;

        }
    }

    public static final class IPv6AddressOrigin
    extends ApiEnumeration<IPv6AddressOrigin> {
        public static final IPv6AddressOrigin dhcp = new IPv6AddressOrigin("dhcp");
        public static final IPv6AddressOrigin random = new IPv6AddressOrigin("random");
        public static final IPv6AddressOrigin manual = new IPv6AddressOrigin("manual");
        public static final IPv6AddressOrigin other = new IPv6AddressOrigin("other");
        public static final IPv6AddressOrigin linklayer = new IPv6AddressOrigin("linklayer");
        private static final long serialVersionUID = 1L;
        private static final IPv6AddressOrigin[] $VALUES = new IPv6AddressOrigin[]{dhcp, random, manual, other, linklayer};
        private static final Map<String, IPv6AddressOrigin> $NAME_TO_VALUE_MAP = ApiEnumeration.buildNameMap((ApiEnumeration[])$VALUES);

        private IPv6AddressOrigin() {
            super(Values._UNKNOWN.name());
        }

        private IPv6AddressOrigin(String string) {
            super(string);
        }

        public static IPv6AddressOrigin[] values() {
            return (IPv6AddressOrigin[])$VALUES.clone();
        }

        public static IPv6AddressOrigin valueOf(String string) {
            if (string == null) {
                throw new NullPointerException();
            }
            IPv6AddressOrigin iPv6AddressOrigin = $NAME_TO_VALUE_MAP.get(string);
            if (iPv6AddressOrigin != null) {
                return iPv6AddressOrigin;
            }
            return new IPv6AddressOrigin(string);
        }

        public boolean isUnknown() {
            return this.getEnumValue() == Values._UNKNOWN;
        }

        public Values getEnumValue() {
            try {
                return Values.valueOf(this.name());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return Values._UNKNOWN;
            }
        }

        private Object readResolve() {
            return IPv6AddressOrigin.valueOf(this.name());
        }

        public static enum Values {
            dhcp,
            random,
            manual,
            other,
            linklayer,
            _UNKNOWN;

        }
    }
}

