/*
 * Decompiled with CFR 0.152.
 */
package flash.swf.tools.as3;

import flash.swf.tools.as3.EvaluatorAdapter;
import java.io.PrintWriter;
import macromedia.asc.parser.ArgumentListNode;
import macromedia.asc.parser.AttributeListNode;
import macromedia.asc.parser.BinaryExpressionNode;
import macromedia.asc.parser.CallExpressionNode;
import macromedia.asc.parser.ClassDefinitionNode;
import macromedia.asc.parser.ForStatementNode;
import macromedia.asc.parser.FunctionCommonNode;
import macromedia.asc.parser.FunctionDefinitionNode;
import macromedia.asc.parser.GetExpressionNode;
import macromedia.asc.parser.IdentifierNode;
import macromedia.asc.parser.IfStatementNode;
import macromedia.asc.parser.InterfaceDefinitionNode;
import macromedia.asc.parser.ListNode;
import macromedia.asc.parser.LiteralArrayNode;
import macromedia.asc.parser.LiteralBooleanNode;
import macromedia.asc.parser.LiteralFieldNode;
import macromedia.asc.parser.LiteralNullNode;
import macromedia.asc.parser.LiteralNumberNode;
import macromedia.asc.parser.LiteralObjectNode;
import macromedia.asc.parser.LiteralRegExpNode;
import macromedia.asc.parser.LiteralStringNode;
import macromedia.asc.parser.LiteralVectorNode;
import macromedia.asc.parser.LiteralXMLNode;
import macromedia.asc.parser.MemberExpressionNode;
import macromedia.asc.parser.Node;
import macromedia.asc.parser.ProgramNode;
import macromedia.asc.parser.QualifiedIdentifierNode;
import macromedia.asc.parser.ReturnStatementNode;
import macromedia.asc.parser.ThisExpressionNode;
import macromedia.asc.parser.Tokens;
import macromedia.asc.parser.TypedIdentifierNode;
import macromedia.asc.parser.VariableDefinitionNode;
import macromedia.asc.parser.WhileStatementNode;
import macromedia.asc.parser.WithStatementNode;
import macromedia.asc.semantics.Value;
import macromedia.asc.util.Context;

public class PrettyPrinter
extends EvaluatorAdapter
implements Tokens {
    protected PrintWriter out;
    protected int indent;

    public PrettyPrinter(PrintWriter out) {
        this(out, 0);
    }

    public PrettyPrinter(PrintWriter out, int indent) {
        this.out = out;
        this.indent = indent;
    }

    public Value evaluate(Context cx, AttributeListNode node) {
        int size = node.items.size();
        for (int i = 0; i < size; ++i) {
            Node n = (Node)node.items.get(i);
            n.evaluate(cx, this);
            this.out.print(" ");
        }
        return null;
    }

    public Value evaluate(Context cx, ArgumentListNode node) {
        int size = node.items.size();
        for (int i = 0; i < size; ++i) {
            Node n = (Node)node.items.get(i);
            n.evaluate(cx, this);
            if (i + 1 >= size) continue;
            this.out.print(", ");
        }
        return null;
    }

    public Value evaluate(Context cx, BinaryExpressionNode node) {
        if (node.lhs != null) {
            node.lhs.evaluate(cx, this);
        }
        this.op(node.op);
        if (node.rhs != null) {
            node.rhs.evaluate(cx, this);
        }
        return null;
    }

    public Value evaluate(Context cx, CallExpressionNode node) {
        if (node.expr != null) {
            node.expr.evaluate(cx, this);
        }
        this.out.print("(");
        if (node.args != null) {
            node.args.evaluate(cx, this);
        }
        this.out.print(")");
        return null;
    }

    public Value evaluate(Context cx, ClassDefinitionNode node) {
        if (node.attrs != null) {
            node.attrs.evaluate(cx, this);
        }
        this.out.println("");
        this.out.print("class ");
        if (node.name != null && node.name.name != null) {
            node.name.evaluate(cx, this);
        } else if (node.cframe != null && node.cframe.builder != null) {
            this.out.print(node.cframe.builder.classname);
        } else assert (false) : "No class name found for ClassDefinitionNode";
        if (node.baseclass != null) {
            this.out.print(" extends ");
            node.baseclass.evaluate(cx, this);
        }
        this.out.println("");
        if (node.interfaces != null) {
            this.out.print("\timplements ");
            node.interfaces.evaluate(cx, this);
            this.out.println("");
        }
        this.out.println("{");
        ++this.indent;
        if (node.statements != null) {
            node.statements.evaluate(cx, this);
        }
        --this.indent;
        this.out.println("}");
        return null;
    }

    public Value evaluate(Context cx, ForStatementNode node) {
        this.indent();
        this.out.print("for (");
        if (node.initialize != null) {
            node.initialize.evaluate(cx, this);
        }
        this.out.print("; ");
        if (node.test != null) {
            node.test.evaluate(cx, this);
        }
        this.out.print("; ");
        if (node.increment != null) {
            node.increment.evaluate(cx, this);
        }
        this.out.println(")");
        this.indent();
        this.out.println("{");
        ++this.indent;
        if (node.statement != null) {
            node.statement.evaluate(cx, this);
        }
        --this.indent;
        this.indent();
        this.out.println("}");
        return null;
    }

    public Value evaluate(Context cx, FunctionCommonNode node) {
        this.out.print("(");
        if (node.signature != null) {
            node.signature.evaluate(cx, this);
        }
        this.out.println(")");
        this.indent();
        this.out.println("{");
        ++this.indent;
        if (node.body != null) {
            node.body.evaluate(cx, this);
        }
        --this.indent;
        this.indent();
        this.out.println("}");
        this.out.println("");
        return null;
    }

    public Value evaluate(Context cx, FunctionDefinitionNode node) {
        this.indent();
        if (node.attrs != null) {
            node.attrs.evaluate(cx, this);
        }
        this.out.print("function ");
        if (node.name != null) {
            node.name.evaluate(cx, this);
        }
        if (node.fexpr != null) {
            node.fexpr.evaluate(cx, this);
        }
        return null;
    }

    public Value evaluate(Context cx, GetExpressionNode node) {
        if (node.expr != null) {
            if (node.expr instanceof ArgumentListNode) {
                this.out.print("[");
                node.expr.evaluate(cx, this);
                this.out.print("]");
            } else {
                node.expr.evaluate(cx, this);
            }
        }
        return null;
    }

    public Value evaluate(Context cx, IdentifierNode node) {
        this.out.print(node.name);
        return null;
    }

    public Value evaluate(Context cx, IfStatementNode node) {
        this.indent();
        this.out.print("if (");
        if (node.condition != null) {
            node.condition.evaluate(cx, this);
        }
        this.out.println(")");
        this.indent();
        this.out.println("{");
        ++this.indent;
        if (node.thenactions != null) {
            node.thenactions.evaluate(cx, this);
        }
        --this.indent;
        this.indent();
        this.out.println("}");
        if (node.elseactions != null) {
            this.indent();
            this.out.println("else");
            this.indent();
            this.out.println("{");
            ++this.indent;
            node.elseactions.evaluate(cx, this);
            --this.indent;
            this.indent();
            this.out.println("}");
        }
        return null;
    }

    public Value evaluate(Context cx, InterfaceDefinitionNode node) {
        this.indent();
        this.out.print("interface ");
        if (node.name != null && node.name.name != null) {
            node.name.evaluate(cx, this);
        } else if (node.cframe != null && node.cframe.builder != null) {
            this.out.print(node.cframe.builder.classname);
        } else assert (false) : "No class name found for ClassDefinitionNode";
        if (node.baseclass != null) {
            this.out.print(" extends ");
            node.baseclass.evaluate(cx, this);
        }
        this.out.println("");
        this.indent();
        this.out.println("{");
        ++this.indent;
        if (node.statements != null) {
            node.statements.evaluate(cx, this);
        }
        --this.indent;
        this.indent();
        this.out.println("}");
        return null;
    }

    public Value evaluate(Context cx, ListNode node) {
        int size = node.items.size();
        for (int i = 0; i < size; ++i) {
            Node n = (Node)node.items.get(i);
            n.evaluate(cx, this);
            if (i + 1 >= size) continue;
            this.out.print(", ");
        }
        return null;
    }

    public Value evaluate(Context cx, LiteralArrayNode node) {
        this.out.print("[");
        super.evaluate(cx, node);
        this.out.print("]");
        return null;
    }

    public Value evaluate(Context cx, LiteralVectorNode node) {
        this.out.print("new<");
        this.evaluate(cx, node.type);
        this.out.print(">");
        this.out.print("[");
        super.evaluate(cx, node.elementlist);
        this.out.print("]");
        return null;
    }

    public Value evaluate(Context cx, LiteralBooleanNode node) {
        this.out.print(node.value);
        return null;
    }

    public Value evaluate(Context cx, LiteralFieldNode node) {
        if (node.name != null) {
            node.name.evaluate(cx, this);
        }
        this.out.print(": ");
        if (node.value != null) {
            node.value.evaluate(cx, this);
        }
        return null;
    }

    public Value evaluate(Context cx, LiteralNumberNode node) {
        this.out.print(node.value);
        return null;
    }

    public Value evaluate(Context cx, LiteralObjectNode node) {
        this.out.print("{");
        super.evaluate(cx, node);
        this.out.print("}");
        return null;
    }

    public Value evaluate(Context cx, LiteralStringNode node) {
        this.out.print("\"" + node.value + "\"");
        return null;
    }

    public Value evaluate(Context cx, LiteralNullNode node) {
        this.out.print("null");
        return null;
    }

    public Value evaluate(Context cx, LiteralRegExpNode node) {
        this.out.print(node.value);
        return null;
    }

    public Value evaluate(Context cx, LiteralXMLNode node) {
        assert (false) : "Not implemented yet.";
        return null;
    }

    public Value evaluate(Context cx, MemberExpressionNode node) {
        if (node.base != null) {
            node.base.evaluate(cx, this);
            if (node.selector != null && node.selector instanceof GetExpressionNode && !(((GetExpressionNode)node.selector).expr instanceof ArgumentListNode)) {
                this.out.print(".");
            }
        }
        if (node.selector != null) {
            node.selector.evaluate(cx, this);
        }
        return null;
    }

    public Value evaluate(Context cx, ProgramNode node) {
        for (int i = 0; i < node.imports.size(); ++i) {
            this.out.println("import ");
            this.out.println(node.imports.get(i));
            this.out.println(";");
        }
        return super.evaluate(cx, node);
    }

    public Value evaluate(Context cx, QualifiedIdentifierNode node) {
        if (node.qualifier != null) {
            node.qualifier.evaluate(cx, this);
        }
        this.evaluate(cx, (IdentifierNode)node);
        return null;
    }

    public Value evaluate(Context cx, ReturnStatementNode node) {
        this.indent();
        this.out.print("return ");
        if (node.expr != null) {
            node.expr.evaluate(cx, this);
        }
        this.out.println(";");
        return null;
    }

    public Value evaluate(Context cx, ThisExpressionNode node) {
        this.out.print("this");
        return null;
    }

    public Value evaluate(Context cx, TypedIdentifierNode node) {
        if (node.identifier != null) {
            node.identifier.evaluate(cx, this);
        }
        if (node.type != null) {
            this.out.print(":");
            node.type.evaluate(cx, this);
        }
        return null;
    }

    public Value evaluate(Context cx, VariableDefinitionNode node) {
        this.indent();
        if (node.attrs != null) {
            node.attrs.evaluate(cx, this);
        }
        this.out.print("var ");
        if (node.list != null) {
            node.list.evaluate(cx, this);
        }
        this.out.println(";");
        return null;
    }

    public Value evaluate(Context cx, WhileStatementNode node) {
        this.indent();
        this.out.print("while (");
        if (node.expr != null) {
            node.expr.evaluate(cx, this);
        }
        this.out.println(")");
        this.indent();
        this.out.println("{");
        ++this.indent;
        if (node.statement != null) {
            node.statement.evaluate(cx, this);
        }
        --this.indent;
        this.indent();
        this.out.println("}");
        return null;
    }

    public Value evaluate(Context cx, WithStatementNode node) {
        this.indent();
        this.out.print("with (");
        if (node.expr != null) {
            node.expr.evaluate(cx, this);
        }
        this.out.println(")");
        this.indent();
        this.out.println("{");
        ++this.indent;
        if (node.statement != null) {
            node.statement.evaluate(cx, this);
        }
        --this.indent;
        this.indent();
        this.out.println("}");
        return null;
    }

    private void indent() {
        if (this.indent < 0) assert (false);
        for (int i = 0; i < this.indent; ++i) {
            this.out.print("    ");
        }
    }

    private void op(int op) {
        switch (op) {
            case -5: {
                this.out.print(" != ");
                break;
            }
            case -6: {
                this.out.print(" !== ");
                break;
            }
            case -45: {
                this.out.print(" < ");
                break;
            }
            case -48: {
                this.out.print(" <= ");
                break;
            }
            case -51: {
                this.out.print(" == ");
                break;
            }
            case -52: {
                this.out.print(" === ");
                break;
            }
            case -53: {
                this.out.print(" > ");
                break;
            }
            case -54: {
                this.out.print(" >= ");
                break;
            }
            case -16: {
                this.out.print(" *= ");
                break;
            }
            case -15: {
                this.out.print(" * ");
                break;
            }
            case -23: {
                this.out.print(" /= ");
                break;
            }
            case -22: {
                this.out.print(" / ");
                break;
            }
            case -8: {
                this.out.print(" %= ");
                break;
            }
            case -7: {
                this.out.print(" % ");
                break;
            }
            case -44: {
                this.out.print(" += ");
                break;
            }
            case -42: {
                this.out.print(" + ");
                break;
            }
            case -50: {
                this.out.print(" -= ");
                break;
            }
            case -2: {
                this.out.print(" - ");
                break;
            }
            case -47: {
                this.out.print(" <<= ");
                break;
            }
            case -46: {
                this.out.print(" << ");
                break;
            }
            case -56: {
                this.out.print(" >>= ");
                break;
            }
            case -55: {
                this.out.print(" >> ");
                break;
            }
            case -58: {
                this.out.print(" >>>= ");
                break;
            }
            case -57: {
                this.out.print(" >>> ");
                break;
            }
            case -12: {
                this.out.print(" &= ");
                break;
            }
            case -9: {
                this.out.print(" & ");
                break;
            }
            case -34: {
                this.out.print(" |= ");
                break;
            }
            case -31: {
                this.out.print(" ^ ");
                break;
            }
            case -39: {
                this.out.print(" ^= ");
                break;
            }
            case -36: {
                this.out.print(" | ");
                break;
            }
            case -11: {
                this.out.print(" &&= ");
                break;
            }
            case -10: {
                this.out.print(" && ");
                break;
            }
            case -33: {
                this.out.print(" ^^= ");
                break;
            }
            case -32: {
                this.out.print(" ^^ ");
                break;
            }
            case -38: {
                this.out.print(" ||= ");
                break;
            }
            case -37: {
                this.out.print(" || ");
                break;
            }
            default: {
                assert (false) : "Unhandled operation, " + op + ".";
                break;
            }
        }
    }
}

