/*
 * Decompiled with CFR 0.152.
 */
package flex2.compiler;

import flex2.compiler.CompilerContext;
import flex2.compiler.Source;
import flex2.compiler.abc.AbcClass;
import flex2.compiler.abc.MetaData;
import flex2.compiler.abc.Method;
import flex2.compiler.abc.Variable;
import flex2.compiler.as3.BytecodeEmitter;
import flex2.compiler.as3.binding.TypeAnalyzer;
import flex2.compiler.common.CompilerConfiguration;
import flex2.compiler.common.Configuration;
import flex2.compiler.css.StyleConflictException;
import flex2.compiler.css.Styles;
import flex2.compiler.util.MultiName;
import flex2.compiler.util.NameFormatter;
import flex2.compiler.util.QName;
import flex2.compiler.util.QNameList;
import flex2.compiler.util.QNameMap;
import flex2.compiler.util.ThreadLocalToolkit;
import flex2.tools.oem.ProgressMeter;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import macromedia.asc.util.Context;
import macromedia.asc.util.ContextStatics;
import macromedia.asc.util.Namespaces;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SymbolTable {
    public static final String internalNamespace = "internal";
    public static final String privateNamespace = "private";
    public static final String protectedNamespace = "protected";
    public static final String publicNamespace = "";
    public static final String unnamedPackage = "";
    public static final String[] VISIBILITY_NAMESPACES = new String[]{"", "protected", "internal", "private"};
    public static final String NOTYPE = "*";
    public static final String STRING = "String";
    public static final String BOOLEAN = "Boolean";
    public static final String NUMBER = "Number";
    public static final String INT = "int";
    public static final String UINT = "uint";
    public static final String NAMESPACE = "Namespace";
    public static final String FUNCTION = "Function";
    public static final String CLASS = "Class";
    public static final String ARRAY = "Array";
    public static final String OBJECT = "Object";
    public static final String XML = "XML";
    public static final String XML_LIST = "XMLList";
    public static final String REPARENT = "Reparent";
    public static final String REGEXP = "RegExp";
    public static final String EVENT = "flash.events:Event";
    public static final String VECTOR = "__AS3__.vec:Vector";
    private static final NoType NoTypeClass = new NoType();
    private final Map<String, AbcClass> classTable = new HashMap<String, AbcClass>(300);
    private final Styles styles = new Styles();
    public final ContextStatics perCompileData;
    private final QNameMap<Source> qNameTable;
    private final Map<MultiName, QName> multiNames;
    public final BytecodeEmitter emitter;
    private CompilerContext context;
    private boolean suppressWarnings;
    private boolean debug;
    private final Map<String, QName[]> rbNames;
    private final Map<String, Source> rbNameTable;
    public int tick = 0;
    public int currentPercentage = 0;
    private TypeAnalyzer typeAnalyzer;

    public SymbolTable(Configuration configuration, ContextStatics contextStatics) {
        this.perCompileData = contextStatics;
        CompilerConfiguration compilerConfiguration = configuration.getCompilerConfiguration();
        this.perCompileData.use_static_semantics = compilerConfiguration.strict();
        this.perCompileData.dialect = compilerConfiguration.dialect();
        this.perCompileData.languageID = Context.getLanguageID(Locale.getDefault().getCountry().toUpperCase());
        this.perCompileData.setAbcVersion(configuration.getTargetPlayerTargetAVM());
        boolean bl = ContextStatics.omitTrace = !compilerConfiguration.debug() && compilerConfiguration.omitTraceStatements();
        assert (configuration.getTargetPlayerRequiredUseNamespaces() != null);
        this.perCompileData.use_namespaces.addAll(configuration.getTargetPlayerRequiredUseNamespaces());
        ContextStatics.useVerboseErrors = false;
        this.qNameTable = new QNameMap(300);
        this.multiNames = new HashMap<MultiName, QName>(1024);
        Context cx = new Context(this.perCompileData);
        this.emitter = new BytecodeEmitter(cx, null, false, false);
        cx.setEmitter(this.emitter);
        this.typeAnalyzer = new TypeAnalyzer(this);
        this.rbNames = new HashMap<String, QName[]>();
        this.rbNameTable = new HashMap<String, Source>();
    }

    public SymbolTable(Configuration configuration) {
        this(configuration, new ContextStatics());
    }

    public void adjustProgress() {
        ProgressMeter meter = ThreadLocalToolkit.getProgressMeter();
        for (int i = this.currentPercentage + 1; meter != null && i <= 100; ++i) {
            meter.percentDone(i);
        }
    }

    public void registerClass(String className, AbcClass cls) {
        assert (className.indexOf(47) == -1);
        this.classTable.put(className, cls);
    }

    public AbcClass getClass(String className) {
        assert (className == null || className.indexOf(47) == -1 && NameFormatter.toColon(className).equals(className)) : className;
        AbcClass result = null;
        if (className != null) {
            result = className.equals(NOTYPE) ? NoTypeClass : this.classTable.get(className);
        }
        return result;
    }

    public Set<String> getClassNames() {
        return this.classTable.keySet();
    }

    public void registerStyles(Styles newStyles) throws StyleConflictException {
        this.styles.addStyles(newStyles);
    }

    public MetaData getStyle(String styleName) {
        if (styleName != null) {
            return this.styles.getStyle(styleName);
        }
        return null;
    }

    public Styles getStyles() {
        return this.styles;
    }

    void registerQNames(QNameList qNames, Source source) {
        int size = qNames.size();
        for (int i = 0; i < size; ++i) {
            QName qN = (QName)qNames.get(i);
            this.qNameTable.put(qN, source);
        }
    }

    public void registerQName(QName qName, Source source) {
        Source old = (Source)this.qNameTable.get(qName);
        if (old == null) {
            this.qNameTable.put(new QName(qName), source);
        } else if (!old.getName().equals(source.getName())) assert (false) : qName + " defined in " + old + " and " + source.getName();
    }

    public void registerResourceBundle(String rbName, Source source) {
        this.rbNameTable.put(rbName, source);
    }

    public Source findSourceByQName(QName qName) {
        return (Source)this.qNameTable.get(qName);
    }

    public Source findSourceByQName(String namespaceURI, String localPart) {
        return this.qNameTable.get(namespaceURI, localPart);
    }

    public Source findSourceByResourceBundleName(String rbName) {
        return this.rbNameTable.get(rbName);
    }

    void registerMultiName(MultiName multiName, QName qName) {
        this.multiNames.put(multiName, qName);
    }

    void registerResourceBundleName(String rbName, QName[] qNames) {
        this.rbNames.put(rbName, qNames);
    }

    public QName isMultiNameResolved(MultiName multiName) {
        return this.multiNames.get(multiName);
    }

    public QName[] isResourceBundleResolved(String rbName) {
        return this.rbNames.get(rbName);
    }

    public CompilerContext getContext() {
        if (this.context == null) {
            this.context = new CompilerContext();
        }
        return this.context;
    }

    public void cleanClassTable() {
        Iterator<String> i = this.classTable.keySet().iterator();
        while (i.hasNext()) {
            AbcClass c = this.classTable.get(i.next());
            c.setTypeTable(null);
        }
    }

    public TypeAnalyzer getTypeAnalyzer() {
        return this.typeAnalyzer;
    }

    public boolean getSuppressWarningsIncremental() {
        return this.suppressWarnings;
    }

    public void register(String rbName, QName[] qNames, Source source) {
        if (source != null) {
            int length;
            this.registerResourceBundleName(rbName, qNames);
            this.registerResourceBundle(rbName, source);
            int n = length = qNames == null ? 0 : qNames.length;
            for (int i = 0; i < length; ++i) {
                this.registerQName(qNames[i], source);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class NoType
    implements AbcClass {
        NoType() {
        }

        @Override
        public Variable getVariable(String[] namespaces, String name, boolean inherited) {
            return null;
        }

        @Override
        public Variable getVariable(Namespaces namespaces, String name, boolean inherited) {
            return null;
        }

        @Override
        public Method getMethod(String[] namespaces, String name, boolean inherited) {
            return null;
        }

        @Override
        public Method getMethod(Namespaces namespaces, String name, boolean inherited) {
            return null;
        }

        @Override
        public Method getGetter(String[] namespaces, String name, boolean inherited) {
            return null;
        }

        @Override
        public Method getGetter(Namespaces namespaces, String name, boolean inherited) {
            return null;
        }

        @Override
        public Method getSetter(String[] namespaces, String name, boolean inherited) {
            return null;
        }

        @Override
        public Method getSetter(Namespaces namespaces, String name, boolean inherited) {
            return null;
        }

        @Override
        public String getName() {
            return SymbolTable.NOTYPE;
        }

        public String getElementTypeName() {
            return null;
        }

        @Override
        public String getSuperTypeName() {
            return null;
        }

        @Override
        public String[] getInterfaceNames() {
            return null;
        }

        public List<MetaData> getMetaData(boolean inherited) {
            return null;
        }

        @Override
        public List<MetaData> getMetaData(String name, boolean inherited) {
            return null;
        }

        @Override
        public boolean implementsInterface(String interfaceName) {
            return false;
        }

        @Override
        public boolean isSubclassOf(String baseName) {
            return false;
        }

        @Override
        public boolean isInterface() {
            assert (false);
            return false;
        }

        @Override
        public boolean isDynamic() {
            return true;
        }

        @Override
        public boolean isPublic() {
            return true;
        }

        @Override
        public void setTypeTable(Object typeTable) {
        }

        @Override
        public Iterator<Variable> getVarIterator() {
            return new EmptyIter<Variable>();
        }

        @Override
        public Iterator<Method> getMethodIterator() {
            return new EmptyIter<Method>();
        }

        @Override
        public Iterator<Method> getGetterIterator() {
            return new EmptyIter<Method>();
        }

        @Override
        public Iterator<Method> getSetterIterator() {
            return new EmptyIter<Method>();
        }

        @Override
        public void freeze() {
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class EmptyIter<T>
        implements Iterator<T> {
            EmptyIter() {
            }

            @Override
            public boolean hasNext() {
                return false;
            }

            @Override
            public T next() {
                throw new NoSuchElementException();
            }

            @Override
            public void remove() {
            }
        }
    }
}

