/*
 * Decompiled with CFR 0.152.
 */
package flex2.compiler.mxml.builder;

import flex2.compiler.CompilationUnit;
import flex2.compiler.mxml.MxmlConfiguration;
import flex2.compiler.mxml.builder.AbstractBuilder;
import flex2.compiler.mxml.builder.XMLBuilder;
import flex2.compiler.mxml.dom.CDATANode;
import flex2.compiler.mxml.dom.Node;
import flex2.compiler.mxml.dom.XMLListNode;
import flex2.compiler.mxml.lang.TextParser;
import flex2.compiler.mxml.reflect.TypeTable;
import flex2.compiler.mxml.rep.AtResource;
import flex2.compiler.mxml.rep.BindingExpression;
import flex2.compiler.mxml.rep.Model;
import flex2.compiler.mxml.rep.MxmlDocument;
import flex2.compiler.mxml.rep.XMLList;
import flex2.compiler.util.CompilerMessage;
import flex2.compiler.util.PrefixMapping;
import flex2.compiler.util.QName;
import flex2.compiler.util.QNameMap;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Stack;
import macromedia.asc.util.IntegerPool;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMLListBuilder
extends AbstractBuilder {
    private String id;
    private Model parent;
    private boolean allowTopLevelBinding;
    XMLList xmlList;

    XMLListBuilder(CompilationUnit unit, TypeTable typeTable, MxmlConfiguration mxmlConfiguration, MxmlDocument document) {
        this(unit, typeTable, mxmlConfiguration, document, null);
        this.allowTopLevelBinding = true;
    }

    XMLListBuilder(CompilationUnit unit, TypeTable typeTable, MxmlConfiguration mxmlConfiguration, MxmlDocument document, Model parent) {
        super(unit, typeTable, mxmlConfiguration, document);
        this.parent = parent;
        this.allowTopLevelBinding = false;
    }

    @Override
    public void analyze(XMLListNode node) {
        this.id = (String)this.getLanguageAttributeValue(node, "id");
        this.xmlList = new XMLList(this.document, this.typeTable.xmlListType, this.parent, node.beginLine);
        if (this.id != null) {
            this.xmlList.setId(this.id, false);
        }
        StringWriter writer = new StringWriter();
        if (node.getChildCount() == 1 && node.getChildAt(0) instanceof CDATANode) {
            CDATANode cdata = (CDATANode)node.getChildAt(0);
            if (cdata.image.length() > 0) {
                BindingExpression be = this.textParser.parseBindingExpression(cdata.image, cdata.beginLine);
                if (be != null) {
                    if (this.allowTopLevelBinding) {
                        be.setDestination(this.xmlList);
                        writer.write("null");
                    } else {
                        this.log(cdata, (CompilerMessage)new AbstractBuilder.BindingNotAllowed());
                    }
                } else {
                    this.log(node, (CompilerMessage)new RequireXMLContent());
                }
            }
        } else {
            this.processChildren(node, writer, null, new Stack<String>(), new Stack<PrefixMapping>());
        }
        this.xmlList.setLiteralXML(writer.toString());
    }

    private void processNode(Node node, StringWriter serializer, String e4xElementsByLocalName, Stack<String> destinationPropertyStack, Stack<PrefixMapping> namespaces) {
        QNameMap<BindingExpression> attributeBindings = this.processBindingAttributes(node);
        this.processResourceAttributes(node);
        if (attributeBindings != null) {
            String destinationProperty = this.createExpression(destinationPropertyStack);
            for (QName attrName : attributeBindings.keySet()) {
                int nsId = 0;
                String nsUri = attrName.getNamespace();
                if (nsUri.length() > 0) {
                    nsId = PrefixMapping.getNamespaceId(nsUri, namespaces);
                } else {
                    PrefixMapping pm = namespaces.peek();
                    nsUri = pm.getUri();
                    nsId = pm.getNs();
                }
                String attrExpr = nsId > 0 ? e4xElementsByLocalName + ".@ns" + nsId + "::" + attrName.getLocalPart() : e4xElementsByLocalName + ".@" + attrName.getLocalPart();
                BindingExpression be = (BindingExpression)attributeBindings.get(attrName);
                be.setDestinationLValue(attrExpr);
                be.setDestinationProperty(destinationProperty + "[" + node.getIndex() + "]");
                be.setDestination(this.xmlList);
                be.setDestinationXMLAttribute(true);
                be.setDestinationE4X(true);
                this.xmlList.setHasBindings(true);
                PrefixMapping.pushNamespaces(be, namespaces);
                if (nsUri.length() <= 0) continue;
                be.addNamespace(nsUri, nsId);
            }
        }
        node.toStartElement(serializer);
        if (node.getChildCount() == 1 && node.getChildAt(0) instanceof CDATANode) {
            CDATANode cdata = (CDATANode)node.getChildAt(0);
            if (cdata.image.length() > 0) {
                BindingExpression be = this.textParser.parseBindingExpression(cdata.image, cdata.beginLine);
                if (be != null) {
                    String destinationProperty = this.createExpression(destinationPropertyStack);
                    be.setDestinationLValue(e4xElementsByLocalName);
                    be.setDestinationProperty(destinationProperty + "[" + node.getIndex() + "]");
                    be.setDestination(this.xmlList);
                    be.setDestinationXMLNode(true);
                    be.setDestinationE4X(true);
                    this.xmlList.setHasBindings(true);
                    PrefixMapping.pushNamespaces(be, namespaces);
                } else {
                    String text = TextParser.cleanupBindingEscapes(cdata.image);
                    text = TextParser.cleanupAtFunctionEscapes(text);
                    serializer.write(text);
                }
            }
        } else {
            this.processChildren(node, serializer, e4xElementsByLocalName, destinationPropertyStack, namespaces);
        }
        node.toEndElement(serializer);
    }

    private void processChildren(Node node, StringWriter serializer, String e4xElementsByLocalName, Stack<String> destinationPropertyStack, Stack<PrefixMapping> namespaces) {
        this.assignIndices(node);
        int count = node.getChildCount();
        for (int i = 0; i < count; ++i) {
            StringBuilder e4xbuffer;
            Node child = (Node)node.getChildAt(i);
            if (child instanceof CDATANode) {
                CDATANode cdata = (CDATANode)child;
                if (cdata.image.trim().length() > 0) {
                    this.log(child, (CompilerMessage)new XMLBuilder.MixedContent(child.image));
                    continue;
                }
                serializer.write(cdata.image);
                continue;
            }
            PrefixMapping.pushNodeNamespace(child, namespaces);
            if (e4xElementsByLocalName != null) {
                e4xbuffer = new StringBuilder(e4xElementsByLocalName);
                String destProp = child.getLocalPart();
                if (child.getNamespace().length() > 0) {
                    PrefixMapping pm = namespaces.peek();
                    destProp = "ns" + pm.getNs() + "::" + destProp;
                }
                e4xbuffer.append(".").append(destProp).append("[").append(child.getIndex()).append("]");
                destinationPropertyStack.push(destProp);
                this.processNode(child, serializer, e4xbuffer.toString(), destinationPropertyStack, namespaces);
                destinationPropertyStack.pop();
            } else {
                e4xbuffer = new StringBuilder(this.xmlList.getId());
                e4xbuffer.append("[").append(i).append("]");
                destinationPropertyStack.push(child.getLocalPart());
                this.processNode(child, serializer, e4xbuffer.toString(), destinationPropertyStack, namespaces);
                destinationPropertyStack.pop();
            }
            PrefixMapping.popNodeNamespace(namespaces);
        }
    }

    private QNameMap<BindingExpression> processBindingAttributes(Node node) {
        QNameMap<BindingExpression> attributeBindings = null;
        Iterator<QName> i = node.getAttributeNames();
        while (i != null && i.hasNext()) {
            QName qname = i.next();
            String value = (String)node.getAttributeValue(qname);
            BindingExpression be = this.textParser.parseBindingExpression(value, node.beginLine);
            if (be == null) continue;
            if (attributeBindings == null) {
                attributeBindings = new QNameMap<BindingExpression>();
            }
            attributeBindings.put(qname, be);
            i.remove();
        }
        return attributeBindings;
    }

    private void processResourceAttributes(Node node) {
        QNameMap<AtResource> attributeResources = new QNameMap<AtResource>();
        Iterator<QName> i = node.getAttributeNames();
        while (i != null && i.hasNext()) {
            QName qname = i.next();
            String text = (String)node.getAttributeValue(qname);
            String atFunction = TextParser.getAtFunctionName(text);
            if ("Resource".equals(atFunction)) {
                AtResource atResource = (AtResource)this.textParser.resource(text, this.typeTable.stringType);
                if (atResource == null) continue;
                attributeResources.put(qname, atResource);
                continue;
            }
            if (atFunction == null) continue;
            this.textParser.desc = atFunction;
            this.textParser.line = node.beginLine;
            this.textParser.error(7, null, null, null);
        }
        for (QName qname : attributeResources.keySet()) {
            AtResource atResource = (AtResource)attributeResources.get(qname);
            node.addAttribute(qname.getNamespace(), qname.getLocalPart(), atResource, node.beginLine);
        }
    }

    private void assignIndices(Node parent) {
        HashMap<String, Integer> counts = new HashMap<String, Integer>();
        Integer zero = IntegerPool.getNumber(0);
        int count = parent.getChildCount();
        for (int i = 0; i < count; ++i) {
            Node child = (Node)parent.getChildAt(i);
            if (child instanceof CDATANode) continue;
            if (!counts.containsKey(child.image)) {
                counts.put(child.image, zero);
                child.setIndex(0);
                continue;
            }
            int num = (Integer)counts.get(child.image) + 1;
            counts.put(child.image, IntegerPool.getNumber(num));
            child.setIndex(num);
        }
    }

    private String createExpression(Stack<String> stack) {
        StringBuilder buffer = new StringBuilder();
        int count = stack.size();
        for (int i = 0; i < count; ++i) {
            buffer.append((String)stack.get(i));
            if (i >= count - 1) continue;
            buffer.append(".");
        }
        return buffer.toString();
    }

    public static class RequireXMLContent
    extends CompilerMessage.CompilerError {
        private static final long serialVersionUID = 6892112465291416940L;
    }
}

