/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.cm.util;

import com.vmware.vim.binding.cis.cm.SearchCriteria;
import com.vmware.vim.binding.cis.cm.ServiceEndPoint;
import com.vmware.vim.binding.cis.cm.ServiceEndPointType;
import com.vmware.vim.binding.cis.cm.ServiceInfo;
import com.vmware.vim.binding.cis.cm.ServiceType;
import com.vmware.vim.binding.cis.cm.fault.ComponentManagerFault;
import com.vmware.vim.binding.impl.cis.cm.SearchCriteriaImpl;
import com.vmware.vim.binding.impl.cis.cm.ServiceEndPointTypeImpl;
import com.vmware.vim.binding.impl.cis.cm.ServiceTypeImpl;
import com.vmware.vise.security.UserSessionListener;
import com.vmware.vise.util.StringUtil;
import com.vmware.vise.util.feature.FeatureStateService;
import com.vmware.vise.util.feature.names.Feature;
import com.vmware.vise.util.session.SessionUtil;
import com.vmware.vise.vim.cloudvm.CloudVmService;
import com.vmware.vise.vim.cloudvm.CloudVmServiceManager;
import com.vmware.vise.vim.cm.UserSpecificCmFactory;
import com.vmware.vise.vim.security.sso.SsoServiceManager;
import com.vmware.vise.vim.vapi.VapiConnectionManager;
import com.vmware.vise.vim.vapi.VapiConnectionManagerRegistry;
import com.vmware.vsphere.client.cm.applmgmt.VapiBackedCloudVmService;
import com.vmware.vsphere.client.cm.util.CmUtil;
import com.vmware.vsphere.client.cm.util.InternalServerInfo;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.Collection;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionEvent;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.Validate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ApplmgmtServiceRegistry
implements UserSessionListener {
    private static final String APPLMGMT_SERVICE_URL_FORMAT = "https://%s/applmgmt/RPC2";
    private static final String APPLMGMT_ENDPOINT_URL_CACHE_KEY = "applmgmtEndpointUrlCache";
    private static final String APPLMGMT_CM_PRODUCT_ID = "com.vmware.applmgmt";
    private static final String APPLMGMT_CM_TYPE_ID = "applmgmt";
    private static final String APPLMGMT_CM_ENDPOINT_TYPE_ID = "com.vmware.applmgmt";
    private static final Log _logger = LogFactory.getLog(ApplmgmtServiceRegistry.class);
    private final UserSpecificCmFactory _cmFactory;
    private final SsoServiceManager _ssoServiceManager;
    private final VapiConnectionManagerRegistry<String> _applmgmtVapiConnectionRegistry;
    private final CloudVmServiceManager _cvsManager;
    private final FeatureStateService _featureStateService;

    public ApplmgmtServiceRegistry(UserSpecificCmFactory userSpecificCmFactory, SsoServiceManager ssoServiceManager, VapiConnectionManagerRegistry<String> vapiConnectionManagerRegistry, CloudVmServiceManager cloudVmServiceManager, FeatureStateService featureStateService) {
        this._cmFactory = userSpecificCmFactory;
        this._ssoServiceManager = ssoServiceManager;
        this._applmgmtVapiConnectionRegistry = vapiConnectionManagerRegistry;
        this._cvsManager = cloudVmServiceManager;
        this._featureStateService = featureStateService;
    }

    public void sessionStarted(HttpSessionEvent httpSessionEvent, Locale locale) throws Exception {
    }

    public void sessionEnded(HttpSessionEvent httpSessionEvent) throws Exception {
        Map map = (Map)SessionUtil.removeData((String)APPLMGMT_ENDPOINT_URL_CACHE_KEY, (HttpSession)httpSessionEvent.getSession());
        if (!MapUtils.isEmpty((Map)map)) {
            map.clear();
        }
    }

    public CloudVmService getCloudVmService(String string) {
        URL uRL;
        Validate.notNull((Object)string, (String)"Attempting to get applmgmt for a null server");
        if (this._featureStateService.isEnabled(Feature.ApplianceMonitoring) && (uRL = this._applmgmtVapiConnectionRegistry.getConnectionManager((Object)string)) != null) {
            return new VapiBackedCloudVmService((VapiConnectionManager)uRL);
        }
        uRL = this.getRelatedApplmgmtServiceUrl(string);
        if (uRL == null) {
            return null;
        }
        CloudVmService cloudVmService = this._cvsManager.getService(uRL);
        return cloudVmService;
    }

    private URL getRelatedApplmgmtServiceUrl(String string) {
        assert (!StringUtil.isNullOrEmpty((String)string));
        Map map = (Map)SessionUtil.getData((String)APPLMGMT_ENDPOINT_URL_CACHE_KEY);
        String string2 = string.toLowerCase();
        if (!MapUtils.isEmpty((Map)map) && map.containsKey(string2)) {
            return (URL)map.get(string2);
        }
        return this.getRelatedApplmgmtServiceUrlSynchronized(string2);
    }

    private synchronized URL getRelatedApplmgmtServiceUrlSynchronized(String string) {
        Map<String, URL> map = (Map<String, URL>)SessionUtil.getData((String)APPLMGMT_ENDPOINT_URL_CACHE_KEY);
        if (MapUtils.isEmpty((Map)map)) {
            map = this.retrieveApplmgmtEndpointUrls();
            SessionUtil.setData((String)APPLMGMT_ENDPOINT_URL_CACHE_KEY, map);
        }
        return map.get(string);
    }

    private Map<String, URL> retrieveApplmgmtEndpointUrls() {
        InternalServerInfo internalServerInfo2;
        HashMap<String, URL> hashMap = new HashMap<String, URL>();
        Collection<InternalServerInfo> collection = CmUtil.getServers(this._ssoServiceManager);
        for (InternalServerInfo internalServerInfo2 : collection) {
            hashMap.put(internalServerInfo2.getHostname().toLowerCase(), null);
        }
        SearchCriteriaImpl searchCriteriaImpl = new SearchCriteriaImpl();
        internalServerInfo2 = new ServiceTypeImpl();
        internalServerInfo2.setProductId("com.vmware.applmgmt");
        internalServerInfo2.setTypeId(APPLMGMT_CM_TYPE_ID);
        ServiceEndPointTypeImpl serviceEndPointTypeImpl = new ServiceEndPointTypeImpl();
        serviceEndPointTypeImpl.setEndPointProtocol("http");
        serviceEndPointTypeImpl.setTypeId("com.vmware.applmgmt");
        searchCriteriaImpl.setServiceType((ServiceType)internalServerInfo2);
        searchCriteriaImpl.setEndPointType((ServiceEndPointType)serviceEndPointTypeImpl);
        try {
            ServiceInfo[] serviceInfoArray = this._cmFactory.getComponentManagerService().search((SearchCriteria)searchCriteriaImpl);
            if (serviceInfoArray != null) {
                for (ServiceInfo serviceInfo : serviceInfoArray) {
                    ServiceEndPoint serviceEndPoint = serviceInfo.getServiceEndPoints()[0];
                    URI uRI = serviceEndPoint.getUrl();
                    String string = uRI.getHost().toLowerCase().replaceAll("[\\]\\[]", "");
                    try {
                        hashMap.put(string, uRI.toURL());
                    }
                    catch (MalformedURLException malformedURLException) {
                        _logger.error((Object)("Invalid applmgmgt endpoint URI retrieved for host" + string), (Throwable)malformedURLException);
                        hashMap.put(string, this.buildApplmgmtUrl(string));
                    }
                }
            }
        }
        catch (ComponentManagerFault componentManagerFault) {
            _logger.error((Object)"Failed to retrieve applmgmt instanceds from CM", (Throwable)componentManagerFault);
        }
        return hashMap;
    }

    private URL buildApplmgmtUrl(String string) {
        try {
            return new URL(String.format(APPLMGMT_SERVICE_URL_FORMAT, string));
        }
        catch (MalformedURLException malformedURLException) {
            _logger.error((Object)("Failed to build URL for server " + string), (Throwable)malformedURLException);
            return null;
        }
    }
}

