/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.cm.util;

import com.vmware.vim.sso.client.util.codec.Base64;
import com.vmware.vise.data.query.ObjectReferenceService;
import com.vmware.vise.data.uri.DefaultUriSchemeUtil;
import com.vmware.vsphere.client.cm.util.InternalServerInfo;
import com.vmware.vsphere.client.cm.util.InternalServiceInfo;
import java.net.URI;

public final class CmReferenceUtil {
    public static final String SERVER_TYPE = "cm:Server";
    public static final String SERVICE_TYPE = "cm:Service";
    private static final int ID_SEGMENT = 0;
    private static final int SERVER_ID_SEGMENT = 1;
    private static final String SERVER_PLACEHOLDER_ID = "__node";

    public static String getId(URI uRI) {
        assert (uRI != null);
        String[] stringArray = DefaultUriSchemeUtil.getIdSegments((URI)uRI);
        return stringArray[0];
    }

    public static String getServerId(URI uRI) {
        assert (uRI != null);
        String[] stringArray = DefaultUriSchemeUtil.getIdSegments((URI)uRI);
        if (stringArray.length <= 1) {
            return "";
        }
        return CmReferenceUtil.decodeString(stringArray[1]);
    }

    public static URI getServerReference(String string) {
        assert (string != null);
        String[] stringArray = new String[]{SERVER_PLACEHOLDER_ID, CmReferenceUtil.encodeString(string)};
        return DefaultUriSchemeUtil.createUri((String)SERVER_TYPE, (String[])stringArray);
    }

    public static URI getServerReference(InternalServerInfo internalServerInfo) {
        assert (internalServerInfo != null);
        return CmReferenceUtil.getServerReference(internalServerInfo.getHostname());
    }

    public static URI getServiceReference(String string, String string2) {
        assert (string != null);
        assert (string2 != null);
        String[] stringArray = new String[]{string, CmReferenceUtil.encodeString(string2)};
        return DefaultUriSchemeUtil.createUri((String)SERVICE_TYPE, (String[])stringArray);
    }

    public static URI getServiceReference(InternalServiceInfo internalServiceInfo) {
        assert (internalServiceInfo != null);
        return CmReferenceUtil.getServiceReference(internalServiceInfo.getServiceId(), internalServiceInfo.getServerHostname());
    }

    public static boolean isReferenceOfType(Object object, String string, ObjectReferenceService objectReferenceService) {
        assert (string != null);
        if (object == null || !(object instanceof URI)) {
            return false;
        }
        String string2 = objectReferenceService.getResourceObjectType(object);
        return string.equals(string2);
    }

    private static String decodeString(String string) {
        if (string == null || string.equals("null")) {
            return null;
        }
        byte[] byArray = Base64.decodeBase64((String)string);
        return new String(byArray);
    }

    private static String encodeString(String string) {
        if (string == null) {
            return "null";
        }
        String string2 = Base64.encodeBase64URLSafeString((byte[])string.getBytes());
        return string2;
    }
}

