/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.cm.util;

import com.vmware.vise.data.query.ObjectReferenceService;
import com.vmware.vise.util.feature.FeatureStateService;
import com.vmware.vise.util.feature.names.Feature;
import com.vmware.vise.vim.vapi.VapiConnectionManagerRegistry;
import com.vmware.vsphere.client.cm.util.CmReferenceUtil;
import java.net.URI;
import org.apache.commons.lang.Validate;

public class CmUiFeatureSwitch {
    private final VapiConnectionManagerRegistry<String> _vmonConnectionRegistry;
    private final FeatureStateService _featureStateService;
    private final ObjectReferenceService _objectReferenceService;

    public CmUiFeatureSwitch(VapiConnectionManagerRegistry<String> vapiConnectionManagerRegistry, FeatureStateService featureStateService, ObjectReferenceService objectReferenceService) {
        Validate.notNull((Object)objectReferenceService);
        Validate.notNull(vapiConnectionManagerRegistry);
        Validate.notNull((Object)featureStateService);
        this._vmonConnectionRegistry = vapiConnectionManagerRegistry;
        this._featureStateService = featureStateService;
        this._objectReferenceService = objectReferenceService;
    }

    public boolean useVmonForService(URI uRI) {
        assert (CmReferenceUtil.isReferenceOfType(uRI, "cm:Service", this._objectReferenceService));
        return this._featureStateService.isEnabled(Feature.VCHA) && this._vmonConnectionRegistry.getConnectionManager((Object)CmReferenceUtil.getServerId(uRI)) != null;
    }

    public boolean useVmonForHost(String string) {
        return this._featureStateService.isEnabled(Feature.VCHA) && this._vmonConnectionRegistry.getConnectionManager((Object)string) != null;
    }
}

