/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.cm.util;

import com.vmware.appliance.vmon.ServiceTypes;
import com.vmware.vim.binding.sca.ServiceInfo;
import com.vmware.vise.util.ObjectUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public final class InternalServiceInfo {
    private int _cachedHashCode = -1;
    private final ServiceInfo _scaServiceInfo;
    private final String _serverHostname;
    private final ServiceTypes.Info _vmonServiceInfo;
    private final String _vmonServiceId;

    public InternalServiceInfo(ServiceInfo serviceInfo, String string, ServiceTypes.Info info, String string2) {
        assert (serviceInfo != null ^ (info != null && string != null));
        assert (string2 != null);
        this._scaServiceInfo = serviceInfo;
        this._vmonServiceId = string;
        this._vmonServiceInfo = info;
        this._serverHostname = string2;
    }

    public ServiceInfo getScaServiceInfo() {
        return this._scaServiceInfo;
    }

    public ServiceTypes.Info getVmonServiceInfo() {
        return this._vmonServiceInfo;
    }

    public String getServiceId() {
        return this._vmonServiceId != null ? this._vmonServiceId : this._scaServiceInfo.serviceId;
    }

    public String getServerHostname() {
        return this._serverHostname;
    }

    public int hashCode() {
        if (this._cachedHashCode == -1) {
            int n = 17;
            n = 31 * n + ObjectUtil.getHashCode((Object)this.getServiceId());
            this._cachedHashCode = n = 31 * n + ObjectUtil.getHashCode((Object)this._serverHostname);
        }
        return this._cachedHashCode;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        InternalServiceInfo internalServiceInfo = (InternalServiceInfo)object;
        return ObjectUtil.objectsEqual((Object)this._serverHostname, (Object)internalServiceInfo._serverHostname) && ObjectUtil.objectsEqual((Object)this.getServiceId(), (Object)internalServiceInfo.getServiceId());
    }

    public static Map<String, Collection<String>> mapServiceIdsByServer(InternalServiceInfo[] internalServiceInfoArray) {
        HashMap<String, Collection<String>> hashMap = new HashMap<String, Collection<String>>();
        for (InternalServiceInfo internalServiceInfo : internalServiceInfoArray) {
            if (!hashMap.containsKey(internalServiceInfo.getServerHostname())) {
                hashMap.put(internalServiceInfo.getServerHostname(), new ArrayList());
            }
            ((Collection)hashMap.get(internalServiceInfo.getServerHostname())).add(internalServiceInfo.getServiceId());
        }
        return hashMap;
    }
}

