/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.cm.util;

import com.vmware.appliance.vmon.ServiceTypes;
import com.vmware.vim.binding.sca.ServiceInfo;
import com.vmware.vim.binding.sca.configuration.ServiceConfigurationManager;
import com.vmware.vim.binding.sca.control.ServiceControlManager;
import com.vmware.vim.binding.sca.control.ServiceState;
import com.vmware.vim.binding.sca.control.StartupInfo;
import com.vmware.vim.binding.sca.control.StartupType;
import com.vmware.vim.binding.sca.fault.ServiceManagerFault;
import com.vmware.vim.binding.vim.ServiceInstanceContent;
import com.vmware.vise.usersession.ServerInfo;
import com.vmware.vise.usersession.UserSessionService;
import com.vmware.vise.util.ArrayUtil;
import com.vmware.vise.util.StringUtil;
import com.vmware.vise.vim.commons.i18n.LocalizationUtil;
import com.vmware.vise.vim.commons.vcservice.ServerInfoEx;
import com.vmware.vise.vim.sca.ScaService;
import com.vmware.vise.vim.sca.ScaServiceManager;
import com.vmware.vise.vim.vapi.VapiConnectionManagerRegistry;
import com.vmware.vsphere.client.cm.HealthState;
import com.vmware.vsphere.client.cm.ServiceStartupType;
import com.vmware.vsphere.client.cm.ServiceStatus;
import com.vmware.vsphere.client.cm.util.CachingPropertyValueExtractor;
import com.vmware.vsphere.client.cm.util.CmReferenceUtil;
import com.vmware.vsphere.client.cm.util.CmUiFeatureSwitch;
import com.vmware.vsphere.client.cm.util.CmUtil;
import com.vmware.vsphere.client.cm.util.InternalServiceInfo;
import com.vmware.vsphere.client.cm.util.PropertyCache;
import com.vmware.vsphere.client.cm.util.ScmUtil;
import java.net.InetAddress;
import java.net.URI;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ServiceInfoPropertyValueExtractor
extends CachingPropertyValueExtractor<InternalServiceInfo> {
    private final UserSessionService _usService;
    private final Set<String> _propertiesNeedingRemoteCall;
    private final CmUiFeatureSwitch _killSwitch;
    private ScaServiceManager _scaServiceManager;
    private final VapiConnectionManagerRegistry<String> _vmonConnectionRegistry;
    private static final Log _logger = LogFactory.getLog(ServiceInfoPropertyValueExtractor.class);

    public ServiceInfoPropertyValueExtractor(UserSessionService userSessionService, PropertyCache<InternalServiceInfo> propertyCache, Set<String> set, Executor executor, CmUiFeatureSwitch cmUiFeatureSwitch, VapiConnectionManagerRegistry<String> vapiConnectionManagerRegistry) {
        super(propertyCache, set, executor);
        this._usService = userSessionService;
        this._killSwitch = cmUiFeatureSwitch;
        this._vmonConnectionRegistry = vapiConnectionManagerRegistry;
        this._propertiesNeedingRemoteCall = new HashSet<String>();
        this._propertiesNeedingRemoteCall.add("scaServiceState");
        this._propertiesNeedingRemoteCall.add("startupType");
        this._propertiesNeedingRemoteCall.add("configurationRegistered");
        this._propertiesNeedingRemoteCall.add("resources");
        this._propertiesNeedingRemoteCall.add("configurations");
        this._propertiesNeedingRemoteCall.add("definitions");
    }

    public void setScaServiceManager(ScaServiceManager scaServiceManager) {
        this._scaServiceManager = scaServiceManager;
    }

    public Object[][] getValues(InternalServiceInfo[] internalServiceInfoArray, String[] stringArray) {
        Object[][] objectArray = new Object[stringArray.length][internalServiceInfoArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            objectArray[i] = this.getValuesPerProperty(internalServiceInfoArray, stringArray[i]);
        }
        return objectArray;
    }

    @Override
    protected boolean propertyNeedsRemoteCall(String string) {
        return this._propertiesNeedingRemoteCall.contains(string);
    }

    @Override
    protected String getServerId(InternalServiceInfo internalServiceInfo) {
        return internalServiceInfo.getServerHostname();
    }

    protected Object[] getValuesPerPropertyDirectly(InternalServiceInfo[] internalServiceInfoArray, String string, boolean bl) {
        Object[] objectArray;
        block28: {
            assert (!this.propertyNeedsRemoteCall(string) || bl);
            objectArray = null;
            try {
                if ("health".equals(string)) {
                    objectArray = this.getServiceHealthStates(internalServiceInfoArray);
                    break block28;
                }
                if ("scaServiceState".equals(string)) {
                    objectArray = this.getServiceScaStates(internalServiceInfoArray);
                    break block28;
                }
                if ("server".equals(string)) {
                    objectArray = this.getServersForServices(internalServiceInfoArray);
                    break block28;
                }
                if ("serverName".equals(string)) {
                    objectArray = this.getServerHostnamesForServices(internalServiceInfoArray);
                    break block28;
                }
                if ("name".equals(string)) {
                    objectArray = this.getServiceNames(internalServiceInfoArray);
                    break block28;
                }
                if ("status".equals(string)) {
                    objectArray = this.getServiceStatuses(internalServiceInfoArray);
                    break block28;
                }
                if ("startupType".equals(string)) {
                    objectArray = this.getServiceStartupTypes(internalServiceInfoArray);
                    break block28;
                }
                if ("healthMessages".equals(string)) {
                    objectArray = this.getServiceHealthMessages(internalServiceInfoArray);
                    break block28;
                }
                objectArray = new Object[internalServiceInfoArray.length];
                for (int i = 0; i < internalServiceInfoArray.length; ++i) {
                    InternalServiceInfo internalServiceInfo = internalServiceInfoArray[i];
                    if ("shortName".equals(string)) {
                        objectArray[i] = this.getServiceShortName(internalServiceInfo);
                        continue;
                    }
                    if ("serviceType".equals(string)) {
                        objectArray[i] = this.getScaServiceType(internalServiceInfo);
                        continue;
                    }
                    if ("isStartable".equals(string)) {
                        objectArray[i] = this.isServiceControlActionAvailable(internalServiceInfo, ServiceInfo.ControlActions.START);
                        continue;
                    }
                    if ("isStoppable".equals(string)) {
                        objectArray[i] = this.isServiceControlActionAvailable(internalServiceInfo, ServiceInfo.ControlActions.STOP);
                        continue;
                    }
                    if ("isRestartable".equals(string)) {
                        objectArray[i] = this.isServiceControlActionAvailable(internalServiceInfo, ServiceInfo.ControlActions.RESTART);
                        continue;
                    }
                    if ("startupTypeEditable".equals(string)) {
                        objectArray[i] = this.isServiceStartupTypeEditable(internalServiceInfo);
                        continue;
                    }
                    if ("autoStartupTypeSupported".equals(string)) {
                        objectArray[i] = this.isServiceControlActionAvailable(internalServiceInfo, ServiceInfo.ControlActions.SET_STARTUPTYPE_AUTOMATIC);
                        continue;
                    }
                    if ("manualStartupTypeSupported".equals(string)) {
                        objectArray[i] = this.isServiceControlActionAvailable(internalServiceInfo, ServiceInfo.ControlActions.SET_STARTUPTYPE_MANUAL);
                        continue;
                    }
                    if ("disabledStartupTypeSupported".equals(string)) {
                        objectArray[i] = this.isServiceControlActionAvailable(internalServiceInfo, ServiceInfo.ControlActions.SET_STARTUPTYPE_DISABLED);
                        continue;
                    }
                    if ("configurationRegistered".equals(string)) {
                        objectArray[i] = ScmUtil.isResourceRegistered(this.getScmService(internalServiceInfo), internalServiceInfo);
                        continue;
                    }
                    if ("resources".equals(string)) {
                        objectArray[i] = ScmUtil.getResources(this.getScmService(internalServiceInfo), internalServiceInfo);
                        continue;
                    }
                    if ("configurations".equals(string)) {
                        objectArray[i] = ScmUtil.getConfigurations(this.getScmService(internalServiceInfo), internalServiceInfo);
                        continue;
                    }
                    if ("definitions".equals(string)) {
                        objectArray[i] = ScmUtil.getDefinitions(this.getScmService(internalServiceInfo), internalServiceInfo);
                        continue;
                    }
                    if (ScmUtil.isSettingsProperty(string)) {
                        objectArray[i] = ScmUtil.getSettings(this.getScmService(internalServiceInfo), internalServiceInfo, string);
                        continue;
                    }
                    if ("relatedVc".equals(string)) {
                        objectArray[i] = this.getRelatedVc(internalServiceInfo);
                        continue;
                    }
                    if ("description".equals(string)) {
                        objectArray[i] = this.getServiceDescription(internalServiceInfo);
                        continue;
                    }
                    _logger.warn((Object)("Unknown Service property: " + string));
                    break;
                }
            }
            catch (ServiceManagerFault serviceManagerFault) {
                _logger.error((Object)String.format("SCA Service manager threw an error with code %d and message %s", serviceManagerFault.getErrorCode(), serviceManagerFault.getErrorMessage()), (Throwable)serviceManagerFault);
            }
        }
        return objectArray;
    }

    @Override
    protected void sanitizeValues(String string, Object[] objectArray) {
        block5: {
            block6: {
                block4: {
                    assert (objectArray != null);
                    if (!"startupType".equals(string)) break block4;
                    for (int i = 0; i < objectArray.length; ++i) {
                        if (objectArray[i] != null) continue;
                        objectArray[i] = ServiceStartupType.UNKNOWN;
                    }
                    break block5;
                }
                if (!"status".equals(string)) break block6;
                for (int i = 0; i < objectArray.length; ++i) {
                    if (objectArray[i] != null) continue;
                    objectArray[i] = ServiceStatus.UNKNOWN;
                }
                break block5;
            }
            if (!"health".equals(string)) break block5;
            for (int i = 0; i < objectArray.length; ++i) {
                if (objectArray[i] != null) continue;
                objectArray[i] = HealthState.UNKNOWN;
            }
        }
    }

    private Object[] getServiceHealthMessages(InternalServiceInfo[] internalServiceInfoArray) {
        String[][] stringArrayArray = new String[internalServiceInfoArray.length][];
        HashMap hashMap = new HashMap();
        HashMap<InternalServiceInfo, String[]> hashMap2 = new HashMap<InternalServiceInfo, String[]>();
        this.partitionScaAndVmonServices(internalServiceInfoArray, hashMap2, hashMap);
        for (Map.Entry objectArray : hashMap.entrySet()) {
            ServiceTypes.Info i = ((InternalServiceInfo)objectArray.getKey()).getVmonServiceInfo();
            objectArray.setValue(CmUtil.extractHealthMessages(i));
        }
        if (hashMap2.size() > 0) {
            InternalServiceInfo[] internalServiceInfoArray2 = hashMap2.keySet().toArray(new InternalServiceInfo[0]);
            Object[] objectArray = this.getValuesPerProperty(internalServiceInfoArray2, "scaServiceState");
            for (int i = 0; i < internalServiceInfoArray2.length; ++i) {
                hashMap2.put(internalServiceInfoArray2[i], CmUtil.extractHealthMessages((ServiceState)objectArray[i]));
            }
        }
        this.mergeScaAndVmonServiceResults(internalServiceInfoArray, hashMap, hashMap2, stringArrayArray);
        return stringArrayArray;
    }

    private Object[] getServiceHealthStates(InternalServiceInfo[] internalServiceInfoArray) {
        HealthState[] healthStateArray = new HealthState[internalServiceInfoArray.length];
        HashMap hashMap = new HashMap();
        HashMap<InternalServiceInfo, HealthState> hashMap2 = new HashMap<InternalServiceInfo, HealthState>();
        this.partitionScaAndVmonServices(internalServiceInfoArray, hashMap2, hashMap);
        for (Map.Entry objectArray : hashMap.entrySet()) {
            ServiceTypes.Info i = ((InternalServiceInfo)objectArray.getKey()).getVmonServiceInfo();
            objectArray.setValue(CmUtil.healthStateFromVmonHealthStatus(i.getHealth()));
        }
        if (hashMap2.size() > 0) {
            InternalServiceInfo[] internalServiceInfoArray2 = hashMap2.keySet().toArray(new InternalServiceInfo[0]);
            Object[] objectArray = this.getValuesPerProperty(internalServiceInfoArray2, "scaServiceState");
            for (int i = 0; i < internalServiceInfoArray2.length; ++i) {
                ServiceState serviceState = (ServiceState)objectArray[i];
                String string = serviceState != null ? serviceState.healthStatus : null;
                hashMap2.put(internalServiceInfoArray2[i], CmUtil.healthStateFromScaHealthStatus(string));
            }
        }
        this.mergeScaAndVmonServiceResults(internalServiceInfoArray, hashMap, hashMap2, healthStateArray);
        return healthStateArray;
    }

    private Object getRelatedVc(InternalServiceInfo internalServiceInfo) {
        if (!"vcenterserver".equals(this.getScaServiceType(internalServiceInfo))) {
            _logger.warn((Object)("VC requested for non-VC service: " + internalServiceInfo.getServiceId()));
            return null;
        }
        ServerInfo[] serverInfoArray = this._usService.getUserSession().serversInfo;
        String string = internalServiceInfo.getServerHostname();
        if (string != null) {
            for (ServerInfo serverInfo : serverInfoArray) {
                if (!string.equals(serverInfo.name)) continue;
                ServerInfoEx serverInfoEx = (ServerInfoEx)serverInfo;
                return ((ServiceInstanceContent)serverInfoEx.content).rootFolder;
            }
        }
        return null;
    }

    private String getScaServiceType(InternalServiceInfo internalServiceInfo) {
        String string = internalServiceInfo.getServiceId();
        if ("vmware-vpxd".equals(string) || "vpxd".equals(string)) {
            return "vcenterserver";
        }
        return null;
    }

    private String getServiceShortName(InternalServiceInfo internalServiceInfo) {
        assert (internalServiceInfo != null);
        String string = this._killSwitch.useVmonForHost(internalServiceInfo.getServerHostname()) ? internalServiceInfo.getVmonServiceInfo().getNameKey() : internalServiceInfo.getScaServiceInfo().getServiceNameResourceKey();
        String string2 = null;
        if (!StringUtil.isNullOrEmpty((String)string)) {
            string2 = LocalizationUtil.getLocalizedMessage((String)string);
        }
        if (string2 == null) {
            String string3 = internalServiceInfo.getServiceId();
            string2 = String.format("(%s) instance", string3);
        }
        return string2;
    }

    private String getServiceDescription(InternalServiceInfo internalServiceInfo) {
        assert (internalServiceInfo != null);
        String string = this._killSwitch.useVmonForHost(internalServiceInfo.getServerHostname()) ? internalServiceInfo.getVmonServiceInfo().getDescriptionKey() : internalServiceInfo.getScaServiceInfo().getServiceDescriptionResourceKey();
        String string2 = null;
        if (!StringUtil.isNullOrEmpty((String)string)) {
            string2 = LocalizationUtil.getLocalizedMessage((String)string);
        }
        return string2;
    }

    private String[] getServiceNames(InternalServiceInfo[] internalServiceInfoArray) {
        assert (internalServiceInfoArray != null);
        String[] stringArray = new String[internalServiceInfoArray.length];
        for (int i = 0; i < internalServiceInfoArray.length; ++i) {
            String string = this.getServiceShortName(internalServiceInfoArray[i]);
            String string2 = internalServiceInfoArray[i].getServerHostname();
            stringArray[i] = String.format("%s (%s)", string, string2);
        }
        return stringArray;
    }

    private ServiceState[] getServiceScaStates(InternalServiceInfo[] internalServiceInfoArray) throws ServiceManagerFault {
        String string = internalServiceInfoArray[0].getServerHostname();
        assert (!this._killSwitch.useVmonForHost(string));
        String[] stringArray = new String[internalServiceInfoArray.length];
        for (int i = 0; i < internalServiceInfoArray.length; ++i) {
            stringArray[i] = internalServiceInfoArray[i].getScaServiceInfo().getServiceId();
        }
        ScaService scaService = this._scaServiceManager.getService((Object)string);
        ServiceControlManager serviceControlManager = (ServiceControlManager)scaService.getManagedObject(scaService.getServiceContent().controlManager);
        return serviceControlManager.getServiceStates(stringArray, 10L);
    }

    private ServiceStatus[] getServiceStatuses(InternalServiceInfo[] internalServiceInfoArray) throws ServiceManagerFault {
        ServiceStatus[] serviceStatusArray = new ServiceStatus[internalServiceInfoArray.length];
        HashMap hashMap = new HashMap();
        HashMap<InternalServiceInfo, ServiceStatus> hashMap2 = new HashMap<InternalServiceInfo, ServiceStatus>();
        this.partitionScaAndVmonServices(internalServiceInfoArray, hashMap2, hashMap);
        for (Map.Entry objectArray : hashMap.entrySet()) {
            ServiceTypes.Info i = ((InternalServiceInfo)objectArray.getKey()).getVmonServiceInfo();
            objectArray.setValue(CmUtil.vmonCodeToServiceStatus(i.getState()));
        }
        if (hashMap2.size() > 0) {
            InternalServiceInfo[] internalServiceInfoArray2 = hashMap2.keySet().toArray(new InternalServiceInfo[0]);
            Object[] objectArray = this.getValuesPerProperty(internalServiceInfoArray2, "scaServiceState");
            for (int i = 0; i < internalServiceInfoArray2.length; ++i) {
                if (objectArray[i] == null) {
                    hashMap2.put(internalServiceInfoArray2[i], ServiceStatus.UNKNOWN);
                    continue;
                }
                hashMap2.put(internalServiceInfoArray2[i], CmUtil.scaCodeToServiceStatus(((ServiceState)objectArray[i]).controlStatus));
            }
        }
        this.mergeScaAndVmonServiceResults(internalServiceInfoArray, hashMap, hashMap2, serviceStatusArray);
        return serviceStatusArray;
    }

    private ServiceStartupType[] getServiceStartupTypes(InternalServiceInfo[] internalServiceInfoArray) throws ServiceManagerFault {
        String string = internalServiceInfoArray[0].getServerHostname();
        ServiceStartupType[] serviceStartupTypeArray = new ServiceStartupType[internalServiceInfoArray.length];
        if (this._killSwitch.useVmonForHost(string)) {
            for (int i = 0; i < internalServiceInfoArray.length; ++i) {
                serviceStartupTypeArray[i] = CmUtil.serviceStartupTypeFromVmonStartupType(internalServiceInfoArray[i].getVmonServiceInfo().getStartupType());
            }
        } else {
            String[] stringArray = new String[internalServiceInfoArray.length];
            for (int i = 0; i < internalServiceInfoArray.length; ++i) {
                stringArray[i] = internalServiceInfoArray[i].getScaServiceInfo().getServiceId();
            }
            ScaService scaService = this._scaServiceManager.getService((Object)string);
            ServiceControlManager serviceControlManager = (ServiceControlManager)scaService.getManagedObject(scaService.getServiceContent().getControlManager());
            StartupInfo[] startupInfoArray = serviceControlManager.getStartupTypes(stringArray);
            for (int i = 0; i < stringArray.length; ++i) {
                StartupType startupType = null;
                for (int j = 0; j < startupInfoArray.length; ++j) {
                    if (!startupInfoArray[j].serviceId.equalsIgnoreCase(stringArray[i])) continue;
                    startupType = startupInfoArray[j].type;
                    break;
                }
                serviceStartupTypeArray[i] = CmUtil.serviceStartupTypeFromScaStartupType(startupType);
            }
        }
        return serviceStartupTypeArray;
    }

    private ServiceStatus getServiceStatus(InternalServiceInfo internalServiceInfo) throws ServiceManagerFault {
        return this.getServiceStatuses(new InternalServiceInfo[]{internalServiceInfo})[0];
    }

    private boolean isServiceStartupTypeEditable(InternalServiceInfo internalServiceInfo) {
        if (this._killSwitch.useVmonForHost(internalServiceInfo.getServerHostname())) {
            return true;
        }
        Object[] objectArray = internalServiceInfo.getScaServiceInfo().permittedActions;
        if (ArrayUtil.isNullOrEmpty((Object[])objectArray)) {
            return false;
        }
        int n = 0;
        if (ArrayUtil.contains((Object)ServiceInfo.ControlActions.SET_STARTUPTYPE_AUTOMATIC.toString(), (Object[])objectArray).booleanValue()) {
            ++n;
        }
        if (ArrayUtil.contains((Object)ServiceInfo.ControlActions.SET_STARTUPTYPE_MANUAL.toString(), (Object[])objectArray).booleanValue()) {
            ++n;
        }
        if (ArrayUtil.contains((Object)ServiceInfo.ControlActions.SET_STARTUPTYPE_DISABLED.toString(), (Object[])objectArray).booleanValue()) {
            ++n;
        }
        return n > 1;
    }

    private boolean isServiceControlActionAvailable(InternalServiceInfo internalServiceInfo, ServiceInfo.ControlActions controlActions) throws ServiceManagerFault {
        boolean bl = true;
        if (!this._killSwitch.useVmonForHost(internalServiceInfo.getServerHostname())) {
            ServiceInfo serviceInfo = internalServiceInfo.getScaServiceInfo();
            boolean bl2 = bl = bl && ArrayUtil.contains((Object)controlActions.name(), (Object[])serviceInfo.permittedActions) != false;
        }
        if (controlActions == ServiceInfo.ControlActions.START) {
            bl = bl && this.serviceIsEnabled(internalServiceInfo);
            bl = bl && this.getServiceStatus(internalServiceInfo).isStoppedState();
        } else if (controlActions == ServiceInfo.ControlActions.RESTART) {
            bl = bl && this.serviceIsEnabled(internalServiceInfo);
            bl = bl && this.getServiceStatus(internalServiceInfo).isRunningState();
            bl = bl && !ServiceInfoPropertyValueExtractor.isLocalWebClientServiceInstance(internalServiceInfo);
        } else if (controlActions == ServiceInfo.ControlActions.STOP) {
            bl = bl && this.getServiceStatus(internalServiceInfo).isRunningState();
            bl = bl && !ServiceInfoPropertyValueExtractor.isLocalWebClientServiceInstance(internalServiceInfo);
        } else if (controlActions == ServiceInfo.ControlActions.SET_STARTUPTYPE_DISABLED) {
            bl = bl && this.getServiceStatus(internalServiceInfo).isStoppedState();
        }
        return bl;
    }

    private static boolean isLocalWebClientServiceInstance(InternalServiceInfo internalServiceInfo) {
        boolean bl = false;
        if (!"vsphere-client".equalsIgnoreCase(internalServiceInfo.getServiceId())) {
            return bl;
        }
        InetAddress[] inetAddressArray = null;
        InetAddress inetAddress = null;
        try {
            inetAddressArray = InetAddress.getAllByName(InetAddress.getLocalHost().getHostName());
            inetAddress = InetAddress.getByName(internalServiceInfo.getServerHostname());
        }
        catch (UnknownHostException unknownHostException) {
            _logger.error((Object)"Error getting host address", (Throwable)unknownHostException);
        }
        if (inetAddressArray != null && inetAddress != null) {
            for (InetAddress inetAddress2 : inetAddressArray) {
                if (!inetAddress2.getHostAddress().equalsIgnoreCase(inetAddress.getHostAddress())) continue;
                bl = true;
                break;
            }
        }
        return bl;
    }

    private boolean serviceIsEnabled(InternalServiceInfo internalServiceInfo) {
        ServiceStartupType serviceStartupType = (ServiceStartupType)((Object)this.getValuesPerProperty(new InternalServiceInfo[]{internalServiceInfo}, "startupType")[0]);
        return ServiceStartupType.DISABLED != serviceStartupType;
    }

    private URI[] getServersForServices(InternalServiceInfo[] internalServiceInfoArray) {
        assert (internalServiceInfoArray != null);
        URI[] uRIArray = new URI[internalServiceInfoArray.length];
        for (int i = 0; i < internalServiceInfoArray.length; ++i) {
            uRIArray[i] = CmReferenceUtil.getServerReference(internalServiceInfoArray[i].getServerHostname());
        }
        return uRIArray;
    }

    private String[] getServerHostnamesForServices(InternalServiceInfo[] internalServiceInfoArray) {
        assert (internalServiceInfoArray != null);
        String[] stringArray = new String[internalServiceInfoArray.length];
        for (int i = 0; i < internalServiceInfoArray.length; ++i) {
            stringArray[i] = internalServiceInfoArray[i].getServerHostname();
        }
        return stringArray;
    }

    private ServiceConfigurationManager getScmService(InternalServiceInfo internalServiceInfo) {
        if (internalServiceInfo == null) {
            return null;
        }
        String string = internalServiceInfo.getServerHostname();
        ScaService scaService = this._scaServiceManager.getService((Object)string);
        com.vmware.vim.binding.sca.ServiceInstanceContent serviceInstanceContent = scaService.getServiceContent();
        return (ServiceConfigurationManager)scaService.getManagedObject(serviceInstanceContent.configManager);
    }

    private <ResultType> void partitionScaAndVmonServices(InternalServiceInfo[] internalServiceInfoArray, Map<InternalServiceInfo, ResultType> map, Map<InternalServiceInfo, ResultType> map2) {
        assert (internalServiceInfoArray != null && map != null && map2 != null);
        assert (map.size() == 0 && map2.size() == 0);
        HashMap hashMap = new HashMap();
        for (InternalServiceInfo internalServiceInfo : internalServiceInfoArray) {
            hashMap.put(internalServiceInfo.getServerHostname(), null);
        }
        for (Map.Entry entry : hashMap.entrySet()) {
            entry.setValue(this._killSwitch.useVmonForHost((String)entry.getKey()));
        }
        for (InternalServiceInfo internalServiceInfo : internalServiceInfoArray) {
            if (((Boolean)hashMap.get(internalServiceInfo.getServerHostname())).booleanValue()) {
                map2.put(internalServiceInfo, null);
                continue;
            }
            map.put(internalServiceInfo, null);
        }
    }

    private <ResultType> void mergeScaAndVmonServiceResults(InternalServiceInfo[] internalServiceInfoArray, Map<InternalServiceInfo, ResultType> map, Map<InternalServiceInfo, ResultType> map2, ResultType[] ResultTypeArray) {
        for (int i = 0; i < internalServiceInfoArray.length; ++i) {
            ResultTypeArray[i] = map2.containsKey(internalServiceInfoArray[i]) ? map2.get(internalServiceInfoArray[i]) : map.get(internalServiceInfoArray[i]);
        }
    }
}

