/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.automatic.plugin.registration;

import com.vmware.automatic.plugin.registration.commands.IsPluginRegisteredCmd;
import com.vmware.automatic.plugin.registration.commands.PluginCmd;
import com.vmware.automatic.plugin.registration.commands.RegisterPluginCmd;
import com.vmware.automatic.plugin.registration.commands.UnregisterPluginCmd;
import com.vmware.automatic.plugin.registration.commands.UpdatePluginCmd;
import com.vmware.automatic.plugin.registration.commands.utils.PrintHelper;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;

public class PluginRegistrationMain {
    private static final Map<String, PluginCmd> commands = new HashMap<String, PluginCmd>();
    private static final Options options;
    private static String _allCommands;

    public static void main(String[] stringArray) {
        PluginRegistrationMain.execute(stringArray);
    }

    private static void execute(String[] stringArray) {
        CommandLine commandLine = null;
        DefaultParser defaultParser = new DefaultParser();
        try {
            commandLine = defaultParser.parse(options, stringArray, true);
        }
        catch (ParseException parseException) {
            PrintHelper.printHelp(options, parseException.getMessage());
        }
        if (commandLine != null) {
            PluginCmd pluginCmd = commands.get(commandLine.getOptionValue("action"));
            if (pluginCmd != null) {
                try {
                    pluginCmd.execute(stringArray);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            } else {
                PrintHelper.printHelp(options, "Missing argument for option: -action <action> " + _allCommands);
            }
        }
    }

    static {
        commands.put("registerPlugin", new RegisterPluginCmd());
        commands.put("unregisterPlugin", new UnregisterPluginCmd());
        commands.put("updatePlugin", new UpdatePluginCmd());
        commands.put("isPluginRegistered", new IsPluginRegisteredCmd());
        options = new Options();
        Iterator<String> iterator = commands.keySet().iterator();
        while (iterator.hasNext()) {
            Options options = commands.get(iterator.next()).getPluginOpts();
            for (Option option : options.getOptions()) {
                option.setRequired(false);
                PluginRegistrationMain.options.addOption(option);
            }
        }
        _allCommands = Arrays.toString(commands.keySet().toArray());
        _allCommands = _allCommands.substring(1, _allCommands.length() - 1);
        options.addOption(Option.builder("action").hasArg().argName("action").desc(_allCommands).required().build());
    }
}

