/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.automatic.plugin.registration.commands;

import com.vmware.automatic.plugin.registration.commands.PluginCmd;
import com.vmware.vim25.NotFoundFaultMsg;
import com.vmware.vim25.RuntimeFaultFaultMsg;

public class UnregisterPluginCmd
extends PluginCmd {
    public UnregisterPluginCmd() {
        this._action = "-action unregisterPlugin";
        this._errorMessage = "Unregister plugin to the VC";
    }

    @Override
    protected void doExecute() {
        if (this._key == null) {
            System.out.println("To unregister a plugin you must provide the key for the plugin\n");
        } else {
            try {
                if (this._vimPort.findExtension(this._extensionManager, this._key) != null) {
                    this._vimPort.unregisterExtension(this._extensionManager, this._key);
                    System.out.println("Plugin: " + this._key + " has been successfully un-registered from vCenter <" + this._url + ">.");
                } else {
                    System.out.println("Plugin: " + this._key + " is not registered with vCenter <" + this._url + ">.");
                }
            }
            catch (RuntimeFaultFaultMsg runtimeFaultFaultMsg) {
                System.out.println("Exception while finding plugin");
                runtimeFaultFaultMsg.printStackTrace();
            }
            catch (NotFoundFaultMsg notFoundFaultMsg) {
                System.out.println("Exception while un-registering plugin");
                notFoundFaultMsg.printStackTrace();
            }
        }
    }
}

