/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.samples.customprovider;

import com.vmware.samples.customprovider.EarthLocation;
import com.vmware.samples.customprovider.ElevationData;
import com.vmware.samples.customprovider.GoogleService;
import com.vmware.vise.data.PropertySpec;
import com.vmware.vise.data.query.DataException;
import com.vmware.vise.data.query.DataServiceExtensionRegistry;
import com.vmware.vise.data.query.PropertyProviderAdapter;
import com.vmware.vise.data.query.PropertyRequestSpec;
import com.vmware.vise.data.query.PropertyValue;
import com.vmware.vise.data.query.ResultItem;
import com.vmware.vise.data.query.ResultSet;
import com.vmware.vise.data.query.TypeInfo;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CustomHostPropertyProviderImpl
implements PropertyProviderAdapter {
    private static final Log _logger = LogFactory.getLog(CustomHostPropertyProviderImpl.class);
    private static final String HOST_TYPE = "HostSystem";
    private static final String ELEVATIONDATA_PROPERTY = "samples:elevationData";
    private GoogleService _googleService;

    public CustomHostPropertyProviderImpl(GoogleService googleService, DataServiceExtensionRegistry dataServiceExtensionRegistry) {
        this._googleService = googleService;
        dataServiceExtensionRegistry.registerDataAdapter((PropertyProviderAdapter)this, this.getProvidedTypeInfos());
    }

    private TypeInfo[] getProvidedTypeInfos() {
        TypeInfo typeInfo = new TypeInfo();
        typeInfo.type = HOST_TYPE;
        typeInfo.properties = new String[]{ELEVATIONDATA_PROPERTY};
        return new TypeInfo[]{typeInfo};
    }

    public ResultSet getProperties(PropertyRequestSpec propertyRequestSpec) {
        if (propertyRequestSpec == null || propertyRequestSpec.objects == null || propertyRequestSpec.objects.length != 1) {
            _logger.error((Object)"CustomHostPropertyProvider only supports 1 object at a time.");
            return null;
        }
        Object object = propertyRequestSpec.objects[0];
        EarthLocation earthLocation = this.getLocationParameter(propertyRequestSpec);
        if (earthLocation == null) {
            _logger.error((Object)"Invalid PropertyRequestSpec in CustomHostPropertyProvider");
            return null;
        }
        ResultSet resultSet = new ResultSet();
        try {
            ElevationData elevationData = this._googleService.getElevationData(earthLocation.latitude, earthLocation.longitude);
            ResultItem resultItem = new ResultItem();
            resultItem.resourceObject = object;
            PropertyValue propertyValue = new PropertyValue();
            propertyValue.resourceObject = object;
            propertyValue.propertyName = ELEVATIONDATA_PROPERTY;
            propertyValue.value = elevationData;
            resultItem.properties = new PropertyValue[]{propertyValue};
            resultSet.items = new ResultItem[]{resultItem};
        }
        catch (Exception exception) {
            _logger.error((Object)"CustomHostPropertyProviderImpl.getProperties error", (Throwable)exception);
            DataException dataException = DataException.newInstance((Throwable)exception, (Object[])propertyRequestSpec.objects, (String[])propertyRequestSpec.properties[0].propertyNames);
            resultSet.error = dataException;
        }
        return resultSet;
    }

    private EarthLocation getLocationParameter(PropertyRequestSpec propertyRequestSpec) {
        if (propertyRequestSpec == null || propertyRequestSpec.properties == null || propertyRequestSpec.properties.length != 1) {
            return null;
        }
        PropertySpec propertySpec = propertyRequestSpec.properties[0];
        if (propertySpec.propertyNames == null || propertySpec.propertyNames.length != 1 || !ELEVATIONDATA_PROPERTY.equals(propertySpec.propertyNames[0])) {
            return null;
        }
        if (propertySpec.parameters == null || propertySpec.parameters.length != 1) {
            return null;
        }
        EarthLocation earthLocation = (EarthLocation)propertySpec.parameters[0].parameter;
        return earthLocation;
    }
}

