/*
 * Decompiled with CFR 0.152.
 */
package reactor;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.Dispatcher;
import reactor.core.DispatcherSupplier;
import reactor.core.config.ConfigurationReader;
import reactor.core.config.DispatcherConfiguration;
import reactor.core.config.DispatcherType;
import reactor.core.config.PropertiesConfigurationReader;
import reactor.core.config.ReactorConfiguration;
import reactor.core.convert.StandardConverters;
import reactor.core.dispatch.MpscDispatcher;
import reactor.core.dispatch.RingBufferDispatcher;
import reactor.core.dispatch.SynchronousDispatcher;
import reactor.core.dispatch.TailRecurseDispatcher;
import reactor.core.dispatch.ThreadPoolExecutorDispatcher;
import reactor.core.dispatch.WorkQueueDispatcher;
import reactor.core.dispatch.wait.AgileWaitingStrategy;
import reactor.core.internal.PlatformDependent;
import reactor.core.processor.CancelException;
import reactor.fn.Consumer;
import reactor.fn.timer.HashWheelTimer;
import reactor.fn.timer.Timer;
import reactor.jarjar.com.lmax.disruptor.WaitStrategy;
import reactor.jarjar.com.lmax.disruptor.dsl.ProducerType;

public class Environment
implements Iterable<Map.Entry<String, Dispatcher>>,
Closeable {
    public static final String DISPATCHER_GROUP = "dispatcherGroup";
    public static final String SHARED = "shared";
    public static final String MPSC = "mpsc";
    public static final String THREAD_POOL = "threadPoolExecutor";
    public static final String WORK_QUEUE = "workQueue";
    public static final int PROCESSORS = Runtime.getRuntime().availableProcessors() > 1 ? Runtime.getRuntime().availableProcessors() : 2;
    private static final AtomicReference<Environment> enviromentReference = new AtomicReference();
    private static final String DEFAULT_DISPATCHER_NAME = "__default-dispatcher";
    private static final String SYNC_DISPATCHER_NAME = "sync";
    private final Properties env;
    private final AtomicReference<Timer> timer = new AtomicReference();
    private final Object monitor = new Object();
    private final Map<String, DispatcherSupplier> dispatcherFactories = new HashMap<String, DispatcherSupplier>();
    private final ReactorConfiguration configuration;
    private final Map<String, Dispatcher> dispatchers;
    private final String defaultDispatcher;
    private volatile Consumer<? super Throwable> errorConsumer;

    public static Environment initialize() {
        return Environment.assign(new Environment()).assignErrorJournal();
    }

    public static Environment initialize(Consumer<Throwable> errorConsumer) {
        return Environment.assign(new Environment()).assignErrorJournal(errorConsumer);
    }

    public static Environment initializeIfEmpty() {
        if (Environment.alive()) {
            return Environment.get();
        }
        return Environment.assign(new Environment());
    }

    public static Environment assign(Environment environment) {
        if (!enviromentReference.compareAndSet(null, environment)) {
            environment.shutdown();
            throw new IllegalStateException("An environment is already initialized in the current context");
        }
        return environment;
    }

    public static boolean alive() {
        return enviromentReference.get() != null;
    }

    public static Environment get() throws IllegalStateException {
        Environment environment = enviromentReference.get();
        if (environment == null) {
            throw new IllegalStateException("The environment has not been initialized yet");
        }
        return environment;
    }

    public static void terminate() throws IllegalStateException {
        Environment env = Environment.get();
        enviromentReference.compareAndSet(env, null);
        env.shutdown();
    }

    public static Timer timer() {
        return Environment.get().getTimer();
    }

    public static Dispatcher sharedDispatcher() {
        return Environment.get().getDefaultDispatcher();
    }

    public static Dispatcher workDispatcher() {
        return Environment.get().getDispatcher(WORK_QUEUE);
    }

    public static Dispatcher cachedDispatcher() {
        return (Dispatcher)Environment.get().getCachedDispatchers().get();
    }

    public static Dispatcher dispatcher(String key) {
        return Environment.get().getDispatcher(key);
    }

    public static TailRecurseDispatcher tailRecurse() {
        return new TailRecurseDispatcher();
    }

    public static Dispatcher dispatcher(String key, Dispatcher dispatcher) {
        if (dispatcher != null) {
            Environment.get().setDispatcher(key, dispatcher);
        } else {
            Environment.get().removeDispatcher(key);
        }
        return dispatcher;
    }

    public static Dispatcher newDispatcherLike(String key) {
        return Environment.newDispatcherLike(key, null);
    }

    public static Dispatcher newDispatcherLike(String key, String newKey) {
        Environment env = Environment.get();
        for (DispatcherConfiguration dispatcherConfiguration : env.configuration.getDispatcherConfigurations()) {
            if (!dispatcherConfiguration.getName().equals(key)) continue;
            Dispatcher newDispatcher = Environment.initDispatcherFromConfiguration(dispatcherConfiguration);
            if (newKey != null && !newKey.isEmpty()) {
                env.setDispatcher(newKey, newDispatcher);
            }
            return newDispatcher;
        }
        throw new IllegalStateException("No dispatcher configuration found for " + key);
    }

    public static Dispatcher newDispatcher() {
        return Environment.newDispatcher(2048);
    }

    public static Dispatcher newDispatcher(int backlog) {
        return Environment.newDispatcher(null, backlog);
    }

    public static Dispatcher newDispatcher(String key, int backlog) {
        return Environment.newDispatcher(key, backlog, 1, PlatformDependent.hasUnsafe() ? DispatcherType.RING_BUFFER : DispatcherType.MPSC);
    }

    public static Dispatcher newDispatcher(int backlog, int consumers) {
        return Environment.newDispatcher(null, backlog, consumers);
    }

    public static Dispatcher newDispatcher(String key, int backlog, int consumers) {
        if (consumers > 1 && PlatformDependent.hasUnsafe()) {
            return Environment.newDispatcher(key, backlog, consumers, DispatcherType.WORK_QUEUE);
        }
        return Environment.newDispatcher(key, backlog);
    }

    public static Dispatcher newDispatcher(int backlog, int consumers, DispatcherType dispatcherType) {
        return Environment.newDispatcher(null, backlog, consumers, dispatcherType);
    }

    public static Dispatcher newDispatcher(String key, int backlog, int consumers, DispatcherType dispatcherType) {
        Dispatcher dispatcher = Environment.initDispatcherFromConfiguration(new DispatcherConfiguration(key, dispatcherType, backlog, consumers));
        if (key != null && !key.isEmpty()) {
            Environment environment = Environment.get();
            environment.setDispatcher(key, dispatcher);
        }
        return dispatcher;
    }

    public static DispatcherSupplier cachedDispatchers(String key) {
        return Environment.get().getCachedDispatchers(key);
    }

    public static DispatcherSupplier cachedDispatchers() {
        return Environment.get().getCachedDispatchers();
    }

    public static DispatcherSupplier cachedDispatchers(String key, DispatcherSupplier dispatcherSupplier) {
        if (dispatcherSupplier != null) {
            Environment.get().addCachedDispatchers(key, dispatcherSupplier);
        } else {
            Environment.get().removeCachedDispatchers(key);
        }
        return dispatcherSupplier;
    }

    public Environment() {
        this(Collections.emptyMap(), new PropertiesConfigurationReader());
    }

    public Environment(ConfigurationReader configurationReader) {
        this(Collections.emptyMap(), configurationReader);
    }

    public Environment(Map<String, Dispatcher> dispatchers, ConfigurationReader configurationReader) {
        this.dispatchers = new HashMap<String, Dispatcher>(dispatchers);
        this.configuration = configurationReader.read();
        this.defaultDispatcher = this.configuration.getDefaultDispatcherName() != null ? this.configuration.getDefaultDispatcherName() : DEFAULT_DISPATCHER_NAME;
        this.env = this.configuration.getAdditionalProperties();
    }

    public static DispatcherSupplier newCachedDispatchers(int poolsize) {
        return Environment.newCachedDispatchers(poolsize, "parallel");
    }

    public static DispatcherSupplier newCachedDispatchers(int poolsize, String name) {
        return Environment.createDispatcherFactory(name, poolsize, 1024, null, ProducerType.MULTI, new AgileWaitingStrategy());
    }

    public static DispatcherSupplier newFanOutCachedDispatchers(int poolsize, String name) {
        return Environment.createDispatcherFactory(name, poolsize, 1024, null, ProducerType.SINGLE, new AgileWaitingStrategy());
    }

    private static ThreadPoolExecutorDispatcher createThreadPoolExecutorDispatcher(DispatcherConfiguration dispatcherConfiguration) {
        int size = Environment.getSize(dispatcherConfiguration, 0);
        int backlog = Environment.getBacklog(dispatcherConfiguration, 128);
        return new ThreadPoolExecutorDispatcher(size, backlog, dispatcherConfiguration.getName());
    }

    private static WorkQueueDispatcher createWorkQueueDispatcher(DispatcherConfiguration dispatcherConfiguration) {
        int size = Environment.getSize(dispatcherConfiguration, 0);
        int backlog = Environment.getBacklog(dispatcherConfiguration, 16384);
        return new WorkQueueDispatcher("workQueueDispatcher", size, backlog, null);
    }

    private static RingBufferDispatcher createRingBufferDispatcher(DispatcherConfiguration dispatcherConfiguration) {
        int backlog = Environment.getBacklog(dispatcherConfiguration, 1024);
        return new RingBufferDispatcher(dispatcherConfiguration.getName(), backlog, null, ProducerType.MULTI, new AgileWaitingStrategy());
    }

    private static MpscDispatcher createMpscDispatcher(DispatcherConfiguration dispatcherConfiguration) {
        int backlog = Environment.getBacklog(dispatcherConfiguration, 1024);
        return new MpscDispatcher(dispatcherConfiguration.getName(), backlog);
    }

    private static int getBacklog(DispatcherConfiguration dispatcherConfiguration, int defaultBacklog) {
        Integer backlog = dispatcherConfiguration.getBacklog();
        if (null == backlog) {
            backlog = defaultBacklog;
        }
        return backlog;
    }

    private static int getSize(DispatcherConfiguration dispatcherConfiguration, int defaultSize) {
        Integer size = dispatcherConfiguration.getSize();
        if (null == size) {
            size = defaultSize;
        }
        if (size < 1) {
            size = PROCESSORS;
        }
        return size;
    }

    public String getProperty(String key, String defaultValue) {
        return this.env.getProperty(key, defaultValue);
    }

    public <T> T getProperty(String key, Class<T> type, T defaultValue) {
        String val = this.env.getProperty(key);
        if (null == val) {
            return defaultValue;
        }
        if (!type.isAssignableFrom(val.getClass()) && StandardConverters.CONVERTERS.canConvert(String.class, type)) {
            return StandardConverters.CONVERTERS.convert(val, type);
        }
        return (T)val;
    }

    public Dispatcher getDefaultDispatcher() {
        return this.getDispatcher(this.defaultDispatcher);
    }

    public Dispatcher getCachedDispatcher() {
        return (Dispatcher)this.getCachedDispatchers(DISPATCHER_GROUP).get();
    }

    public DispatcherSupplier getCachedDispatchers() {
        return this.getCachedDispatchers(DISPATCHER_GROUP);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DispatcherSupplier getCachedDispatchers(String name) {
        Object object = this.monitor;
        synchronized (object) {
            this.initDispatcherFactoryFromConfiguration(name);
            DispatcherSupplier factory = this.dispatcherFactories.get(name);
            if (factory == null) {
                throw new IllegalArgumentException("No Supplier<Dispatcher> found for name '" + name + "', " + "it must be present" + "in the configuration properties or being registered programmatically through this#addCachedDispatchers(" + name + ", someDispatcherSupplier)");
            }
            return factory;
        }
    }

    public Dispatcher getDispatcher(String name) {
        if (name.equals(SYNC_DISPATCHER_NAME)) {
            return SynchronousDispatcher.INSTANCE;
        }
        Object object = this.monitor;
        synchronized (object) {
            this.initDispatcherFromConfiguration(name);
            Dispatcher dispatcher = this.dispatchers.get(name);
            if (dispatcher != null) {
                return dispatcher;
            }
            throw new IllegalArgumentException("No Dispatcher found for name '" + name + "', it must be present " + "in the configuration properties or being registered programmatically through this#setDispatcher(" + name + ", someDispatcher)");
        }
    }

    public void routeError(Throwable throwable) {
        Consumer<? super Throwable> errorJournal = this.errorConsumer;
        if (errorJournal != null) {
            errorJournal.accept(throwable);
        }
    }

    public Environment assignErrorJournal() {
        return this.assignErrorJournal((Consumer<? super Throwable>)new Consumer<Throwable>(){
            Logger log = LoggerFactory.getLogger((String)"reactor.environment");

            @Override
            public void accept(Throwable throwable) {
                if (CancelException.TRACE_CANCEL || !CancelException.class.isAssignableFrom(throwable.getClass())) {
                    this.log.error("", throwable);
                }
            }
        });
    }

    public Environment assignErrorJournal(Consumer<? super Throwable> errorJournal) {
        this.errorConsumer = errorJournal;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Environment setDispatcher(String name, Dispatcher dispatcher) {
        Object object = this.monitor;
        synchronized (object) {
            this.dispatchers.put(name, dispatcher);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Environment addCachedDispatchers(String name, DispatcherSupplier dispatcherFactory) {
        Object object = this.monitor;
        synchronized (object) {
            this.dispatcherFactories.put(name, dispatcherFactory);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Environment removeCachedDispatchers(String name) {
        Object object = this.monitor;
        synchronized (object) {
            this.dispatcherFactories.remove(name).shutdown();
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Environment removeDispatcher(String name) {
        Object object = this.monitor;
        synchronized (object) {
            Dispatcher dispatcher = this.dispatchers.remove(name);
            if (dispatcher != null) {
                dispatcher.shutdown();
            }
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Timer getTimer() {
        if (null == this.timer.get()) {
            AtomicReference<Timer> atomicReference = this.timer;
            synchronized (atomicReference) {
                HashWheelTimer t = new HashWheelTimer();
                if (!this.timer.compareAndSet(null, t)) {
                    t.cancel();
                }
            }
        }
        return this.timer.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        ArrayList<Dispatcher> dispatchers = new ArrayList<Dispatcher>();
        Iterator<Object> iterator = this.monitor;
        synchronized (iterator) {
            dispatchers.addAll(this.dispatchers.values());
        }
        for (Dispatcher dispatcher : dispatchers) {
            dispatcher.awaitAndShutdown();
        }
        for (DispatcherSupplier dispatcherSupplier : this.dispatcherFactories.values()) {
            dispatcherSupplier.shutdown();
        }
        if (null != this.timer.get()) {
            this.timer.get().cancel();
        }
    }

    @Override
    public Iterator<Map.Entry<String, Dispatcher>> iterator() {
        return this.dispatchers.entrySet().iterator();
    }

    @Override
    public void close() throws IOException {
        this.shutdown();
    }

    public static DispatcherSupplier createDispatcherFactory(final String name, final int poolsize, final int bufferSize, final Consumer<Throwable> errorHandler, final ProducerType producerType, final WaitStrategy waitStrategy) {
        return new DispatcherSupplier(){
            volatile int roundRobinIndex = -1;
            Dispatcher[] dispatchers = new Dispatcher[poolsize];
            boolean terminated = false;

            @Override
            public boolean alive() {
                return this.terminated;
            }

            @Override
            public void shutdown() {
                if (this.terminated) {
                    return;
                }
                for (Dispatcher dispatcher : this.dispatchers) {
                    if (dispatcher == null) continue;
                    dispatcher.shutdown();
                }
                this.terminated = true;
            }

            @Override
            public void forceShutdown() {
                if (this.terminated) {
                    return;
                }
                for (Dispatcher dispatcher : this.dispatchers) {
                    if (dispatcher == null) continue;
                    dispatcher.forceShutdown();
                }
                this.terminated = true;
            }

            @Override
            public boolean awaitAndShutdown() {
                return this.awaitAndShutdown(-1L, TimeUnit.SECONDS);
            }

            @Override
            public boolean awaitAndShutdown(long timeout, TimeUnit timeUnit) {
                if (this.terminated) {
                    return true;
                }
                boolean allShutdown = true;
                for (Dispatcher dispatcher : this.dispatchers) {
                    if (dispatcher == null || dispatcher.awaitAndShutdown(timeout, timeUnit)) continue;
                    allShutdown = false;
                }
                this.terminated = allShutdown;
                return true;
            }

            private int getNextIndex() {
                if (++this.roundRobinIndex == poolsize) {
                    this.roundRobinIndex = 0;
                }
                return this.roundRobinIndex;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Dispatcher get() {
                int index = this.getNextIndex();
                Dispatcher dispatcher = this.dispatchers[index];
                if (dispatcher == null) {
                    2 var3_3 = this;
                    synchronized (var3_3) {
                        dispatcher = this.dispatchers[index];
                        if (dispatcher == null) {
                            this.dispatchers[index] = PlatformDependent.hasUnsafe() ? new RingBufferDispatcher(name, bufferSize, errorHandler, producerType, waitStrategy) : new MpscDispatcher(name, bufferSize);
                            dispatcher = this.dispatchers[index];
                        }
                    }
                }
                return dispatcher;
            }
        };
    }

    private void initDispatcherFromConfiguration(String name) {
        if (this.dispatchers.get(name) != null) {
            return;
        }
        for (DispatcherConfiguration dispatcherConfiguration : this.configuration.getDispatcherConfigurations()) {
            Dispatcher dispatcher;
            if (!dispatcherConfiguration.getName().equalsIgnoreCase(name) || (dispatcher = Environment.initDispatcherFromConfiguration(dispatcherConfiguration)) == null) continue;
            this.setDispatcher(dispatcherConfiguration.getName(), dispatcher);
        }
    }

    private static Dispatcher initDispatcherFromConfiguration(DispatcherConfiguration dispatcherConfiguration) {
        Dispatcher dispatcher = null;
        if (PlatformDependent.hasUnsafe() && DispatcherType.RING_BUFFER == dispatcherConfiguration.getType()) {
            dispatcher = Environment.createRingBufferDispatcher(dispatcherConfiguration);
        } else if (DispatcherType.RING_BUFFER == dispatcherConfiguration.getType() || DispatcherType.MPSC == dispatcherConfiguration.getType()) {
            dispatcher = Environment.createMpscDispatcher(dispatcherConfiguration);
        } else if (DispatcherType.SYNCHRONOUS == dispatcherConfiguration.getType()) {
            dispatcher = SynchronousDispatcher.INSTANCE;
        } else if (DispatcherType.THREAD_POOL_EXECUTOR == dispatcherConfiguration.getType()) {
            dispatcher = Environment.createThreadPoolExecutorDispatcher(dispatcherConfiguration);
        } else if (DispatcherType.WORK_QUEUE == dispatcherConfiguration.getType()) {
            dispatcher = Environment.createWorkQueueDispatcher(dispatcherConfiguration);
        }
        return dispatcher;
    }

    private void initDispatcherFactoryFromConfiguration(String name) {
        if (this.dispatcherFactories.get(name) != null) {
            return;
        }
        for (DispatcherConfiguration dispatcherConfiguration : this.configuration.getDispatcherConfigurations()) {
            if (!dispatcherConfiguration.getName().equalsIgnoreCase(name) || DispatcherType.DISPATCHER_GROUP != dispatcherConfiguration.getType()) continue;
            this.addCachedDispatchers(dispatcherConfiguration.getName(), Environment.createDispatcherFactory(dispatcherConfiguration.getName(), dispatcherConfiguration.getSize() == 0 ? PROCESSORS : dispatcherConfiguration.getSize(), dispatcherConfiguration.getBacklog(), null, ProducerType.MULTI, new AgileWaitingStrategy()));
        }
    }
}

