/*
 * Decompiled with CFR 0.152.
 */
package reactor.core.alloc.spec;

import java.util.concurrent.ExecutorService;
import reactor.core.alloc.Recyclable;
import reactor.core.alloc.Reference;
import reactor.core.alloc.RingBufferAllocator;
import reactor.core.support.Assert;
import reactor.fn.Consumer;
import reactor.fn.Supplier;
import reactor.jarjar.com.lmax.disruptor.BlockingWaitStrategy;
import reactor.jarjar.com.lmax.disruptor.EventHandler;
import reactor.jarjar.com.lmax.disruptor.ExceptionHandler;
import reactor.jarjar.com.lmax.disruptor.WaitStrategy;
import reactor.jarjar.com.lmax.disruptor.dsl.ProducerType;

public class RingBufferAllocatorSpec<T extends Recyclable>
implements Supplier<RingBufferAllocator<T>> {
    private String name = "ring-buffer-allocator";
    private int ringSize = 1024;
    private int eventThreads = 1;
    private Supplier<T> allocator;
    private Consumer<Reference<T>> eventHandler;
    private Consumer<Throwable> errorHandler;
    private ProducerType producerType;
    private WaitStrategy waitStrategy;
    private ExecutorService executor;

    public RingBufferAllocatorSpec<T> name(String name) {
        this.name = name;
        return this;
    }

    public RingBufferAllocatorSpec<T> ringSize(int ringSize) {
        Assert.isTrue(ringSize > 0, "Ring size must be greater than 0 (zero).");
        this.ringSize = ringSize;
        return this;
    }

    public RingBufferAllocatorSpec<T> eventThreads(int eventThreads) {
        Assert.isTrue(eventThreads > 0, "Threads size must be 1 or greater.");
        this.eventThreads = eventThreads;
        return this;
    }

    public RingBufferAllocatorSpec<T> allocator(Supplier<T> allocator) {
        this.allocator = allocator;
        return this;
    }

    public RingBufferAllocatorSpec<T> eventHandler(Consumer<Reference<T>> eventHandler) {
        this.eventHandler = eventHandler;
        return this;
    }

    public RingBufferAllocatorSpec<T> errorHandler(Consumer<Throwable> errorHandler) {
        this.errorHandler = errorHandler;
        return this;
    }

    public RingBufferAllocatorSpec<T> producerType(ProducerType producerType) {
        this.producerType = producerType;
        return this;
    }

    public RingBufferAllocatorSpec<T> waitStrategy(WaitStrategy waitStrategy) {
        this.waitStrategy = waitStrategy;
        return this;
    }

    public RingBufferAllocatorSpec<T> executor(ExecutorService executor) {
        this.executor = executor;
        return this;
    }

    @Override
    public RingBufferAllocator<T> get() {
        Assert.notNull(this.allocator, "Object Supplier (allocator) cannot be null.");
        if (null == this.producerType) {
            this.producerType = ProducerType.MULTI;
        }
        if (null == this.waitStrategy) {
            this.waitStrategy = new BlockingWaitStrategy();
        }
        RingBufferAllocator<T> alloc = new RingBufferAllocator<T>(this.name, this.ringSize, this.allocator, this.eventThreads, null != this.eventHandler ? new EventHandler<Reference<T>>(){

            @Override
            public void onEvent(Reference<T> ref, long sequence, boolean endOfBatch) throws Exception {
                RingBufferAllocatorSpec.this.eventHandler.accept(ref);
                if (ref.getReferenceCount() > 0) {
                    ref.release();
                }
            }
        } : null, null != this.errorHandler ? new ExceptionHandler(){

            public void handleEventException(Throwable ex, long sequence, Object event) {
                RingBufferAllocatorSpec.this.errorHandler.accept(ex);
            }

            @Override
            public void handleOnStartException(Throwable ex) {
                RingBufferAllocatorSpec.this.errorHandler.accept(ex);
            }

            @Override
            public void handleOnShutdownException(Throwable ex) {
                RingBufferAllocatorSpec.this.errorHandler.accept(ex);
            }
        } : null, this.producerType, this.waitStrategy, this.executor);
        alloc.start();
        return alloc;
    }
}

