/*
 * Decompiled with CFR 0.152.
 */
package reactor.core.reactivestreams;

import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import reactor.core.reactivestreams.SubscriberWithContext;
import reactor.core.support.Assert;
import reactor.core.support.Exceptions;
import reactor.core.support.SpecificationExceptions;
import reactor.fn.BiConsumer;
import reactor.fn.Consumer;
import reactor.fn.Function;

public class PublisherFactory<T, C>
implements Publisher<T> {
    protected final Function<Subscriber<? super T>, C> contextFactory;
    protected final BiConsumer<Long, SubscriberWithContext<T, C>> requestConsumer;
    protected final Consumer<C> shutdownConsumer;

    public static <T> Publisher<T> create(BiConsumer<Long, SubscriberWithContext<T, Void>> requestConsumer) {
        return PublisherFactory.create(requestConsumer, null, null);
    }

    public static <T, C> Publisher<T> create(BiConsumer<Long, SubscriberWithContext<T, C>> requestConsumer, Function<Subscriber<? super T>, C> contextFactory) {
        return PublisherFactory.create(requestConsumer, contextFactory, null);
    }

    public static <T, C> Publisher<T> create(BiConsumer<Long, SubscriberWithContext<T, C>> requestConsumer, Function<Subscriber<? super T>, C> contextFactory, Consumer<C> shutdownConsumer) {
        return new PublisherFactory<T, C>(requestConsumer, contextFactory, shutdownConsumer);
    }

    public static <T> Publisher<T> forEach(Consumer<SubscriberWithContext<T, Void>> requestConsumer) {
        return PublisherFactory.forEach(requestConsumer, null, null);
    }

    public static <T, C> Publisher<T> forEach(Consumer<SubscriberWithContext<T, C>> requestConsumer, Function<Subscriber<? super T>, C> contextFactory) {
        return PublisherFactory.forEach(requestConsumer, contextFactory, null);
    }

    public static <T, C> Publisher<T> forEach(Consumer<SubscriberWithContext<T, C>> requestConsumer, Function<Subscriber<? super T>, C> contextFactory, Consumer<C> shutdownConsumer) {
        Assert.notNull(requestConsumer, "A data producer must be provided");
        return PublisherFactory.create(new ForEachBiConsumer<T, C>(requestConsumer), contextFactory, shutdownConsumer);
    }

    protected PublisherFactory(BiConsumer<Long, SubscriberWithContext<T, C>> requestConsumer, Function<Subscriber<? super T>, C> contextFactory, Consumer<C> shutdownConsumer) {
        Assert.notNull(requestConsumer, "A data producer must be provided");
        this.requestConsumer = requestConsumer;
        this.contextFactory = contextFactory;
        this.shutdownConsumer = shutdownConsumer;
    }

    public void subscribe(Subscriber<? super T> subscriber) {
        try {
            Object context = this.contextFactory != null ? (Object)this.contextFactory.apply(subscriber) : null;
            subscriber.onSubscribe(new SubscriberProxy<T, Object>(subscriber, context, this.requestConsumer, (Consumer<Object>)this.shutdownConsumer));
        }
        catch (Throwable throwable) {
            Exceptions.throwIfFatal(throwable);
            subscriber.onError(throwable);
        }
    }

    private static final class ForEachBiConsumer<T, C>
    implements BiConsumer<Long, SubscriberWithContext<T, C>> {
        private final Consumer<SubscriberWithContext<T, C>> requestConsumer;
        private volatile long pending = 0L;
        private static final AtomicLongFieldUpdater<ForEachBiConsumer> PENDING_UPDATER = AtomicLongFieldUpdater.newUpdater(ForEachBiConsumer.class, "pending");

        public ForEachBiConsumer(Consumer<SubscriberWithContext<T, C>> requestConsumer) {
            this.requestConsumer = requestConsumer;
        }

        @Override
        public void accept(Long n, SubscriberWithContext<T, C> sub) {
            long afterAdd;
            if (this.pending == Long.MAX_VALUE) {
                return;
            }
            long demand = n;
            if (!PENDING_UPDATER.compareAndSet(this, 0L, demand) && (afterAdd = PENDING_UPDATER.addAndGet(this, demand)) != demand) {
                if (afterAdd < 0L) {
                    if (!PENDING_UPDATER.compareAndSet(this, afterAdd, Long.MAX_VALUE)) {
                        return;
                    }
                } else {
                    return;
                }
            }
            do {
                long requestCursor = 0L;
                while (!(requestCursor++ >= demand && demand != Long.MAX_VALUE || sub.isCancelled())) {
                    this.requestConsumer.accept(sub);
                }
            } while ((demand = PENDING_UPDATER.addAndGet(this, -demand)) > 0L && !sub.isCancelled());
        }
    }

    private static final class SubscriberProxy<T, C>
    extends SubscriberWithContext<T, C>
    implements Subscription {
        private final BiConsumer<Long, SubscriberWithContext<T, C>> requestConsumer;
        private final Consumer<C> shutdownConsumer;

        public SubscriberProxy(Subscriber<? super T> subscriber, C context, BiConsumer<Long, SubscriberWithContext<T, C>> requestConsumer, Consumer<C> shutdownConsumer) {
            super(context, subscriber);
            this.requestConsumer = requestConsumer;
            this.shutdownConsumer = shutdownConsumer;
        }

        public void request(long n) {
            if (this.isCancelled()) {
                return;
            }
            if (n <= 0L) {
                this.onError(SpecificationExceptions.spec_3_09_exception(n));
                return;
            }
            try {
                this.requestConsumer.accept(n, this);
            }
            catch (Throwable t) {
                this.onError(t);
            }
        }

        public void cancel() {
            if (TERMINAL_UPDATER.compareAndSet(this, 0, 1)) {
                this.doShutdown();
            }
        }

        @Override
        public void onError(Throwable t) {
            if (TERMINAL_UPDATER.compareAndSet(this, 0, 1)) {
                this.doShutdown();
                this.subscriber.onError(t);
            }
        }

        @Override
        public void onComplete() {
            if (TERMINAL_UPDATER.compareAndSet(this, 0, 1)) {
                this.doShutdown();
                try {
                    this.subscriber.onComplete();
                }
                catch (Throwable t) {
                    this.subscriber.onError(t);
                }
            }
        }

        private void doShutdown() {
            if (this.shutdownConsumer == null) {
                return;
            }
            try {
                this.shutdownConsumer.accept(this.context);
            }
            catch (Throwable t) {
                this.subscriber.onError(t);
            }
        }

        @Override
        public void onSubscribe(Subscription s) {
            throw new UnsupportedOperationException(" the delegate subscriber is already subscribed");
        }
    }
}

