/*
 * Decompiled with CFR 0.152.
 */
package reactor.core.reactivestreams;

import java.util.concurrent.atomic.AtomicLong;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import reactor.Environment;
import reactor.core.Dispatcher;
import reactor.core.reactivestreams.SubscriptionWithContext;
import reactor.core.support.Assert;
import reactor.core.support.Exceptions;
import reactor.core.support.NonBlocking;
import reactor.fn.BiConsumer;
import reactor.fn.Consumer;
import reactor.fn.Function;

public class SubscriberFactory<T, C>
implements Subscriber<T>,
NonBlocking,
Subscription {
    private static final Function<Subscription, Void> UNBOUNDED_REQUEST_FUNCTION = new Function<Subscription, Void>(){

        @Override
        public Void apply(Subscription subscription) {
            subscription.request(Long.MAX_VALUE);
            return null;
        }
    };
    protected final Function<Subscription, C> subscriptionHandler;
    protected final BiConsumer<T, SubscriptionWithContext<C>> dataConsumer;
    protected final BiConsumer<Throwable, C> errorConsumer;
    protected final Consumer<C> completeConsumer;
    private SubscriptionWithContext<C> subscriptionWithContext;

    public static <T> Subscriber<T> create(final Consumer<Subscription> subscriptionHandler) {
        return SubscriberFactory.create(new Function<Subscription, Void>(){

            @Override
            public Void apply(Subscription subscription) {
                subscriptionHandler.accept(subscription);
                return null;
            }
        }, null, null, null);
    }

    public static <T, C> Subscriber<T> create(Function<Subscription, C> subscriptionHandler, BiConsumer<T, SubscriptionWithContext<C>> dataConsumer) {
        return SubscriberFactory.create(subscriptionHandler, dataConsumer, null, null);
    }

    public static <T, C> Subscriber<T> create(Function<Subscription, C> subscriptionHandler, BiConsumer<T, SubscriptionWithContext<C>> dataConsumer, BiConsumer<Throwable, C> errorConsumer) {
        return SubscriberFactory.create(subscriptionHandler, dataConsumer, errorConsumer, null);
    }

    public static <T> Subscriber<T> unbounded() {
        return SubscriberFactory.unbounded(null, null, null);
    }

    public static <T> Subscriber<T> unbounded(BiConsumer<T, SubscriptionWithContext<Void>> dataConsumer) {
        return SubscriberFactory.unbounded(dataConsumer, null, null);
    }

    public static <T> Subscriber<T> unbounded(BiConsumer<T, SubscriptionWithContext<Void>> dataConsumer, Consumer<Throwable> errorConsumer) {
        return SubscriberFactory.unbounded(dataConsumer, errorConsumer, null);
    }

    public static <T> Subscriber<T> unbounded(BiConsumer<T, SubscriptionWithContext<Void>> dataConsumer, final Consumer<Throwable> errorConsumer, Consumer<Void> completeConsumer) {
        return SubscriberFactory.create(UNBOUNDED_REQUEST_FUNCTION, dataConsumer, errorConsumer != null ? new BiConsumer<Throwable, Void>(){

            @Override
            public void accept(Throwable throwable, Void aVoid) {
                errorConsumer.accept(throwable);
            }
        } : null, completeConsumer);
    }

    public static <T, C> Subscriber<T> create(Function<Subscription, C> subscriptionHandler, BiConsumer<T, SubscriptionWithContext<C>> dataConsumer, BiConsumer<Throwable, C> errorConsumer, Consumer<C> completeConsumer) {
        return new SubscriberFactory<T, C>(dataConsumer, subscriptionHandler, errorConsumer, completeConsumer);
    }

    protected SubscriberFactory(BiConsumer<T, SubscriptionWithContext<C>> dataConsumer, Function<Subscription, C> subscriptionHandler, BiConsumer<Throwable, C> errorConsumer, Consumer<C> completeConsumer) {
        Assert.notNull(subscriptionHandler, "A subscription handler must be provided");
        this.dataConsumer = dataConsumer;
        this.subscriptionHandler = subscriptionHandler;
        this.errorConsumer = errorConsumer;
        this.completeConsumer = completeConsumer;
    }

    public void onSubscribe(Subscription s) {
        if (s == null) {
            throw new NullPointerException("Spec 2.13: Signal cannot be null");
        }
        try {
            if (this.subscriptionWithContext != null) {
                s.cancel();
                return;
            }
            final AtomicLong proxyRequest = new AtomicLong();
            C context = this.subscriptionHandler.apply(new Subscription(){

                public void request(long n) {
                    if (SubscriberFactory.this.subscriptionWithContext == null && proxyRequest.get() != Long.MIN_VALUE) {
                        proxyRequest.addAndGet(n);
                    } else {
                        SubscriberFactory.this.subscriptionWithContext.request(n);
                    }
                }

                public void cancel() {
                    if (SubscriberFactory.this.subscriptionWithContext == null) {
                        proxyRequest.set(Long.MIN_VALUE);
                    } else {
                        SubscriberFactory.this.subscriptionWithContext.cancel();
                    }
                }
            });
            this.subscriptionWithContext = SubscriptionWithContext.create(s, context);
            if (proxyRequest.compareAndSet(Long.MIN_VALUE, 0L)) {
                this.subscriptionWithContext.cancel();
            } else if (proxyRequest.get() > 0L) {
                this.subscriptionWithContext.request(proxyRequest.get());
            }
        }
        catch (Throwable throwable) {
            Exceptions.throwIfFatal(throwable);
            this.onError(throwable);
        }
    }

    public void onNext(T t) {
        if (t == null) {
            throw new NullPointerException("Spec 2.13: Signal cannot be null");
        }
        if (this.dataConsumer != null) {
            try {
                this.dataConsumer.accept(t, this.subscriptionWithContext);
            }
            catch (Throwable error) {
                this.onError(error);
            }
        }
    }

    public void onError(Throwable t) {
        if (this.errorConsumer != null) {
            this.errorConsumer.accept(t, this.subscriptionWithContext != null ? (Object)this.subscriptionWithContext.context : null);
        } else if (Environment.alive()) {
            Environment.get().routeError(t);
        }
    }

    public void onComplete() {
        if (this.completeConsumer != null) {
            try {
                this.completeConsumer.accept(this.subscriptionWithContext != null ? (Object)this.subscriptionWithContext.context : null);
            }
            catch (Throwable t) {
                this.onError(t);
            }
        }
    }

    @Override
    public boolean isReactivePull(Dispatcher dispatcher, long producerCapacity) {
        return false;
    }

    @Override
    public long getCapacity() {
        return Long.MAX_VALUE;
    }

    public void request(long n) {
        if (this.subscriptionWithContext != null) {
            // empty if block
        }
    }

    public void cancel() {
        if (this.subscriptionWithContext != null) {
            // empty if block
        }
    }
}

