/*
 * Decompiled with CFR 0.152.
 */
package reactor.io.codec;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.support.Assert;
import reactor.fn.Consumer;
import reactor.fn.Function;
import reactor.io.buffer.Buffer;
import reactor.io.codec.Codec;
import reactor.io.codec.LengthFieldCodec;

public abstract class SerializationCodec<E, IN, OUT>
extends Codec<Buffer, IN, OUT> {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final Map<String, Class<IN>> types = new ConcurrentHashMap<String, Class<IN>>();
    private final E engine;
    private final boolean lengthFieldFraming;
    private final Codec<Buffer, IN, OUT> encoder;

    protected SerializationCodec(E engine, boolean lengthFieldFraming) {
        this.engine = engine;
        this.lengthFieldFraming = lengthFieldFraming;
        this.encoder = lengthFieldFraming ? new LengthFieldCodec(new DelegateCodec()) : new DelegateCodec();
    }

    @Override
    public Function<Buffer, IN> decoder(Consumer<IN> next) {
        if (this.lengthFieldFraming) {
            return new LengthFieldCodec(new DelegateCodec()).decoder(next);
        }
        return new DelegateCodec().decoder(next);
    }

    @Override
    public Buffer apply(OUT out) {
        return (Buffer)this.encoder.apply(out);
    }

    protected E getEngine() {
        return this.engine;
    }

    protected abstract Function<byte[], IN> deserializer(E var1, Class<IN> var2, Consumer<IN> var3);

    protected abstract Function<OUT, byte[]> serializer(E var1);

    private String readTypeName(Buffer buffer) {
        int len = buffer.readInt();
        Assert.isTrue(buffer.remaining() > len, "Incomplete buffer. Must contain " + len + " bytes, " + "but only " + buffer.remaining() + " were found.");
        byte[] bytes = new byte[len];
        buffer.read(bytes);
        return new String(bytes);
    }

    private Buffer writeTypeName(Class<?> type, byte[] bytes) {
        String typeName = type.getName();
        int len = typeName.length();
        Buffer buffer = new Buffer(4 + len + bytes.length, true);
        return buffer.append(len).append(typeName).append(bytes).flip();
    }

    public Class<IN> readType(Buffer buffer) {
        String typeName = this.readTypeName(buffer);
        return this.getType(typeName);
    }

    private Class<IN> getType(String name) {
        Class<Object> type = this.types.get(name);
        if (null == type) {
            try {
                type = Class.forName(name);
            }
            catch (ClassNotFoundException e) {
                throw new IllegalArgumentException(e.getMessage(), e);
            }
            this.types.put(name, type);
        }
        return type;
    }

    private class DelegateCodec
    extends Codec<Buffer, IN, OUT> {
        final Function<OUT, byte[]> fn;

        private DelegateCodec() {
            this.fn = SerializationCodec.this.serializer(SerializationCodec.this.engine);
        }

        @Override
        public Function<Buffer, IN> decoder(final Consumer<IN> next) {
            return new Function<Buffer, IN>(){

                @Override
                public IN apply(Buffer buffer) {
                    try {
                        Class clazz = SerializationCodec.this.readType(buffer);
                        byte[] bytes = buffer.asBytes();
                        buffer.position(buffer.limit());
                        return SerializationCodec.this.deserializer(SerializationCodec.this.engine, clazz, next).apply(bytes);
                    }
                    catch (RuntimeException e) {
                        if (SerializationCodec.this.log.isErrorEnabled()) {
                            SerializationCodec.this.log.error("Could not decode " + buffer, (Throwable)e);
                        }
                        throw e;
                    }
                }
            };
        }

        @Override
        public Buffer apply(OUT o) {
            try {
                return SerializationCodec.this.writeTypeName(o.getClass(), this.fn.apply(o));
            }
            catch (RuntimeException e) {
                if (SerializationCodec.this.log.isErrorEnabled()) {
                    SerializationCodec.this.log.error("Could not encode " + o, (Throwable)e);
                }
                throw e;
            }
        }
    }
}

