/*
 * Decompiled with CFR 0.152.
 */
package reactor.io.codec;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.util.List;
import reactor.fn.Consumer;
import reactor.fn.Function;
import reactor.io.buffer.Buffer;
import reactor.io.codec.Codec;

public class StringCodec
extends Codec<Buffer, String, String> {
    private final Charset charset;

    public StringCodec() {
        this(null, Charset.forName("UTF-8"));
    }

    public StringCodec(Charset charset) {
        this(null, charset);
    }

    public StringCodec(Byte delimiter) {
        this(delimiter, Charset.forName("UTF-8"));
    }

    public StringCodec(Byte delimiter, Charset charset) {
        super(delimiter);
        this.charset = charset;
    }

    @Override
    public Function<String, Buffer> encoder() {
        return new StringEncoder();
    }

    @Override
    public Function<Buffer, String> decoder(Consumer<String> next) {
        return new StringDecoder(next);
    }

    @Override
    protected String doBufferDecode(Buffer buffer) {
        return this.decode(buffer, this.charset.newDecoder());
    }

    @Override
    public Buffer apply(String s) {
        return this.encode(s, this.charset.newEncoder());
    }

    protected String decode(Buffer buffer, CharsetDecoder charsetDecoder) {
        try {
            return charsetDecoder.decode(buffer.byteBuffer()).toString();
        }
        catch (CharacterCodingException e) {
            throw new IllegalStateException(e);
        }
    }

    protected Buffer encode(String s, CharsetEncoder charsetEncoder) {
        try {
            ByteBuffer bb = charsetEncoder.encode(CharBuffer.wrap(s));
            if (this.delimiter != null) {
                return this.addDelimiterIfAny(new Buffer().append(bb));
            }
            return new Buffer(bb);
        }
        catch (CharacterCodingException e) {
            throw new IllegalStateException(e);
        }
    }

    public final class StringEncoder
    implements Function<String, Buffer> {
        private final CharsetEncoder encoder;

        public StringEncoder() {
            this.encoder = StringCodec.this.charset.newEncoder();
        }

        @Override
        public Buffer apply(String s) {
            return StringCodec.this.encode(s, this.encoder);
        }
    }

    private class StringDecoder
    implements Function<Buffer, String> {
        private final CharsetDecoder decoder;
        private final Consumer<String> next;

        private StringDecoder(Consumer<String> next) {
            this.next = next;
            this.decoder = StringCodec.this.charset.newDecoder();
        }

        @Override
        public String apply(Buffer buffer) {
            if (StringCodec.this.delimiter != null) {
                List<Buffer.View> views = buffer.split(StringCodec.this.delimiter.byteValue());
                int viewCount = views.size();
                if (viewCount == 0) {
                    return Codec.invokeCallbackOrReturn(this.next, StringCodec.this.doBufferDecode(buffer));
                }
                for (Buffer.View view : views) {
                    String in = Codec.invokeCallbackOrReturn(this.next, StringCodec.this.decode(view.get(), this.decoder));
                    if (in == null) continue;
                    return in;
                }
                return null;
            }
            return Codec.invokeCallbackOrReturn(this.next, StringCodec.this.decode(buffer, this.decoder));
        }
    }
}

