/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.opsmgmt.vcops.impl;

import com.vmware.opsmgmt.vcops.VcopsExtensionInfoRetriever;
import com.vmware.opsmgmt.vcops.VcopsPermissionChecker;
import com.vmware.opsmgmt.vcops.VcopsVappInfoRetriever;
import com.vmware.opsmgmt.vcops.model.VCenterData;
import com.vmware.opsmgmt.vcops.model.VcopsInstallationMetadata;
import com.vmware.opsmgmt.vcops.model.VcopsVappConnectionData;
import com.vmware.opsmgmt.vcops.util.VcopsInstallerUtil;
import com.vmware.vim.binding.vim.Extension;
import com.vmware.vim.binding.vim.ServiceInstanceContent;
import com.vmware.vim.binding.vim.option.OptionManager;
import com.vmware.vim.binding.vim.option.OptionValue;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.data.query.DataProviderAdapter;
import com.vmware.vise.data.query.PropertyValue;
import com.vmware.vise.data.query.RequestSpec;
import com.vmware.vise.data.query.Response;
import com.vmware.vise.data.query.ResultItem;
import com.vmware.vise.data.query.ResultSet;
import com.vmware.vise.data.query.type;
import com.vmware.vise.util.StringUtil;
import com.vmware.vise.util.client.configuration.ConfigurationService;
import com.vmware.vise.vim.commons.ManagedObjectUtil;
import com.vmware.vise.vim.commons.VcServiceUtil;
import com.vmware.vise.vim.commons.VimSessionUtil;
import com.vmware.vise.vim.commons.extensions.LinkedVcGroupRegistry;
import com.vmware.vise.vim.commons.vcservice.LinkedVcGroup;
import com.vmware.vise.vim.commons.vcservice.VcService;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashSet;
import java.util.LinkedList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@type(value="VcopsInstallationMetadata")
public class VcopsDataAdapter
implements DataProviderAdapter {
    private static final Log _logger = LogFactory.getLog(VcopsDataAdapter.class);
    private static final String KEY_VCENTER_UPDATEVERSION = "Misc.vCenterServerUpdateLevel";
    private static final String VCOPS_60_URL = "https://%s/vcops-web-ent";
    private static final String VCOPS_60_ADMIN_URL = "https://%s/vcops-web-ent/index.action#/administration/adapter-instances";
    private VcopsExtensionInfoRetriever _extensionInfoRetriever;
    private VcopsVappInfoRetriever _vcopsVappInfoRetriever;
    private VcopsPermissionChecker _vcopsPermissionChecker;
    private ConfigurationService _configurationService;
    private VcopsInstallerUtil _vcopsInstallerUtil;

    public void setExtensionInfoRetriever(VcopsExtensionInfoRetriever vcopsExtensionInfoRetriever) {
        this._extensionInfoRetriever = vcopsExtensionInfoRetriever;
    }

    public void setVcopsVappInfoRetriver(VcopsVappInfoRetriever vcopsVappInfoRetriever) {
        this._vcopsVappInfoRetriever = vcopsVappInfoRetriever;
    }

    public void setVcopsPermissionChecker(VcopsPermissionChecker vcopsPermissionChecker) {
        this._vcopsPermissionChecker = vcopsPermissionChecker;
    }

    public void setConfigurationService(ConfigurationService configurationService) {
        this._configurationService = configurationService;
    }

    public void setvcopsInstallerUtil(VcopsInstallerUtil vcopsInstallerUtil) {
        this._vcopsInstallerUtil = vcopsInstallerUtil;
    }

    public VcopsInstallationMetadata getInstallationMetadata() {
        VcopsInstallationMetadata vcopsInstallationMetadata = new VcopsInstallationMetadata();
        try {
            LinkedVcGroup[] linkedVcGroupArray = this.getAllLinkedVcGroup();
            VcopsVappConnectionData[] vcopsVappConnectionDataArray = this.getVcopsInstalledInLinkedGroup(linkedVcGroupArray);
            vcopsInstallationMetadata.isVcopsRegistered = vcopsVappConnectionDataArray.length > 0;
            vcopsInstallationMetadata.registeredVcopsConnectionData = vcopsVappConnectionDataArray;
            vcopsInstallationMetadata.vappConnectionData = this._vcopsVappInfoRetriever.getVcopsVapps();
            vcopsInstallationMetadata.linkedVcData = this.getLinkedVcGroupData(linkedVcGroupArray);
            if (linkedVcGroupArray.length == 1) {
                ServiceInstanceContent serviceInstanceContent = linkedVcGroupArray[0].getStartUpVcService().getServiceInstanceContent();
                ManagedObjectReference managedObjectReference = serviceInstanceContent.getRootFolder();
                vcopsInstallationMetadata.hasExtensionPermissions = this._vcopsPermissionChecker.getHasVcOpsInstallPermissions(managedObjectReference);
                vcopsInstallationMetadata.myVmwareURL = this._vcopsInstallerUtil.getMyVmwareURL(this._configurationService);
            } else {
                vcopsInstallationMetadata.isVcopsRegistered = false;
            }
        }
        catch (Throwable throwable) {
            _logger.error((Object)"Failed to retrieve VcopsInstallationMetadata information. ", throwable);
            vcopsInstallationMetadata.isVcopsRegistered = false;
        }
        return vcopsInstallationMetadata;
    }

    public Response getData(RequestSpec requestSpec) throws Exception {
        PropertyValue propertyValue = new PropertyValue();
        propertyValue.propertyName = "VcopsInstallationMetadata";
        propertyValue.value = this.getInstallationMetadata();
        ResultItem resultItem = new ResultItem();
        resultItem.properties = new PropertyValue[]{propertyValue};
        resultItem.resourceObject = VcopsInstallationMetadata.class.getName();
        ResultSet resultSet = new ResultSet();
        resultSet.totalMatchedObjectCount = 1;
        resultSet.queryName = requestSpec.querySpec[0].name;
        resultSet.items = new ResultItem[]{resultItem};
        Response response = new Response();
        response.resultSet = new ResultSet[]{resultSet};
        return response;
    }

    private VcopsVappConnectionData getVcopsVappConnectionData(String string, String string2, String string3) throws MalformedURLException {
        VcopsVappConnectionData vcopsVappConnectionData = null;
        if (!StringUtil.isNullOrEmpty((String)string)) {
            if (string.lastIndexOf("/") != -1 && string.lastIndexOf(".") == -1) {
                _logger.warn((Object)("Unable to retrieve the vcopURL from URL: " + string));
            } else {
                _logger.info((Object)("Current vC Ops version is: " + string3));
                int n = Integer.parseInt(string3.split("\\.")[0]);
                if (n < 6) {
                    String string4 = string.substring(0, string.lastIndexOf("/"));
                    String string5 = string4.substring(0, string4.lastIndexOf("/")) + "/" + "admin";
                    if (string4.lastIndexOf("//") == -1) {
                        return null;
                    }
                    String string6 = string4.substring(string4.lastIndexOf("//") + 2, string4.lastIndexOf("/"));
                    vcopsVappConnectionData = new VcopsVappConnectionData();
                    vcopsVappConnectionData.vCopsAdminURL = string5;
                    vcopsVappConnectionData.vCopsURL = string4;
                    vcopsVappConnectionData.uiVmIp = string6;
                    vcopsVappConnectionData.serverGuid = string2;
                    vcopsVappConnectionData.isVappPoweredOn = true;
                } else {
                    URL uRL = new URL(string);
                    String string7 = uRL.getHost();
                    vcopsVappConnectionData = new VcopsVappConnectionData();
                    vcopsVappConnectionData.vCopsAdminURL = String.format(VCOPS_60_ADMIN_URL, string7);
                    vcopsVappConnectionData.vCopsURL = String.format(VCOPS_60_URL, string7);
                    vcopsVappConnectionData.uiVmIp = string7;
                    vcopsVappConnectionData.serverGuid = string2;
                    vcopsVappConnectionData.isVappPoweredOn = true;
                }
            }
        }
        return vcopsVappConnectionData;
    }

    private LinkedVcGroup[] getAllLinkedVcGroup() {
        LinkedVcGroupRegistry linkedVcGroupRegistry = VimSessionUtil.getLinkedVcGroupRegistry();
        LinkedVcGroup[] linkedVcGroupArray = linkedVcGroupRegistry.getLinkedVcGroups();
        return linkedVcGroupArray;
    }

    private VcopsVappConnectionData[] getVcopsInstalledInLinkedGroup(LinkedVcGroup[] linkedVcGroupArray) {
        LinkedList<VcopsVappConnectionData> linkedList = new LinkedList<VcopsVappConnectionData>();
        HashSet<String> hashSet = new HashSet<String>();
        for (LinkedVcGroup linkedVcGroup : linkedVcGroupArray) {
            for (VcService vcService : linkedVcGroup.getVcServices()) {
                ServiceInstanceContent serviceInstanceContent = vcService.getServiceInstanceContent();
                ManagedObjectReference managedObjectReference = serviceInstanceContent.getRootFolder();
                String string = managedObjectReference.getServerGuid();
                try {
                    String string2;
                    Extension extension = this._extensionInfoRetriever.getExtension(string);
                    if (extension == null || hashSet.contains(string2 = this.getVcopsInstalledURLs(extension))) continue;
                    assert (extension.client.length > 0);
                    String string3 = extension.client[0].version;
                    VcopsVappConnectionData vcopsVappConnectionData = this.getVcopsVappConnectionData(string2, string, string3);
                    if (vcopsVappConnectionData == null) continue;
                    linkedList.add(vcopsVappConnectionData);
                    hashSet.add(string2);
                }
                catch (Exception exception) {
                    _logger.error((Object)("Unable to retrieve vCOps registration data for " + string), (Throwable)exception);
                }
            }
        }
        return linkedList.toArray(new VcopsVappConnectionData[linkedList.size()]);
    }

    private VCenterData[] getLinkedVcGroupData(LinkedVcGroup[] linkedVcGroupArray) {
        LinkedList<VCenterData> linkedList = new LinkedList<VCenterData>();
        for (LinkedVcGroup linkedVcGroup : linkedVcGroupArray) {
            for (VcService vcService : linkedVcGroup.getVcServices()) {
                String string;
                VCenterData vCenterData = new VCenterData();
                ServiceInstanceContent serviceInstanceContent = vcService.getServiceInstanceContent();
                ManagedObjectReference managedObjectReference = serviceInstanceContent.getRootFolder();
                vCenterData.serverGuid = string = managedObjectReference.getServerGuid();
                vCenterData.vCenterName = VcServiceUtil.getServiceName((String)string);
                vCenterData.vCenterVersion = serviceInstanceContent.getAbout().getVersion() + "." + this.getUpdateVersionString(serviceInstanceContent);
                linkedList.add(vCenterData);
            }
        }
        return linkedList.toArray(new VCenterData[linkedList.size()]);
    }

    private String getUpdateVersionString(ServiceInstanceContent serviceInstanceContent) {
        try {
            OptionManager optionManager = (OptionManager)ManagedObjectUtil.getManagedObject((ManagedObjectReference)serviceInstanceContent.setting);
            OptionValue[] optionValueArray = new OptionValue[]{};
            OptionValue optionValue = null;
            for (OptionValue optionValue2 : optionValueArray = optionManager.getSetting()) {
                if (!KEY_VCENTER_UPDATEVERSION.equals(optionValue2.key)) continue;
                optionValue = optionValue2;
                break;
            }
            if (optionValue != null) {
                return optionValue.value.toString();
            }
            _logger.warn((Object)"Unable to detect VcenterServer update version. Return: \"0\"");
        }
        catch (Exception exception) {
            _logger.warn((Object)"Unable to detect VcenterServer update version. Return: \"0\"", (Throwable)exception);
        }
        return "0";
    }

    private String getVcopsInstalledURLs(Extension extension) {
        String string = "";
        try {
            Extension.ServerInfo[] serverInfoArray = extension.getServer();
            if (serverInfoArray == null || serverInfoArray.length == 0) {
                _logger.error((Object)("Missing or empty ServerInfo found in the VCOps Extension for " + extension.key));
            }
            assert (serverInfoArray.length == 1);
            string = serverInfoArray[0].url;
        }
        catch (Exception exception) {
            _logger.error((Object)"Unable to retrieve vCops installed URL", (Throwable)exception);
        }
        return string;
    }
}

