/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.opsmgmt.vcops.impl;

import com.vmware.opsmgmt.vcops.ExtensionRetriever;
import com.vmware.opsmgmt.vcops.VcopsExtensionInfoRetriever;
import com.vmware.vim.binding.vim.Extension;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class VcopsExtensionInfoRetrieverImpl
implements VcopsExtensionInfoRetriever {
    private static final String VCOPS_EXTENSION_NAME = "com.vmware.vcops";
    private static final Log _logger = LogFactory.getLog(VcopsExtensionInfoRetrieverImpl.class);
    private ExtensionRetriever _extensionRetriever;

    public void setExtensionRetriever(ExtensionRetriever extensionRetriever) {
        this._extensionRetriever = extensionRetriever;
    }

    @Override
    public Extension getExtension(String string) throws Exception {
        return this._extensionRetriever.getExtension(string, VCOPS_EXTENSION_NAME);
    }

    @Override
    public Extension.ServerInfo getServerInfo(String string) throws Exception {
        Extension extension = this.getExtension(string);
        if (extension == null) {
            _logger.error((Object)"There is no Extension registered for vCOps product!");
            throw new Exception("There is no Extension registered for VCOps product!");
        }
        Extension.ServerInfo[] serverInfoArray = extension.server;
        if (serverInfoArray == null || serverInfoArray.length == 0) {
            _logger.error((Object)("Missing or empty ServerInfo found in the VCOps Extension for VC with GUID=" + string));
            throw new Exception("The VCOps Extension registration in VC with GUID=" + string + " is invalid! There is no serverInfo information in it!");
        }
        assert (serverInfoArray.length == 1);
        return serverInfoArray[0];
    }

    @Override
    public boolean hasVcopsExtension(String string) throws Exception {
        return this.getExtension(string) != null;
    }
}

