/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.opsmgmt.vcops.util;

import com.vmware.vise.util.StringUtil;
import com.vmware.vise.util.client.configuration.ConfigurationService;
import com.vmware.vise.util.i18n.ResourceUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class VcopsInstallerUtil {
    public static final String ADMIN_URL_PATH = "admin";
    public static final String VCOP_VAPP_NAMES = "vcopsVappNames";
    public static final String VCOPS_VAPP_KEY = "vappNames";
    public static final String SEPARATOR = "\\,";
    private static final String MY_VMWARE_URL_KEY = "myvmware.com.url";
    private static final String MY_VMWARE_URL_DEFAULT = "https://my.vmware.com/ovf/auth?baseProduct={0}&baseVersion={1}&installProduct={2}";
    private static final Log _logger = LogFactory.getLog(VcopsInstallerUtil.class);
    private String[] vCopsNamesToLowerCase;

    public void init() {
        this.vCopsNamesToLowerCase = this.convertToLowerCase(this.getVcopsVappNames());
    }

    public String getMyVmwareURL(ConfigurationService configurationService) {
        String string = configurationService.getProperty(MY_VMWARE_URL_KEY);
        if (StringUtil.isNullOrEmpty((String)string)) {
            _logger.warn((Object)"Inable to retrieve from webclient.properties the value for key: myvmware.com.url. Default value will be used: https://my.vmware.com/ovf/auth?baseProduct={0}&baseVersion={1}&installProduct={2}");
            return MY_VMWARE_URL_DEFAULT;
        }
        return string;
    }

    public String[] getVcopsVappNames() {
        String string = ResourceUtil.getString((String)VCOP_VAPP_NAMES, (String)VCOPS_VAPP_KEY, (ClassLoader)VcopsInstallerUtil.class.getClassLoader());
        return string.split(SEPARATOR);
    }

    public boolean hasVcopsName(String string) {
        for (String string2 : this.vCopsNamesToLowerCase) {
            if (!string.toLowerCase().contains(string2)) continue;
            return true;
        }
        return false;
    }

    private String[] convertToLowerCase(String[] stringArray) {
        String[] stringArray2 = new String[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray2[i] = stringArray[i].toLowerCase();
        }
        return stringArray2;
    }
}

