/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml2.binding.encoding;

import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.List;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.opensaml.Configuration;
import org.opensaml.common.SAMLObject;
import org.opensaml.common.binding.SAMLMessageContext;
import org.opensaml.common.binding.artifact.AbstractSAMLArtifact;
import org.opensaml.common.binding.artifact.SAMLArtifactMap;
import org.opensaml.saml2.binding.artifact.AbstractSAML2Artifact;
import org.opensaml.saml2.binding.artifact.SAML2ArtifactBuilder;
import org.opensaml.saml2.binding.artifact.SAML2ArtifactType0004;
import org.opensaml.saml2.binding.encoding.BaseSAML2MessageEncoder;
import org.opensaml.util.URLBuilder;
import org.opensaml.ws.message.MessageContext;
import org.opensaml.ws.message.encoder.MessageEncodingException;
import org.opensaml.ws.transport.http.HTTPOutTransport;
import org.opensaml.xml.io.MarshallingException;
import org.opensaml.xml.util.Pair;
import org.owasp.esapi.ESAPI;
import org.owasp.esapi.Encoder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HTTPArtifactEncoder
extends BaseSAML2MessageEncoder {
    private final Logger log = LoggerFactory.getLogger(HTTPArtifactEncoder.class);
    private boolean postEncoding = false;
    private VelocityEngine velocityEngine;
    private String velocityTemplateId;
    private SAMLArtifactMap artifactMap;
    private byte[] defaultArtifactType;

    public HTTPArtifactEncoder(VelocityEngine engine, String template, SAMLArtifactMap map) {
        this.velocityEngine = engine;
        this.velocityTemplateId = template;
        this.artifactMap = map;
        this.defaultArtifactType = SAML2ArtifactType0004.TYPE_CODE;
    }

    public String getBindingURI() {
        return "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact";
    }

    public boolean isPostEncoding() {
        return this.postEncoding;
    }

    public void setPostEncoding(boolean post) {
        this.postEncoding = post;
    }

    public boolean providesMessageConfidentiality(MessageContext messageContext) throws MessageEncodingException {
        return false;
    }

    public boolean providesMessageIntegrity(MessageContext messageContext) throws MessageEncodingException {
        return false;
    }

    protected void doEncode(MessageContext messageContext) throws MessageEncodingException {
        if (!(messageContext instanceof SAMLMessageContext)) {
            this.log.error("Invalid message context type, this encoder only support SAMLMessageContext");
            throw new MessageEncodingException("Invalid message context type, this encoder only support SAMLMessageContext");
        }
        if (!(messageContext.getOutboundMessageTransport() instanceof HTTPOutTransport)) {
            this.log.error("Invalid outbound message transport type, this encoder only support HTTPOutTransport");
            throw new MessageEncodingException("Invalid outbound message transport type, this encoder only support HTTPOutTransport");
        }
        SAMLMessageContext artifactContext = (SAMLMessageContext)messageContext;
        HTTPOutTransport outTransport = (HTTPOutTransport)artifactContext.getOutboundMessageTransport();
        outTransport.setCharacterEncoding("UTF-8");
        if (this.postEncoding) {
            this.postEncode(artifactContext, outTransport);
        } else {
            this.getEncode(artifactContext, outTransport);
        }
    }

    protected void postEncode(SAMLMessageContext artifactContext, HTTPOutTransport outTransport) throws MessageEncodingException {
        this.log.debug("Performing HTTP POST SAML 2 artifact encoding");
        this.log.debug("Creating velocity context");
        VelocityContext context = new VelocityContext();
        Encoder esapiEncoder = ESAPI.encoder();
        String endpointURL = this.getEndpointURL(artifactContext).toString();
        String encodedEndpointURL = esapiEncoder.encodeForHTMLAttribute(endpointURL);
        this.log.debug("Setting action parameter to: '{}', encoded as '{}'", (Object)endpointURL, (Object)encodedEndpointURL);
        context.put("action", (Object)encodedEndpointURL);
        context.put("SAMLArt", (Object)this.buildArtifact(artifactContext).base64Encode());
        if (this.checkRelayState(artifactContext.getRelayState())) {
            String encodedRelayState = esapiEncoder.encodeForHTMLAttribute(artifactContext.getRelayState());
            this.log.debug("Setting RelayState parameter to: '{}', encoded as '{}'", (Object)artifactContext.getRelayState(), (Object)encodedRelayState);
            context.put("RelayState", (Object)encodedRelayState);
        }
        try {
            this.log.debug("Invoking velocity template");
            OutputStreamWriter outWriter = new OutputStreamWriter(outTransport.getOutgoingStream());
            this.velocityEngine.mergeTemplate(this.velocityTemplateId, "UTF-8", (Context)context, (Writer)outWriter);
        }
        catch (Exception e) {
            this.log.error("Error invoking velocity template to create POST form", (Throwable)e);
            throw new MessageEncodingException("Error creating output document", e);
        }
    }

    protected void getEncode(SAMLMessageContext artifactContext, HTTPOutTransport outTransport) throws MessageEncodingException {
        this.log.debug("Performing HTTP GET SAML 2 artifact encoding");
        URLBuilder urlBuilder = this.getEndpointURL(artifactContext);
        List<Pair<String, String>> params = urlBuilder.getQueryParams();
        AbstractSAML2Artifact artifact = this.buildArtifact(artifactContext);
        if (artifact == null) {
            this.log.error("Unable to build artifact for message to relying party");
            throw new MessageEncodingException("Unable to builder artifact for message to relying party");
        }
        params.add(new Pair<String, String>("SAMLart", artifact.base64Encode()));
        if (this.checkRelayState(artifactContext.getRelayState())) {
            params.add(new Pair<String, String>("RelayState", artifactContext.getRelayState()));
        }
        outTransport.sendRedirect(urlBuilder.buildURL());
    }

    protected AbstractSAML2Artifact buildArtifact(SAMLMessageContext artifactContext) throws MessageEncodingException {
        SAML2ArtifactBuilder artifactBuilder;
        if (artifactContext.getOutboundMessageArtifactType() != null) {
            artifactBuilder = Configuration.getSAML2ArtifactBuilderFactory().getArtifactBuilder(artifactContext.getOutboundMessageArtifactType());
        } else {
            artifactBuilder = Configuration.getSAML2ArtifactBuilderFactory().getArtifactBuilder(this.defaultArtifactType);
            artifactContext.setOutboundMessageArtifactType(this.defaultArtifactType);
        }
        Object artifact = artifactBuilder.buildArtifact(artifactContext);
        if (artifact == null) {
            this.log.error("Unable to build artifact for message to relying party");
            throw new MessageEncodingException("Unable to builder artifact for message to relying party");
        }
        String encodedArtifact = ((AbstractSAMLArtifact)artifact).base64Encode();
        try {
            this.artifactMap.put(encodedArtifact, artifactContext.getInboundMessageIssuer(), artifactContext.getOutboundMessageIssuer(), (SAMLObject)artifactContext.getOutboundSAMLMessage());
        }
        catch (MarshallingException e) {
            this.log.error("Unable to marshall assertion to be represented as an artifact", (Throwable)e);
            throw new MessageEncodingException("Unable to marshall assertion to be represented as an artifact", e);
        }
        return artifact;
    }
}

