/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.ws.soap.soap11.encoder;

import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import org.opensaml.ws.message.MessageContext;
import org.opensaml.ws.message.encoder.MessageEncodingException;
import org.opensaml.ws.message.handler.BaseHandlerChainAwareMessageEncoder;
import org.opensaml.ws.soap.common.SOAPObjectBuilder;
import org.opensaml.ws.soap.soap11.Body;
import org.opensaml.ws.soap.soap11.Envelope;
import org.opensaml.ws.transport.OutTransport;
import org.opensaml.xml.Configuration;
import org.opensaml.xml.XMLObjectBuilderFactory;
import org.opensaml.xml.util.XMLHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SOAP11Encoder
extends BaseHandlerChainAwareMessageEncoder {
    private final Logger log = LoggerFactory.getLogger(SOAP11Encoder.class);
    private SOAPObjectBuilder<Envelope> envBuilder;
    private SOAPObjectBuilder<Body> bodyBuilder;

    public SOAP11Encoder() {
        XMLObjectBuilderFactory builderFactory = Configuration.getBuilderFactory();
        this.envBuilder = (SOAPObjectBuilder)builderFactory.getBuilder(Envelope.DEFAULT_ELEMENT_NAME);
        this.bodyBuilder = (SOAPObjectBuilder)builderFactory.getBuilder(Body.DEFAULT_ELEMENT_NAME);
    }

    public boolean providesMessageConfidentiality(MessageContext messageContext) throws MessageEncodingException {
        return messageContext.getOutboundMessageTransport().isConfidential();
    }

    public boolean providesMessageIntegrity(MessageContext messageContext) throws MessageEncodingException {
        return messageContext.getOutboundMessageTransport().isIntegrityProtected();
    }

    protected void prepareMessageContext(MessageContext messageContext) throws MessageEncodingException {
        if (messageContext.getOutboundMessage() == null) {
            messageContext.setOutboundMessage(this.buildSOAPEnvelope(messageContext));
        }
    }

    protected void encodeToTransport(MessageContext messageContext) throws MessageEncodingException {
        Element envelopeElem = this.marshallMessage(messageContext.getOutboundMessage());
        this.preprocessTransport(messageContext);
        try {
            OutTransport outTransport = messageContext.getOutboundMessageTransport();
            OutputStreamWriter out = new OutputStreamWriter(outTransport.getOutgoingStream(), "UTF-8");
            XMLHelper.writeNode((Node)envelopeElem, out);
            ((Writer)out).flush();
        }
        catch (UnsupportedEncodingException e) {
            this.log.error("JVM does not support required UTF-8 encoding");
            throw new MessageEncodingException("JVM does not support required UTF-8 encoding");
        }
        catch (IOException e) {
            this.log.error("Unable to write message content to outbound stream", (Throwable)e);
            throw new MessageEncodingException("Unable to write message content to outbound stream", e);
        }
    }

    protected void preprocessTransport(MessageContext messageContext) throws MessageEncodingException {
    }

    protected Envelope buildSOAPEnvelope(MessageContext messageContext) {
        this.log.debug("Building SOAP envelope");
        Envelope envelope = this.envBuilder.buildObject();
        Body body = this.bodyBuilder.buildObject();
        envelope.setBody(body);
        return envelope;
    }
}

