/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.identity.websso.client;

import com.vmware.identity.websso.client.MessageData;
import com.vmware.identity.websso.client.MessageType;
import com.vmware.identity.websso.client.ValidationResult;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.joda.time.DateTime;

public class Message
implements Serializable {
    private static final long serialVersionUID = 1L;
    private MessageType type;
    private String id;
    private String relayState;
    private DateTime issueInstant;
    private String source;
    private String target;
    private String status;
    private String substatus;
    private String sessionIndex;
    private MessageData messageData;
    private Object tag;
    private List<Message> associatedMessages;
    private ValidationResult validationResult;

    protected Message() {
    }

    public Message(MessageType type, String id, String relayState, DateTime issueInstant, String source, String target, String status, String substatus, String sessionIndex, MessageData messageData, Object tag) {
        this.type = type;
        this.id = id;
        this.relayState = relayState;
        this.issueInstant = issueInstant;
        this.messageData = messageData;
        this.sessionIndex = sessionIndex;
        this.source = source;
        this.target = target;
        this.status = status;
        this.substatus = substatus;
        this.tag = tag;
        this.associatedMessages = new LinkedList<Message>();
        this.validationResult = null;
    }

    public MessageType getType() {
        return this.type;
    }

    public String getId() {
        return this.id;
    }

    public String getRelayState() {
        return this.relayState;
    }

    public DateTime getIssueInstant() {
        return this.issueInstant;
    }

    public String getSource() {
        return this.source;
    }

    public String getTarget() {
        return this.target;
    }

    public String getStatus() {
        return this.status;
    }

    public String getSubstatus() {
        return this.substatus;
    }

    public String getSessionIndex() {
        return this.sessionIndex;
    }

    public MessageData getMessageData() {
        return this.messageData;
    }

    public Object getTag() {
        return this.tag;
    }

    public void setTag(Object tag) {
        this.tag = tag;
    }

    public void addToAssociated(Message asMessage) {
        this.associatedMessages.add(asMessage);
    }

    public Collection<Message> getAssociatedMessages() {
        return Collections.unmodifiableCollection(this.associatedMessages);
    }

    public ValidationResult getValidationResult() {
        return this.validationResult;
    }

    public void setValidationResult(ValidationResult validationResult) {
        this.validationResult = validationResult;
    }
}

