/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.identity.websso.client;

import com.vmware.identity.websso.client.IDPConfiguration;
import com.vmware.identity.websso.client.MetadataSettings;
import com.vmware.identity.websso.client.SPConfiguration;
import com.vmware.identity.websso.client.SharedUtils;
import com.vmware.identity.websso.client.SignatureAlgorithm;
import com.vmware.identity.websso.client.SingleLogoutService;
import com.vmware.identity.websso.client.SingleSignOnService;
import com.vmware.identity.websso.client.SloRequestSettings;
import com.vmware.identity.websso.client.WebssoClientException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.Calendar;
import java.util.List;
import java.util.TimeZone;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.Inflater;
import java.util.zip.InflaterOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;
import org.joda.time.DateTime;
import org.opensaml.Configuration;
import org.opensaml.common.SAMLVersion;
import org.opensaml.common.SignableSAMLObject;
import org.opensaml.common.impl.SecureRandomIdentifierGenerator;
import org.opensaml.saml2.core.Assertion;
import org.opensaml.saml2.core.Conditions;
import org.opensaml.saml2.core.Issuer;
import org.opensaml.saml2.core.LogoutRequest;
import org.opensaml.saml2.core.LogoutResponse;
import org.opensaml.saml2.core.NameID;
import org.opensaml.saml2.core.Response;
import org.opensaml.saml2.core.SessionIndex;
import org.opensaml.saml2.core.Status;
import org.opensaml.saml2.core.StatusCode;
import org.opensaml.saml2.core.StatusMessage;
import org.opensaml.saml2.core.impl.IssuerBuilder;
import org.opensaml.saml2.core.impl.LogoutRequestBuilder;
import org.opensaml.saml2.core.impl.SessionIndexBuilder;
import org.opensaml.security.SAMLSignatureProfileValidator;
import org.opensaml.ws.transport.http.HTTPTransportUtils;
import org.opensaml.xml.ConfigurationException;
import org.opensaml.xml.XMLObject;
import org.opensaml.xml.io.Marshaller;
import org.opensaml.xml.io.MarshallingException;
import org.opensaml.xml.io.Unmarshaller;
import org.opensaml.xml.io.UnmarshallerFactory;
import org.opensaml.xml.io.UnmarshallingException;
import org.opensaml.xml.security.Criteria;
import org.opensaml.xml.security.CriteriaSet;
import org.opensaml.xml.security.SecurityException;
import org.opensaml.xml.security.credential.Credential;
import org.opensaml.xml.security.keyinfo.KeyInfoCredentialResolver;
import org.opensaml.xml.security.keyinfo.KeyInfoCriteria;
import org.opensaml.xml.security.x509.BasicX509Credential;
import org.opensaml.xml.signature.KeyInfo;
import org.opensaml.xml.signature.Signature;
import org.opensaml.xml.signature.SignatureValidator;
import org.opensaml.xml.util.Base64;
import org.opensaml.xml.util.XMLHelper;
import org.opensaml.xml.validation.ValidationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SamlUtils {
    public static final String SAML_REQUEST_PARAMETER = "SAMLRequest";
    public static final String SAML_RESPONSE_PARAMETER = "SAMLResponse";
    public static final String RELAY_STATE_PARAMETER = "RelayState";
    public static final String SIGNATURE_ALGORITHM_PARAMETER = "SigAlg";
    public static final String SIGNATURE_PARAMETER = "Signature";
    private static final Logger log = LoggerFactory.getLogger(SamlUtils.class);
    private String issuer;
    private X509Certificate certificate;
    private PrivateKey privateKey;
    private String signAlgorithm;
    private String checkAlgorithm;
    private static SecureRandomIdentifierGenerator generator;

    public SamlUtils(X509Certificate cert, PrivateKey key, String signAlgorithm, String checkAlgorithm, String issuer) throws NoSuchAlgorithmException {
        this.certificate = cert;
        this.privateKey = key;
        this.signAlgorithm = signAlgorithm;
        this.checkAlgorithm = checkAlgorithm;
        this.issuer = issuer;
    }

    public String getIssuer() {
        return this.issuer;
    }

    public void setIssuer(String issuer) {
        this.issuer = issuer;
    }

    public PrivateKey getPrivateKey() {
        return this.privateKey;
    }

    public void setPrivateKey(PrivateKey privateKey) {
        this.privateKey = privateKey;
    }

    public String getSignAlgorithm() {
        return this.signAlgorithm;
    }

    public void setSignAlgorithm(String signAlgorithm) {
        this.signAlgorithm = signAlgorithm;
    }

    public String getCheckAlgorithm() {
        return this.checkAlgorithm;
    }

    public void setCheckAlgorithm(String checkAlgorithm) {
        this.checkAlgorithm = checkAlgorithm;
    }

    public X509Certificate getCertificate() {
        return this.certificate;
    }

    public void setCertificate(X509Certificate cert) {
        this.certificate = cert;
    }

    public String signMessage(String message) throws IllegalStateException {
        Validate.notNull((Object)this.getSignAlgorithm(), (String)"Signature Algorithm");
        Validate.notNull((Object)this.getPrivateKey(), (String)"PrivateKey for signing");
        Validate.notEmpty((String)message, (String)"message string");
        log.debug("Signing  message " + message + ", sigAlg " + this.getSignAlgorithm());
        try {
            SignatureAlgorithm algo = SignatureAlgorithm.getSignatureAlgorithmForURI(this.getSignAlgorithm());
            java.security.Signature sig = java.security.Signature.getInstance(algo.getAlgorithmName());
            sig.initSign(this.privateKey);
            byte[] messageBytes = message.getBytes("UTF-8");
            sig.update(messageBytes);
            byte[] sigBytes = sig.sign();
            String signature = SharedUtils.encodeBytes(sigBytes);
            log.debug("signature: " + signature);
            return signature;
        }
        catch (Exception e) {
            log.error("Failed to sign the message: exception cause", (Throwable)e);
            throw new IllegalStateException(e);
        }
    }

    public void verifySignature(String message, String signature, String algorithmUri) throws IllegalStateException, WebssoClientException {
        log.debug("Verify signature.");
        Validate.notNull((Object)message, (String)"signed content");
        Validate.notNull((Object)signature, (String)"signature");
        Validate.notNull((Object)algorithmUri, (String)"algorithm uri");
        Validate.notNull((Object)this.getCertificate(), (String)"signing certificate");
        boolean verifies = false;
        String decodedAlgorithmUri = null;
        byte[] decodedSignature = null;
        try {
            decodedAlgorithmUri = URLDecoder.decode(algorithmUri, "UTF-8");
            log.debug("Signature algorithm uri {}", (Object)decodedAlgorithmUri);
            decodedSignature = Base64.decode((String)URLDecoder.decode(signature, "UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new WebssoClientException("Could not decode algorithm uri or signature", e);
        }
        try {
            SignatureAlgorithm algo = SignatureAlgorithm.getSignatureAlgorithmForURI(decodedAlgorithmUri);
            java.security.Signature sig = java.security.Signature.getInstance(algo.getAlgorithmName());
            X509Certificate cert = this.getCertificate();
            sig.initVerify(cert.getPublicKey());
            sig.update(message.getBytes("UTF-8"));
            verifies = sig.verify(decodedSignature);
            log.debug("signature verifies: " + verifies);
        }
        catch (Exception e) {
            log.error("Caught exception ", (Throwable)e);
            throw new IllegalStateException(e);
        }
        if (!verifies) {
            throw new IllegalStateException("Signature verification failed.");
        }
    }

    public LogoutRequest createSamlLogoutRequest(String id, String where, String nameIDFormat, String nameID, String sessionIndex) {
        if (id == null) {
            id = generator.generateIdentifier();
        }
        log.info("Building SAML LogoutRequest for id: " + id + "\n \tdestination: " + where + "\n\tnameIDFormat: " + nameIDFormat + "\n\tnameID: " + nameID + "\n\tsessionIndex: " + sessionIndex);
        Validate.notNull((Object)where, (String)"destination is null");
        Validate.notNull((Object)nameID, (String)"nameID is null");
        DateTime issueInstant = new DateTime();
        LogoutRequestBuilder logoutRequestBuilder = new LogoutRequestBuilder();
        LogoutRequest logoutRequest = logoutRequestBuilder.buildObject("urn:oasis:names:tc:SAML:2.0:protocol", "LogoutRequest", "samlp");
        logoutRequest.setDestination(where);
        logoutRequest.setIssueInstant(issueInstant);
        logoutRequest.setIssuer(SamlUtils.spawnIssuer(this.getIssuer()));
        logoutRequest.setNameID(this.spawnNameID(nameIDFormat, nameID));
        logoutRequest.setID(id);
        logoutRequest.setVersion(SAMLVersion.VERSION_20);
        if (sessionIndex != null) {
            SessionIndexBuilder sessionIndexBuilder = new SessionIndexBuilder();
            SessionIndex sessionIndexElement = sessionIndexBuilder.buildObject("urn:oasis:names:tc:SAML:2.0:protocol", "SessionIndex", "samlp");
            sessionIndexElement.setSessionIndex(sessionIndex);
            logoutRequest.getSessionIndexes().add(sessionIndexElement);
        }
        return logoutRequest;
    }

    public static LogoutResponse createSamlLogoutResponse(String issuerVal, String inResponseTo, String where, String status, String substatus, String message) {
        log.info("SP Creating SAML Logout Response in response to:" + inResponseTo + ", destination: " + where);
        log.info("SP Creating SAML Logout Response status:" + status + ", substatus: " + substatus + ", message:" + message);
        Validate.notNull((Object)where, (String)"destination is null");
        if (status == null) {
            status = "urn:oasis:names:tc:SAML:2.0:status:Success";
        }
        LogoutResponse response = SamlUtils.create(LogoutResponse.class, LogoutResponse.DEFAULT_ELEMENT_NAME);
        response.setID(generator.generateIdentifier());
        if (inResponseTo != null) {
            response.setInResponseTo(inResponseTo);
        }
        if (issuerVal != null) {
            IssuerBuilder issuerBuilder = new IssuerBuilder();
            Issuer issuer = issuerBuilder.buildObject("urn:oasis:names:tc:SAML:2.0:assertion", "Issuer", "samlp");
            issuer.setValue(issuerVal);
            response.setIssuer(issuer);
        }
        response.setVersion(SAMLVersion.VERSION_20);
        DateTime now = new DateTime();
        response.setIssueInstant(now);
        response.setDestination(where);
        Status samlStatus = SamlUtils.spawnStatus(status, substatus, message);
        response.setStatus(samlStatus);
        return response;
    }

    public Response createSamlLoginResponse(String inResponseTo, String where, String status, String substatus, String message, Document token) throws UnmarshallingException {
        log.info("Creating SAML Response in response to:" + inResponseTo + ", destination:" + where + ", issuer:" + this.getIssuer());
        log.info("Creating SAML Response status:" + status + ", substatus: " + substatus);
        Validate.notNull((Object)where, (String)"destination is null");
        if (status == null) {
            status = "urn:oasis:names:tc:SAML:2.0:status:Success";
        }
        Response response = SamlUtils.create(Response.class, Response.DEFAULT_ELEMENT_NAME);
        response.setID(generator.generateIdentifier());
        if (inResponseTo != null) {
            response.setInResponseTo(inResponseTo);
        }
        response.setVersion(SAMLVersion.VERSION_20);
        DateTime now = new DateTime();
        response.setIssueInstant(now);
        response.setDestination(where);
        response.setIssuer(SamlUtils.spawnIssuer(this.getIssuer()));
        Status samlStatus = SamlUtils.spawnStatus(status, substatus, message);
        response.setStatus(samlStatus);
        if (token != null) {
            Element root = token.getDocumentElement();
            UnmarshallerFactory unmarshallerFactory = org.opensaml.xml.Configuration.getUnmarshallerFactory();
            Unmarshaller unmarshaller = unmarshallerFactory.getUnmarshaller(root);
            Assertion assertion = (Assertion)unmarshaller.unmarshall(root);
            response.getAssertions().add(assertion);
        }
        return response;
    }

    private static Status spawnStatus(String status, String substatus, String message) {
        StatusCode statusCodeElement = SamlUtils.create(StatusCode.class, StatusCode.DEFAULT_ELEMENT_NAME);
        statusCodeElement.setValue(status);
        if (substatus != null) {
            StatusCode statusCodeElement2 = SamlUtils.create(StatusCode.class, StatusCode.DEFAULT_ELEMENT_NAME);
            statusCodeElement2.setValue(substatus);
            statusCodeElement.setStatusCode(statusCodeElement2);
        }
        Status samlStatus = SamlUtils.create(Status.class, Status.DEFAULT_ELEMENT_NAME);
        samlStatus.setStatusCode(statusCodeElement);
        if (message != null) {
            StatusMessage statusMessage = SamlUtils.create(StatusMessage.class, StatusMessage.DEFAULT_ELEMENT_NAME);
            statusMessage.setMessage(message);
            samlStatus.setStatusMessage(statusMessage);
        }
        return samlStatus;
    }

    private NameID spawnNameID(String format, String nameIDValue) {
        NameID result = null;
        result = SamlUtils.create(NameID.class, NameID.DEFAULT_ELEMENT_NAME);
        result.setValue(nameIDValue);
        if (format != null) {
            result.setFormat(format);
        }
        return result;
    }

    public static Issuer spawnIssuer(String myId) {
        Issuer result = null;
        result = SamlUtils.create(Issuer.class, Issuer.DEFAULT_ELEMENT_NAME);
        result.setValue(myId);
        return result;
    }

    public static String encodeSAMLObject(SignableSAMLObject signableSAMLObject, boolean doCompress) throws MarshallingException, IOException {
        Marshaller marshaller = Configuration.getMarshallerFactory().getMarshaller((XMLObject)signableSAMLObject);
        Element authDOM = marshaller.marshall((XMLObject)signableSAMLObject);
        StringWriter rspWrt = new StringWriter();
        XMLHelper.writeNode((Node)authDOM, (Writer)rspWrt);
        String messageXML = rspWrt.toString();
        String samlRequestParameter = null;
        log.debug("encodeSAMLObject...before encoding: " + messageXML);
        if (doCompress) {
            Deflater deflater = new Deflater(8, true);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DeflaterOutputStream deflaterOutputStream = new DeflaterOutputStream((OutputStream)byteArrayOutputStream, deflater);
            deflaterOutputStream.write(messageXML.getBytes("UTF-8"));
            deflaterOutputStream.close();
            samlRequestParameter = SharedUtils.encodeBytes(byteArrayOutputStream.toByteArray());
        } else {
            samlRequestParameter = SharedUtils.encodeString(messageXML);
        }
        log.trace("encodeSAMLObject...after encoding: " + samlRequestParameter);
        return samlRequestParameter;
    }

    public static String extractResponse(String samlRequestParameter) throws Exception {
        Inflater decompresser = new Inflater(true);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        InflaterOutputStream inflaterOutputStream = new InflaterOutputStream(byteArrayOutputStream, decompresser);
        inflaterOutputStream.write(Base64.decode((String)samlRequestParameter));
        inflaterOutputStream.close();
        String outputString = new String(byteArrayOutputStream.toByteArray(), "UTF-8");
        return outputString;
    }

    public static String generateRedirectUrlQueryStringParameters(String samlRequest, String samlResponse, String relayState, String sigAlg, String signature) throws UnsupportedEncodingException {
        StringBuilder sb = new StringBuilder();
        SamlUtils.appendOptionalParameter(sb, SAML_REQUEST_PARAMETER, samlRequest, false);
        SamlUtils.appendOptionalParameter(sb, SAML_RESPONSE_PARAMETER, samlResponse, false);
        SamlUtils.appendOptionalParameter(sb, RELAY_STATE_PARAMETER, relayState, false);
        SamlUtils.appendOptionalParameter(sb, SIGNATURE_ALGORITHM_PARAMETER, sigAlg, false);
        SamlUtils.appendOptionalParameter(sb, SIGNATURE_PARAMETER, signature, false);
        return sb.toString();
    }

    public boolean validateRequestSignature(HttpServletRequest request, Boolean mustSigned) throws Exception {
        Validate.notNull((Object)request, (String)"HttpServletRequest");
        String signatureRawQueryString = HTTPTransportUtils.getRawQueryStringParameter((String)request.getQueryString(), (String)SIGNATURE_PARAMETER);
        String sigAlgRawQueryString = HTTPTransportUtils.getRawQueryStringParameter((String)request.getQueryString(), (String)SIGNATURE_ALGORITHM_PARAMETER);
        if (StringUtils.isEmpty((String)signatureRawQueryString) || StringUtils.isEmpty((String)sigAlgRawQueryString)) {
            if (mustSigned.booleanValue()) {
                String errMsg = "Http request query string missing signature or algorithm.";
                log.error(errMsg);
                throw new IllegalArgumentException(errMsg);
            }
            return false;
        }
        try {
            Validate.notNull((Object)this.getCertificate(), (String)"Certificate");
            String signature = signatureRawQueryString.split("=")[1];
            String algorithmUri = sigAlgRawQueryString.split("=")[1];
            String signedContent = SamlUtils.parseSignedMessage(request);
            this.verifySignature(signedContent, signature, algorithmUri);
            log.info("Successfully validated SAML message signature. ");
        }
        catch (Exception e) {
            log.error("Unable to verify signature of the query string. ", (Throwable)e);
            throw e;
        }
        return true;
    }

    public static XMLObject unmarshallSAMLObj(Document document) throws UnmarshallingException, ConfigurationException {
        Validate.notNull((Object)document);
        Element root = document.getDocumentElement();
        UnmarshallerFactory unmarshallerFactory = org.opensaml.xml.Configuration.getUnmarshallerFactory();
        Unmarshaller unmarshaller = unmarshallerFactory.getUnmarshaller(root);
        XMLObject obj = unmarshaller.unmarshall(root);
        return obj;
    }

    public static Document createDomFromSignable(SignableSAMLObject signableSAMLObject) {
        try {
            Marshaller marshaller = Configuration.getMarshallerFactory().getMarshaller((XMLObject)signableSAMLObject);
            Element signableDomEle = marshaller.marshall((XMLObject)signableSAMLObject);
            DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document doc = builder.newDocument();
            doc.appendChild(doc.importNode(signableDomEle, true));
            return doc;
        }
        catch (Exception e) {
            log.error("Caught exception " + e.toString());
            return null;
        }
    }

    private static void appendOptionalParameter(StringBuilder sb, String paramName, String paramValue, boolean base64Encode) throws UnsupportedEncodingException {
        if (paramValue != null && paramValue != "") {
            if (sb.length() != 0) {
                sb.append("&");
            }
            sb.append(paramName + "=");
            if (base64Encode) {
                paramValue = SharedUtils.encodeString(paramValue);
            }
            try {
                sb.append(URLEncoder.encode(paramValue, "UTF-8"));
            }
            catch (UnsupportedEncodingException e) {
                // empty catch block
            }
        }
    }

    public static void ValidateConditions(Conditions conditions, int clockTolerance) throws ValidationException {
        try {
            log.info("Validate assertion condition with clock tolerance = " + clockTolerance);
            Validate.isTrue((clockTolerance >= 0 ? 1 : 0) != 0, (String)"Negative clock tolerance setting");
            Calendar currentDate = Calendar.getInstance();
            TimeZone gmtTimeZone = TimeZone.getTimeZone("GMT");
            currentDate.setTimeZone(gmtTimeZone);
            if (conditions.getNotBefore() != null) {
                DateTime notBefore = conditions.getNotBefore().minusSeconds(clockTolerance);
                Validate.isTrue((boolean)currentDate.getTime().after(notBefore.toDate()), (String)("Validating notBefore fails! Tolerance-adjusted notBefore date is:" + notBefore.toString()));
            }
            if (conditions.getNotOnOrAfter() != null) {
                DateTime notOnOrAfter = conditions.getNotOnOrAfter().plusSeconds(clockTolerance);
                Validate.isTrue((boolean)currentDate.getTime().before(notOnOrAfter.toDate()), (String)("Validating notAfter fails! Tolerance-adjusted notAfter date is:" + notOnOrAfter.toString()));
            }
        }
        catch (IllegalArgumentException e) {
            log.error("Invalid condition value in token. If this is issued by legitimate IDP, it is possibly caused by clock skew or slow response due to network issues.", (Throwable)e);
            throw new ValidationException((Exception)e);
        }
    }

    public static void ValidateSessionExpiry(DateTime sessionNotOnOrAfter, int clockTolerance) throws ValidationException {
        try {
            log.info("Validate sessionNotOnOrAfter with clock tolerance = " + clockTolerance);
            Validate.isTrue((clockTolerance >= 0 ? 1 : 0) != 0, (String)"Negative clock tolerance setting");
            Calendar currentDate = Calendar.getInstance();
            TimeZone gmtTimeZone = TimeZone.getTimeZone("GMT");
            currentDate.setTimeZone(gmtTimeZone);
            if (sessionNotOnOrAfter != null) {
                DateTime notOnOrAfter = sessionNotOnOrAfter.plusSeconds(clockTolerance);
                Validate.isTrue((boolean)currentDate.getTime().before(notOnOrAfter.toDate()), (String)("Validating notAfter fails! Tolerance-adjusted notAfter date is:" + notOnOrAfter.toString()));
            }
        }
        catch (IllegalArgumentException e) {
            log.error("Failed to validate the session expiry date.", (Throwable)e);
            throw new ValidationException((Exception)e);
        }
    }

    public static void ValidateSignature(Signature signature, X509Certificate cert) throws ValidationException, SecurityException {
        if (signature == null) {
            log.warn("Null signature!");
            return;
        }
        BasicX509Credential pubCredential = new BasicX509Credential();
        BasicX509Credential cred = null;
        KeyInfo keyInfo = signature.getKeyInfo();
        if (keyInfo == null) {
            if (cert == null) {
                throw new ValidationException("No signing certificate found.");
            }
            pubCredential.setEntityCertificate(cert);
            cred = pubCredential;
        } else {
            KeyInfoCredentialResolver kiResolver = org.opensaml.xml.Configuration.getGlobalSecurityConfiguration().getDefaultKeyInfoCredentialResolver();
            CriteriaSet criteriaSet = new CriteriaSet((Criteria)new KeyInfoCriteria(keyInfo));
            cred = (Credential)kiResolver.resolveSingle((Object)criteriaSet);
        }
        SAMLSignatureProfileValidator pv = new SAMLSignatureProfileValidator();
        pv.validate(signature);
        SignatureValidator sigValidator = new SignatureValidator((Credential)cred);
        sigValidator.validate(signature);
    }

    public static String parseSignedMessage(HttpServletRequest request) throws IllegalArgumentException {
        String queryString = request.getQueryString();
        String samlRequest = HTTPTransportUtils.getRawQueryStringParameter((String)queryString, (String)SAML_REQUEST_PARAMETER);
        String samlResponse = HTTPTransportUtils.getRawQueryStringParameter((String)queryString, (String)SAML_RESPONSE_PARAMETER);
        Validate.isTrue((samlRequest != null || samlResponse != null ? 1 : 0) != 0);
        String signature = HTTPTransportUtils.getRawQueryStringParameter((String)queryString, (String)SIGNATURE_PARAMETER);
        String sigAlgo = HTTPTransportUtils.getRawQueryStringParameter((String)queryString, (String)SIGNATURE_ALGORITHM_PARAMETER);
        String relayState = HTTPTransportUtils.getRawQueryStringParameter((String)queryString, (String)RELAY_STATE_PARAMETER);
        if (signature == null || sigAlgo == null) {
            return null;
        }
        StringBuilder builder = new StringBuilder();
        if (samlRequest != null) {
            builder.append(samlRequest);
        } else {
            builder.append(samlResponse);
        }
        if (relayState != null) {
            builder.append('&');
            builder.append(relayState);
        }
        builder.append('&');
        builder.append(sigAlgo);
        String signedMessage = builder.toString();
        log.debug("Constructed signed message {}", (Object)signedMessage);
        return signedMessage;
    }

    public static String getIdpSsoLocation(IDPConfiguration idpConfig, String binding) {
        Validate.notNull((Object)idpConfig, (String)"IDPConfiguration");
        Validate.notNull((Object)binding, (String)"Null binding");
        List<SingleSignOnService> services = idpConfig.getSingleSignOnServices();
        for (SingleSignOnService service : services) {
            if (!service.getBinding().equals(binding)) continue;
            return service.getLocation();
        }
        return null;
    }

    public static String getIdpSloLocation(IDPConfiguration idpConfig, String binding) {
        Validate.notNull((Object)idpConfig, (String)"IDPConfiguration");
        Validate.notNull((Object)binding, (String)"Null binding");
        List<SingleLogoutService> services = idpConfig.getSingleLogoutServices();
        for (SingleLogoutService service : services) {
            if (!service.getBinding().equals(binding)) continue;
            return service.getLocation();
        }
        return null;
    }

    public static String getSpSloLocation(SPConfiguration spConfig, String binding) {
        Validate.notNull((Object)spConfig, (String)"SPConfiguration");
        Validate.notNull((Object)binding, (String)"Null binding");
        List<SingleLogoutService> services = spConfig.getSingleLogoutServices();
        for (SingleLogoutService service : services) {
            if (!service.getBinding().equals(binding)) continue;
            return service.getLocation();
        }
        return null;
    }

    public static X509Certificate getIDPCertByIssuer(MetadataSettings metadataSettings, String issuerVal) throws WebssoClientException, IllegalArgumentException {
        Validate.notNull((Object)issuerVal, (String)"issuerVal");
        Validate.notNull((Object)metadataSettings, (String)"metadataSettings");
        String idpEnitityID = issuerVal;
        if (idpEnitityID == null) {
            throw new WebssoClientException("Issuer not recognized.");
        }
        log.info("Getting IDP config for:" + idpEnitityID);
        IDPConfiguration idpConfig = metadataSettings.getIDPConfigurationByEntityID(idpEnitityID);
        return idpConfig.getSigningCertificate();
    }

    private static <T> T create(Class<T> cls, QName qname) {
        return (T)org.opensaml.xml.Configuration.getBuilderFactory().getBuilder(qname).buildObject(qname);
    }

    public static boolean isIdpSupportSLO(MetadataSettings metadataSettings, SloRequestSettings requestSettings) {
        IDPConfiguration idpConfig = metadataSettings.getIDPConfiguration(requestSettings.getIDPAlias());
        return SamlUtils.getIdpSloLocation(idpConfig, "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect") != null;
    }

    static {
        try {
            generator = new SecureRandomIdentifierGenerator();
        }
        catch (NoSuchAlgorithmException e) {
            log.error("Unexpected error in creating SecureRandomIdentifierGenerator");
        }
    }
}

