/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.identity.websso.client;

import com.vmware.identity.websso.client.NullResolver;
import com.vmware.identity.websso.client.SamlParserErrorHandler;
import com.vmware.identity.websso.client.SamlUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import javax.servlet.http.HttpServletResponse;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.opensaml.common.SignableSAMLObject;
import org.opensaml.saml2.core.LogoutResponse;
import org.opensaml.saml2.core.Response;
import org.opensaml.xml.io.MarshallingException;
import org.opensaml.xml.util.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class SharedUtils {
    private static Logger logger = LoggerFactory.getLogger(SharedUtils.class);
    private static final String DISALLOW_DOCTYPE_DECL = "http://apache.org/xml/features/disallow-doctype-decl";
    private static final String EXTERNAL_GENERAL_ENTITIES = "http://xml.org/sax/features/external-general-entities";
    private static final String EXTERNAL_PARAMETER_ENTITIES = "http://xml.org/sax/features/external-parameter-entities";
    private static final String LOAD_EXTERNAL_DTD = "http://apache.org/xml/features/nonvalidating/load-external-dtd";
    public static final String CACHE_CONTROL_HEADER = "Cache-Control";
    public static final String PRAGMA = "Pragma";

    public static Document createDOM(String strXML) throws ParserConfigurationException, SAXException, IOException {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setValidating(false);
        dbf.setIgnoringComments(false);
        dbf.setIgnoringElementContentWhitespace(true);
        dbf.setNamespaceAware(true);
        dbf.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
        dbf.setFeature(DISALLOW_DOCTYPE_DECL, true);
        dbf.setFeature(EXTERNAL_GENERAL_ENTITIES, false);
        dbf.setFeature(EXTERNAL_PARAMETER_ENTITIES, false);
        dbf.setFeature(LOAD_EXTERNAL_DTD, false);
        DocumentBuilder db = null;
        db = dbf.newDocumentBuilder();
        db.setEntityResolver(new NullResolver());
        db.setErrorHandler(new SamlParserErrorHandler());
        InputSource sourceXML = new InputSource(new StringReader(strXML));
        Document xmlDoc = db.parse(sourceXML);
        return xmlDoc;
    }

    public static Document createDOM(InputStream is) throws ParserConfigurationException, SAXException, IOException {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setValidating(false);
        dbf.setIgnoringComments(false);
        dbf.setIgnoringElementContentWhitespace(true);
        dbf.setNamespaceAware(true);
        dbf.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
        dbf.setFeature(DISALLOW_DOCTYPE_DECL, true);
        dbf.setFeature(EXTERNAL_GENERAL_ENTITIES, false);
        dbf.setFeature(EXTERNAL_PARAMETER_ENTITIES, false);
        dbf.setFeature(LOAD_EXTERNAL_DTD, false);
        DocumentBuilder db = null;
        db = dbf.newDocumentBuilder();
        db.setEntityResolver(new NullResolver());
        db.setErrorHandler(new SamlParserErrorHandler());
        return db.parse(is);
    }

    public static void formattedPrint(Node xml, OutputStream out) throws TransformerConfigurationException, TransformerFactoryConfigurationError, TransformerException, UnsupportedEncodingException {
        TransformerFactory tFactory = TransformerFactory.newInstance();
        Transformer tf = tFactory.newTransformer();
        tf.setOutputProperty("omit-xml-declaration", "yes");
        tf.setOutputProperty("encoding", "UTF-8");
        tf.setOutputProperty("indent", "yes");
        tf.setOutputProperty("method", "xml");
        tf.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "5");
        StreamResult result = new StreamResult(new OutputStreamWriter(out, "UTF-8"));
        tf.transform(new DOMSource(xml), result);
    }

    public static String encodeBytes(byte[] bytesToEncode) {
        String retval = Base64.encodeBytes((byte[])bytesToEncode, (int)8);
        return retval;
    }

    public static String encodeString(String stringToEncode) throws UnsupportedEncodingException {
        return SharedUtils.encodeBytes(stringToEncode.getBytes("UTF-8"));
    }

    public static void logMessage(Exception err) {
        StackTraceElement[] elements = err.getStackTrace();
        String className = elements[2].getClassName();
        String methodName = elements[2].getMethodName();
        int lineNumber = elements[2].getLineNumber();
        logger.error(className + "." + methodName + "() at line: " + lineNumber + ": " + err.getCause() + " " + err.getMessage());
    }

    public static void logUrl(Logger log, StringBuffer sbRequestUrl, SignableSAMLObject samlObject, String relayStateParameter, String signatureAlgorithm, String signature, String extra) throws MarshallingException, IOException {
        String samlParameterName = "SAMLRequest";
        boolean doCompress = true;
        if (samlObject instanceof LogoutResponse || samlObject instanceof Response) {
            samlParameterName = "SAMLResponse";
            if (samlObject instanceof Response) {
                doCompress = false;
            }
        }
        log.info("We are going to GET URL " + sbRequestUrl.toString() + (samlObject != null ? "?" + samlParameterName + "=" + URLEncoder.encode(SamlUtils.encodeSAMLObject(samlObject, doCompress)) : "") + (relayStateParameter != null ? "&RelayState=" + URLEncoder.encode(relayStateParameter) : "") + (signatureAlgorithm != null ? "&SigAlg=" + URLEncoder.encode(signatureAlgorithm) : "") + (signature != null ? "&Signature=" + URLEncoder.encode(signature) : "") + (extra != null ? "&" + extra : ""));
    }

    public static void SetNoCacheHeader(HttpServletResponse httpResponse) {
        httpResponse.addHeader(CACHE_CONTROL_HEADER, "no-store");
        httpResponse.addHeader(PRAGMA, "no-cache");
    }
}

