/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.identity.websso.client;

import com.vmware.identity.websso.client.IDPConfiguration;
import com.vmware.identity.websso.client.Message;
import com.vmware.identity.websso.client.MessageData;
import com.vmware.identity.websso.client.MetadataSettings;
import com.vmware.identity.websso.client.RelaxedURIComparator;
import com.vmware.identity.websso.client.SamlUtils;
import com.vmware.identity.websso.client.ValidationResult;
import com.vmware.identity.websso.client.WebssoClientException;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.Validate;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;

public abstract class ValidationState {
    private String messageID;
    private String relayState;
    private String status;
    private String subStatus;
    private String issuerVal;
    private DateTime issueInstant;
    private String destination;
    private MessageData messageData;
    private String sessionIndex;
    private ValidationResult validationResult = new ValidationResult();
    private final RelaxedURIComparator comparator;
    private MetadataSettings metadataSettings;
    private HttpServletRequest request;
    private Document samlDom;
    private static final Logger logger = LoggerFactory.getLogger(ValidationState.class);

    protected ValidationState(MetadataSettings metadataSettings) {
        this.metadataSettings = metadataSettings;
        this.comparator = new RelaxedURIComparator();
    }

    public abstract void validate() throws Exception;

    public void validateDestination() throws WebssoClientException {
        if (this.getDestination() == null) {
            return;
        }
        String requestUrl = this.getRequest().getRequestURL().toString();
        logger.info("Validating request destination: HttpservletRequest destination=" + requestUrl + "SAML message destination=" + this.getDestination());
        if (!this.comparator.compare(this.getDestination(), requestUrl)) {
            this.validationResult = new ValidationResult(403, "Forbidden", "The SAML message was not intended to this destination.");
            throw new WebssoClientException("The SAML message was not intended to this destination.");
        }
    }

    protected void validateSloIssuer(Message message, String issuerVal) throws IllegalArgumentException, WebssoClientException {
        try {
            logger.info("Validating SLO message issuer: " + issuerVal);
            if (issuerVal == null) {
                throw new WebssoClientException("Issuer is missing!");
            }
            MetadataSettings metaSettings = this.getMetadataSettings();
            if (message == null) {
                IDPConfiguration idpConfig = metaSettings.getIDPConfigurationByEntityID(issuerVal);
                Validate.notNull((Object)idpConfig, (String)"IPConfiguration");
            } else {
                String originalRequstTarget = message.getTarget();
                Validate.notNull((Object)originalRequstTarget, (String)"Matching SLO request destination");
                IDPConfiguration idpConfig = metaSettings.getIDPConfigurationByEntityID(issuerVal);
                String issuerSloLocation = SamlUtils.getIdpSloLocation(idpConfig, "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect");
                if (issuerSloLocation == null || !issuerSloLocation.equals(originalRequstTarget)) {
                    logger.warn("logout response issuer is a unknown IDP! Issuer: " + issuerVal + "\tThe original slo request target is:" + originalRequstTarget + "\tThe idp slo location is:" + issuerSloLocation);
                    throw new WebssoClientException("Issuer:" + issuerVal);
                }
            }
        }
        catch (Exception e) {
            this.setValidationResult(new ValidationResult(400, "BadRequest", "Issuer not recognized."));
            throw new WebssoClientException(this.getValidationResult().getSubstatus(), e);
        }
    }

    public String getMessageID() {
        return this.messageID;
    }

    public void setMessageID(String messageID) {
        this.messageID = messageID;
    }

    public String getRelayState() {
        return this.relayState;
    }

    public void setRelayState(String relayState) {
        this.relayState = relayState;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getSubStatus() {
        return this.subStatus;
    }

    public void setSubStatus(String subStatus) {
        this.subStatus = subStatus;
    }

    public String getIssuerVal() {
        return this.issuerVal;
    }

    public void setIssuerVal(String issuerVal) {
        this.issuerVal = issuerVal;
    }

    public DateTime getIssueInstant() {
        return this.issueInstant;
    }

    public void setIssueInstant(DateTime issueInstant) {
        this.issueInstant = issueInstant;
    }

    public String getDestination() {
        return this.destination;
    }

    public void setDestination(String destination) {
        this.destination = destination;
    }

    public MessageData getMessageData() {
        return this.messageData;
    }

    public void setMessageData(MessageData messageData) {
        this.messageData = messageData;
    }

    public ValidationResult getValidationResult() {
        return this.validationResult;
    }

    public void setValidationResult(ValidationResult validationResult) {
        this.validationResult = validationResult;
    }

    public Document getSamlDom() {
        return this.samlDom;
    }

    public void setSamlDom(Document samlDom) {
        this.samlDom = samlDom;
    }

    public String getSessionIndex() {
        return this.sessionIndex;
    }

    public void setSessionIndex(String sessionIndex) {
        this.sessionIndex = sessionIndex;
    }

    public HttpServletRequest getRequest() {
        return this.request;
    }

    public void setRequest(HttpServletRequest request) {
        this.request = request;
    }

    public MetadataSettings getMetadataSettings() {
        return this.metadataSettings;
    }

    public void setMetadataSettings(MetadataSettings metadataSettings) {
        this.metadataSettings = metadataSettings;
    }
}

