/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.identity.websso.client.endpoint;

import com.vmware.identity.saml.ext.DelegableType;
import com.vmware.identity.saml.ext.RenewableType;
import com.vmware.identity.saml.ext.impl.DelegableTypeBuilder;
import com.vmware.identity.saml.ext.impl.RenewableTypeBuilder;
import com.vmware.identity.websso.client.IDPConfiguration;
import com.vmware.identity.websso.client.LogonProcessor;
import com.vmware.identity.websso.client.Message;
import com.vmware.identity.websso.client.MessageStore;
import com.vmware.identity.websso.client.MessageType;
import com.vmware.identity.websso.client.MetadataSettings;
import com.vmware.identity.websso.client.SPConfiguration;
import com.vmware.identity.websso.client.SamlUtils;
import com.vmware.identity.websso.client.SharedUtils;
import com.vmware.identity.websso.client.SsoRequestSettings;
import com.vmware.identity.websso.client.WebssoClientException;
import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.Validate;
import org.joda.time.DateTime;
import org.opensaml.common.SAMLVersion;
import org.opensaml.common.SignableSAMLObject;
import org.opensaml.common.impl.SecureRandomIdentifierGenerator;
import org.opensaml.saml2.core.AuthnContextClassRef;
import org.opensaml.saml2.core.AuthnContextComparisonTypeEnumeration;
import org.opensaml.saml2.core.AuthnRequest;
import org.opensaml.saml2.core.Conditions;
import org.opensaml.saml2.core.Issuer;
import org.opensaml.saml2.core.NameIDPolicy;
import org.opensaml.saml2.core.RequestedAuthnContext;
import org.opensaml.saml2.core.Scoping;
import org.opensaml.saml2.core.impl.AuthnContextClassRefBuilder;
import org.opensaml.saml2.core.impl.AuthnRequestBuilder;
import org.opensaml.saml2.core.impl.ConditionsBuilder;
import org.opensaml.saml2.core.impl.IssuerBuilder;
import org.opensaml.saml2.core.impl.NameIDPolicyBuilder;
import org.opensaml.saml2.core.impl.RequestedAuthnContextBuilder;
import org.opensaml.saml2.core.impl.ScopingBuilder;
import org.opensaml.xml.ConfigurationException;
import org.opensaml.xml.io.MarshallingException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SsoRequestSender {
    private static Logger logger = LoggerFactory.getLogger(SsoRequestSender.class);
    private final SecureRandomIdentifierGenerator generator = new SecureRandomIdentifierGenerator();
    @Autowired
    private MetadataSettings metadataSettings = null;
    @Autowired
    private MessageStore messageStore = null;
    @Autowired
    private LogonProcessor logonProcessor = null;

    public void setMetadataSettings(MetadataSettings metadataSettings) {
        this.metadataSettings = metadataSettings;
    }

    public MetadataSettings getMetadataSettings() {
        return this.metadataSettings;
    }

    public void setMessageStore(MessageStore messageStore) {
        this.messageStore = messageStore;
    }

    public MessageStore getMessageStore() {
        return this.messageStore;
    }

    public void setLogonProcessor(LogonProcessor logonProcessor) {
        this.logonProcessor = logonProcessor;
    }

    public LogonProcessor getLogonProcessor() {
        return this.logonProcessor;
    }

    public void sendRequest(SsoRequestSettings requestSettings, HttpServletResponse response) throws IOException, ConfigurationException, MarshallingException, InvalidKeyException, NoSuchAlgorithmException, WebssoClientException {
        Validate.notNull((Object)requestSettings, (String)"requestSettings");
        Validate.notNull((Object)response, (String)"response");
        Validate.notNull((Object)this.getMessageStore(), (String)"messageStore");
        Validate.notNull((Object)this.getMetadataSettings(), (String)"metadataSettings");
        String redirectUrl = this.getRequestUrl(requestSettings);
        if (redirectUrl != null) {
            SharedUtils.SetNoCacheHeader(response);
            response.sendRedirect(redirectUrl);
        } else {
            logger.error("Fail to generate the SSO request!");
        }
    }

    public String getRequestUrl(SsoRequestSettings requestSettings) {
        String redirectUrl = null;
        Validate.notNull((Object)requestSettings, (String)"requestSettings");
        try {
            logger.info("Producing redirect url");
            SPConfiguration spConfig = this.metadataSettings.getSPConfiguration(requestSettings.getSPAlias());
            if (spConfig == null) {
                throw new IllegalArgumentException("service provider setting unavailable for " + requestSettings.getSPAlias());
            }
            IssuerBuilder issuerBuilder = new IssuerBuilder();
            Issuer issuer = issuerBuilder.buildObject("urn:oasis:names:tc:SAML:2.0:assertion", "Issuer", "samlp");
            issuer.setValue(spConfig.getEntityID());
            NameIDPolicy nameIdPolicy = this.createNameIdPolicy(requestSettings.getNameIDFormat(), spConfig, requestSettings);
            Scoping scoping = this.createScoping(requestSettings);
            DateTime issueInstant = new DateTime();
            AuthnRequestBuilder authRequestBuilder = new AuthnRequestBuilder();
            AuthnRequest authRequest = authRequestBuilder.buildObject("urn:oasis:names:tc:SAML:2.0:protocol", "AuthnRequest", "samlp");
            authRequest.setForceAuthn(requestSettings.isForceAuthn());
            authRequest.setIsPassive(requestSettings.isPassive());
            authRequest.setIssueInstant(issueInstant);
            authRequest.setProtocolBinding("urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST");
            authRequest.setScoping(scoping);
            String acsUrl = requestSettings.getAssertionConsumerServiceUrl();
            if (acsUrl != null && !acsUrl.isEmpty()) {
                authRequest.setAssertionConsumerServiceURL(requestSettings.getAssertionConsumerServiceUrl());
            } else {
                Integer index = requestSettings.getAssertionConsumerServiceIndex();
                if (index != null) {
                    authRequest.setAssertionConsumerServiceIndex(index);
                }
            }
            authRequest.setIssuer(issuer);
            authRequest.setNameIDPolicy(nameIdPolicy);
            if (requestSettings.getAllowRequestAuthnContext().booleanValue()) {
                RequestedAuthnContext requestedAuthnContext = this.createRequestedAuthnContext(requestSettings);
                authRequest.setRequestedAuthnContext(requestedAuthnContext);
            }
            authRequest.setID(this.generator.generateIdentifier());
            authRequest.setVersion(SAMLVersion.VERSION_20);
            authRequest.setProviderName(requestSettings.getSPAlias());
            IDPConfiguration idpConfig = this.metadataSettings.getIDPConfiguration(requestSettings.getIDPAlias());
            Validate.notNull((Object)idpConfig);
            String destination = SamlUtils.getIdpSsoLocation(idpConfig, "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect");
            Validate.notEmpty((String)destination, (String)"destination");
            authRequest.setDestination(destination);
            ConditionsBuilder conditionsBuilder = new ConditionsBuilder();
            Conditions conditions = null;
            if (requestSettings.isRenewable() != null && requestSettings.isRenewable().booleanValue()) {
                if (conditions == null) {
                    conditions = conditionsBuilder.buildObject();
                }
                conditions.getConditions().add(this.createRenewable());
            }
            if (requestSettings.isDelegable() != null && requestSettings.isDelegable().booleanValue()) {
                if (conditions == null) {
                    conditions = conditionsBuilder.buildObject();
                }
                conditions.getConditions().add(this.createDelegable());
            }
            if (conditions != null) {
                authRequest.setConditions(conditions);
            }
            StringBuilder urlStringBuilder = new StringBuilder();
            urlStringBuilder.append(authRequest.getDestination());
            logger.info("Destination URL: " + authRequest.getDestination());
            String requestStr = this.createRequestString(authRequest, requestSettings.getRelayState(), requestSettings.isSigned(), spConfig.getSigningPrivateKey(), spConfig.getSigningAlgorithm());
            urlStringBuilder.append(requestStr);
            redirectUrl = urlStringBuilder.toString();
            if (redirectUrl == null || redirectUrl.isEmpty()) {
                logger.warn("Redirect URL is null or empty.");
            }
            Message authnMessage = new Message(MessageType.AUTHN_REQUEST, authRequest.getID(), requestSettings.getRelayState(), issueInstant, authRequest.getIssuer().getValue(), destination, null, null, null, null, null);
            this.getMessageStore().add(authnMessage);
        }
        catch (Exception e) {
            this.logonProcessor.internalError(e, null, null);
            SharedUtils.logMessage(e);
            return null;
        }
        return redirectUrl;
    }

    private Scoping createScoping(SsoRequestSettings requestSettings) {
        Scoping scoping = null;
        int proxyCount = 0;
        if (requestSettings.getAllowScopingElement().booleanValue() && requestSettings.getProxyCount() != null && requestSettings.getProxyCount() >= 0) {
            proxyCount = requestSettings.getProxyCount();
            scoping = new ScopingBuilder().buildObject();
            scoping.setProxyCount(Integer.valueOf(proxyCount));
        }
        return scoping;
    }

    private RenewableType createRenewable() {
        RenewableType proxy = new RenewableTypeBuilder().buildObject();
        logger.info("Added Renewable condition");
        return proxy;
    }

    private DelegableType createDelegable() {
        DelegableType proxy = new DelegableTypeBuilder().buildObject();
        logger.info("Added Delegable condition");
        return proxy;
    }

    private NameIDPolicy createNameIdPolicy(String idFormat, SPConfiguration spConfig, SsoRequestSettings requestSettings) {
        Validate.notNull((Object)spConfig, (String)"spConfig");
        NameIDPolicyBuilder nameIdPolicyBuilder = new NameIDPolicyBuilder();
        NameIDPolicy nameIdPolicy = nameIdPolicyBuilder.buildObject();
        if (idFormat != null) {
            nameIdPolicy.setFormat(idFormat);
        }
        if (requestSettings.getAllowSPNameQualifierInNameIDPolicy().booleanValue()) {
            nameIdPolicy.setSPNameQualifier(spConfig.getEntityID());
        }
        if (requestSettings.getAllowAllowCreateInNameIDPolicy().booleanValue()) {
            nameIdPolicy.setAllowCreate(Boolean.valueOf(true));
        }
        return nameIdPolicy;
    }

    private RequestedAuthnContext createRequestedAuthnContext(SsoRequestSettings requestSettings) {
        RequestedAuthnContextBuilder requestedAuthnContextBuilder = new RequestedAuthnContextBuilder();
        RequestedAuthnContext requestedAuthnContext = requestedAuthnContextBuilder.buildObject();
        requestedAuthnContext.setComparison(AuthnContextComparisonTypeEnumeration.EXACT);
        List authnContextClassRefs = requestedAuthnContext.getAuthnContextClassRefs();
        List<String> reqSettingsContextClasses = requestSettings.getRequestedAuthnContextClasses();
        if (null == reqSettingsContextClasses) {
            requestedAuthnContext = null;
        } else {
            for (String ref : reqSettingsContextClasses) {
                authnContextClassRefs.add(this.createAuthnContextClassReg(ref));
            }
        }
        return requestedAuthnContext;
    }

    private AuthnContextClassRef createAuthnContextClassReg(String authnClassURIStr) {
        AuthnContextClassRefBuilder authnContextClassRefBuilder = new AuthnContextClassRefBuilder();
        AuthnContextClassRef authnContextClassRef = authnContextClassRefBuilder.buildObject();
        authnContextClassRef.setAuthnContextClassRef(authnClassURIStr);
        return authnContextClassRef;
    }

    private String createRequestString(AuthnRequest authRequest, String relayState, Boolean isSigned, PrivateKey signingKey, String algorithmName) throws MarshallingException, IOException, NoSuchAlgorithmException, WebssoClientException {
        Validate.notNull((Object)authRequest, (String)"AuthnRequest object");
        if (isSigned.booleanValue() && (signingKey == null || algorithmName == null)) {
            throw new WebssoClientException("Signing key missing, or algorithm not specified.");
        }
        SamlUtils utils = new SamlUtils(null, signingKey, algorithmName, null, null);
        String samlRequestParameter = SamlUtils.encodeSAMLObject((SignableSAMLObject)authRequest, true);
        String notSignedRequest = SamlUtils.generateRedirectUrlQueryStringParameters(samlRequestParameter, null, relayState, isSigned != false ? algorithmName : null, null);
        logger.info("Relay State value is: " + relayState);
        if (notSignedRequest == null || notSignedRequest.isEmpty()) {
            logger.info("Found null or empty message to be signed. ");
        }
        String queryString = "?";
        if (isSigned.booleanValue()) {
            String signature = utils.signMessage(notSignedRequest);
            logger.debug("Signature " + signature);
            String signedString = SamlUtils.generateRedirectUrlQueryStringParameters(samlRequestParameter, null, relayState, algorithmName, signature);
            queryString = queryString + signedString;
        } else {
            queryString = queryString + notSignedRequest;
        }
        return queryString;
    }
}

