/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.identity.websso.client.endpoint;

import com.vmware.identity.websso.client.LogonProcessor;
import com.vmware.identity.websso.client.Message;
import com.vmware.identity.websso.client.MessageStore;
import com.vmware.identity.websso.client.MessageType;
import com.vmware.identity.websso.client.MetadataSettings;
import com.vmware.identity.websso.client.SsoValidationState;
import com.vmware.identity.websso.client.ValidationResult;
import com.vmware.identity.websso.client.ValidationState;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Controller
public class SsoResponseListener {
    private static final Logger logger = LoggerFactory.getLogger(SsoResponseListener.class);
    @Autowired
    private MetadataSettings metadataSettings;
    @Autowired
    private MessageStore messageStore;
    @Autowired
    private LogonProcessor logonProcessor;
    private boolean assertionMustBeSigned = true;

    @RequestMapping(value={"/SsoClient/SSO/{tenant:.*}"}, method={RequestMethod.POST})
    public void consumeResponse(@PathVariable(value="tenant") String tenant, HttpServletRequest request, HttpServletResponse httpResponse) {
        logger.info("You have POST'ed to Websso client library!");
        LogonProcessor processor = this.getLogonProcessor();
        Validate.notNull((Object)processor, (String)"Null LogonProcessor");
        Validate.notNull((Object)request);
        SsoValidationState validator = new SsoValidationState(request, this);
        try {
            ((ValidationState)validator).validate();
            Message message = this.createMessage(validator);
            if (validator.getStatus().equals("urn:oasis:names:tc:SAML:2.0:status:Success")) {
                processor.authenticationSuccess(message, request, httpResponse);
            } else {
                processor.authenticationError(message, request, httpResponse);
            }
        }
        catch (Exception e) {
            logger.error("Authentication Exception:", (Throwable)e);
            if (validator.getValidationResult().isValid()) {
                validator.setValidationResult(new ValidationResult(400, "BadResponse", e.getMessage()));
            }
            Message errorMessage = this.createMessage(validator);
            processor.authenticationError(errorMessage, request, httpResponse);
        }
    }

    private Message createMessage(ValidationState validator) {
        Message message = new Message(MessageType.AUTHN_RESPONSE, validator.getMessageID(), validator.getRelayState(), validator.getIssueInstant(), validator.getIssuerVal(), validator.getDestination(), validator.getStatus(), validator.getSubStatus(), validator.getSessionIndex(), validator.getMessageData(), null);
        message.setValidationResult(validator.getValidationResult());
        return message;
    }

    public void setMetadataSettings(MetadataSettings metadataSettings) {
        this.metadataSettings = metadataSettings;
    }

    public MetadataSettings getMetadataSettings() {
        return this.metadataSettings;
    }

    public void setMessageStore(MessageStore messageStore) {
        this.messageStore = messageStore;
    }

    public MessageStore getMessageStore() {
        return this.messageStore;
    }

    public void setLogonProcessor(LogonProcessor logonProcessor) {
        this.logonProcessor = logonProcessor;
    }

    public LogonProcessor getLogonProcessor() {
        return this.logonProcessor;
    }

    public boolean isAssertionMustBeSigned() {
        return this.assertionMustBeSigned;
    }

    public void setAssertionMustBeSigned(boolean assertionMustBeSigned) {
        this.assertionMustBeSigned = assertionMustBeSigned;
    }
}

