/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.idp.provision.client.vmomi;

import com.vmware.vim.idp.exception.CertificateValidationException;
import com.vmware.vim.idp.exception.InvalidCredentialsException;
import com.vmware.vim.idp.provision.client.IdpProvisionClient;
import com.vmware.vim.idp.provision.client.vmomi.ClientConfiguration;
import com.vmware.vim.idp.provision.client.vmomi.VmomiClientConfiguration;
import com.vmware.vim.idp.provision.client.vmomi.impl.IdpProvisionClientImpl;
import com.vmware.vim.idp.provision.client.vmomi.impl.VlsiClientFactory;
import com.vmware.vim.sso.admin.impl.util.ValidateUtil;
import com.vmware.vim.vmomi.client.Client;
import com.vmware.vim.vmomi.client.http.HttpConfiguration;
import com.vmware.vim.vmomi.client.http.impl.HttpConfigurationImpl;
import java.net.URI;

public final class IdpProvisionClientFactory {
    private static final String CLIENT_CONFIG_ERR_MSG = "Client configuration";
    private final VmomiClientConfiguration _config;
    private final VlsiClientFactory _clientFactory;

    public IdpProvisionClientFactory(VmomiClientConfiguration config) {
        this._config = config;
        this._clientFactory = new VlsiClientFactory();
    }

    public IdpProvisionClient createClient(ClientConfiguration config) throws CertificateValidationException, InvalidCredentialsException {
        ValidateUtil.validateNotNull((Object)config, (String)CLIENT_CONFIG_ERR_MSG);
        return new IdpProvisionClientImpl(this.createVmomiClient(config), config.getAuthData());
    }

    private Client createVmomiClient(ClientConfiguration clientConfig) {
        VmomiClientConfiguration.SslConfiguration sslConfig = this._config.getSslConfig();
        URI serverUri = this._config.getServerUri();
        return sslConfig != null ? this._clientFactory.createClient(serverUri, this.createHttpConfig(sslConfig), clientConfig.getUseSiteAffinity()) : this._clientFactory.createClient(serverUri, clientConfig.getUseSiteAffinity());
    }

    private HttpConfiguration createHttpConfig(VmomiClientConfiguration.SslConfiguration sslConfig) {
        assert (sslConfig != null);
        HttpConfigurationImpl httpConfig = new HttpConfigurationImpl();
        if (sslConfig.getThumbprintVerifier() != null) {
            httpConfig.setThumbprintVerifier(sslConfig.getThumbprintVerifier());
        }
        if (sslConfig.getTrustStore() != null) {
            httpConfig.setTrustStore(sslConfig.getTrustStore());
        }
        if (sslConfig.getTrustStorePass() != null) {
            httpConfig.getKeyStoreConfig().setTrustStorePassword(sslConfig.getTrustStorePass());
        }
        return httpConfig;
    }
}

