/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.sso.admin.client;

import com.vmware.vim.sso.admin.impl.util.ValidateUtil;
import com.vmware.vim.sso.client.ConfirmationType;
import com.vmware.vim.sso.client.SamlToken;
import java.security.PrivateKey;

public final class ClientConfiguration {
    private final AuthenticationData _authData;
    private final boolean _useSiteAffinity;

    public ClientConfiguration() {
        this._authData = null;
        this._useSiteAffinity = true;
    }

    public ClientConfiguration(AuthenticationData authData) {
        ValidateUtil.validateNotNull((Object)authData, (String)"Authentication data");
        this._authData = authData;
        this._useSiteAffinity = true;
    }

    public ClientConfiguration(boolean useSiteAffinity) {
        this._authData = null;
        this._useSiteAffinity = useSiteAffinity;
    }

    public ClientConfiguration(AuthenticationData authData, boolean useSiteAffinity) {
        ValidateUtil.validateNotNull((Object)authData, (String)"Authentication data");
        this._authData = authData;
        this._useSiteAffinity = useSiteAffinity;
    }

    public AuthenticationData getAuthData() {
        return this._authData;
    }

    public boolean getUseSiteAffinity() {
        return this._useSiteAffinity;
    }

    public static final class AuthenticationData {
        private final SamlToken _authToken;
        private final PrivateKey _hokKey;

        public AuthenticationData(SamlToken authToken) {
            ValidateUtil.validateNotNull((Object)authToken, (String)"Authentication token");
            this.validateTokenType(authToken, ConfirmationType.BEARER);
            this._authToken = authToken;
            this._hokKey = null;
        }

        public AuthenticationData(SamlToken authToken, PrivateKey hokKey) {
            ValidateUtil.validateNotNull((Object)authToken, (String)"Authentication token");
            this.validateTokenType(authToken, ConfirmationType.HOLDER_OF_KEY);
            ValidateUtil.validateNotNull((Object)hokKey, (String)"Token with holder of key confirmation type requires a private key");
            this._authToken = authToken;
            this._hokKey = hokKey;
        }

        public SamlToken getAuthToken() {
            return this._authToken;
        }

        public PrivateKey getHokKey() {
            return this._hokKey;
        }

        private void validateTokenType(SamlToken token, ConfirmationType type) {
            if (!token.getConfirmationType().equals((Object)type)) {
                throw new IllegalArgumentException("The given token does not match the expected confirmation type");
            }
        }
    }
}

