/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.sso.admin.client.common;

import com.vmware.identity.cdc.CdcDCEntry;
import com.vmware.identity.cdc.CdcFactory;
import com.vmware.identity.cdc.CdcSession;
import com.vmware.identity.cdc.CdcState;
import com.vmware.vim.sso.admin.client.common.SiteAffinityEndpointProviderException;
import com.vmware.vim.vmomi.client.ext.ServerEndpointProvider;
import java.net.URI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SiteAffinityServerEndpointProvider
implements ServerEndpointProvider {
    private final URI serverUri;
    private static final int FLAGS = 0;
    private static final Log log = LogFactory.getLog(SiteAffinityServerEndpointProvider.class);

    public SiteAffinityServerEndpointProvider(URI serverUri) {
        this.serverUri = serverUri;
    }

    public URI getServerEndpoint() {
        try {
            return this.getServiceLocationInternal();
        }
        catch (NoClassDefFoundError | UnsatisfiedLinkError e) {
            this.logWarning(String.format("CDC not configured %s", e.toString()));
            return this.serverUri;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private URI getServiceLocationInternal() {
        try (CdcSession cdcSession = CdcFactory.createCdcSessionViaIPC();){
            boolean isSiteAffinityDisabled;
            boolean bl = isSiteAffinityDisabled = cdcSession.getCdcState() == CdcState.CDC_STATE_DISABLED;
            if (isSiteAffinityDisabled) {
                this.logInfo("Site affinity is disabled");
                URI uRI2 = this.serverUri;
                return uRI2;
            }
            URI uRI = this.getDomainController(cdcSession);
            return uRI;
        }
        catch (SiteAffinityEndpointProviderException e) {
            log.error((Object)String.format("Failed to create affinitized URL %s", e.toString()));
            throw e;
        }
        catch (Exception e) {
            this.logWarning(String.format("Failed to create affinitized URL %s", e.toString()));
            return this.serverUri;
        }
    }

    private URI getDomainController(CdcSession cdcSession) {
        try {
            CdcDCEntry domainController = cdcSession.getAffinitizedDC(null, 0);
            this.logInfo(String.format("Site affinity DC name: %s", domainController.dcName));
            URI affinitizedUrl = new URI(this.serverUri.getScheme(), this.serverUri.getUserInfo(), domainController.dcName, this.serverUri.getPort(), this.serverUri.getPath(), this.serverUri.getQuery(), this.serverUri.getFragment());
            return affinitizedUrl;
        }
        catch (Exception e) {
            throw new SiteAffinityEndpointProviderException("Failed to create affinitized URL", e);
        }
    }

    private void logInfo(String message) {
        if (log.isInfoEnabled()) {
            log.info((Object)message);
        }
    }

    private void logWarning(String message) {
        if (log.isWarnEnabled()) {
            log.warn((Object)message);
        }
    }
}

