/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.sso.admin.client.vmomi.impl;

import com.vmware.vim.binding.sso.admin.ConfigurationManagementService;
import com.vmware.vim.sso.PrincipalId;
import com.vmware.vim.sso.admin.client.vmomi.impl.SdkVmodlTypeConversions;
import com.vmware.vim.sso.client.ValidatableSamlToken;
import com.vmware.vim.sso.client.ValidatableSamlTokenEx;
import com.vmware.vim.sso.client.exception.InvalidTokenException;
import java.security.cert.CertPath;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;

public class AdminClientExternalIDPTokenUtil {
    public static PrincipalId getPrincipalId(ValidatableSamlTokenEx token, ConfigurationManagementService cm) throws InvalidTokenException {
        long clockToleranceMs = cm.getClockTolerance();
        CertPath certPath = SdkVmodlTypeConversions.fromVmodl(cm.getExternalIdpTrustedCertificateChain(token.getIssuerNameId().getValue()));
        AdminClientExternalIDPTokenUtil.validateToken((ValidatableSamlToken)token, certPath, clockToleranceMs);
        return AdminClientExternalIDPTokenUtil.constructExternalUserId(token.getSubjectNameId().getValue(), token.getIssuerNameId().getValue());
    }

    public static boolean validateToken(ValidatableSamlToken validatableToken, CertPath certPath, long clockToleranceMs) throws InvalidTokenException {
        ArrayList<Certificate> trustedRoots = new ArrayList<Certificate>();
        List<? extends Certificate> chain = certPath.getCertificates();
        trustedRoots.add(chain.get(0));
        boolean validated = false;
        validatableToken.validate(trustedRoots.toArray(new X509Certificate[0]), clockToleranceMs);
        validated = true;
        return validated;
    }

    private static PrincipalId constructExternalUserId(String subjectNameID, String IdpUID) {
        String UPN_SEPARATOR = "@";
        String NETBIOS_SEPARATOR = "\\";
        String CERTGUID_DOMAIN_SEPARATOR = ".";
        String[] fields = null;
        if (-1 != subjectNameID.indexOf(UPN_SEPARATOR)) {
            fields = subjectNameID.split(UPN_SEPARATOR);
            return new PrincipalId(fields[0], AdminClientExternalIDPTokenUtil.sanitized(IdpUID) + CERTGUID_DOMAIN_SEPARATOR + fields[1]);
        }
        if (-1 != subjectNameID.indexOf(NETBIOS_SEPARATOR)) {
            fields = subjectNameID.split(NETBIOS_SEPARATOR);
            return new PrincipalId(fields[1], AdminClientExternalIDPTokenUtil.sanitized(IdpUID) + CERTGUID_DOMAIN_SEPARATOR + fields[0]);
        }
        return null;
    }

    private static String sanitized(String IdpUID) {
        return IdpUID.replaceAll("\\\\", "").replaceAll(",", "_");
    }
}

